/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.committee.impl.lookup.keyvalue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.kuali.coeus.common.committee.impl.bo.CommitteeBase;
import org.kuali.coeus.sys.framework.keyvalue.KeyValueComparator;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.ValuesFinderUtils;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondenceTemplateBase;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;

public abstract class CommitteeIdValuesFinderBase
extends UifKeyValuesFinderBase {
    private static final long serialVersionUID = -2721177236491755020L;
    private List<ProtocolCorrespondenceTemplateBase> correspondenceTemplates;
    private BusinessObjectService businessObjectService;
    private static final String COMMITTEE_TYPE_CODE = "committeeTypeCode";

    public BusinessObjectService getBusinessObjectService() {
        if (null == this.businessObjectService) {
            this.setBusinessObjectService(KcServiceLocator.getService(BusinessObjectService.class));
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public List<CommitteeBase> getActiveCommittees() {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put(COMMITTEE_TYPE_CODE, this.getCommitteeTypeCodeHook());
        ArrayList<CommitteeBase> returnCommitteeList = new ArrayList<CommitteeBase>();
        Collection committees = this.getBusinessObjectService().findMatching(this.getCommitteeBOClassHook(), criteria);
        if (CollectionUtils.isNotEmpty((Collection)committees)) {
            ArrayList<String> committeeIds = new ArrayList<String>();
            Collections.sort((List)committees, Collections.reverseOrder());
            for (CommitteeBase committee : committees) {
                if (committeeIds.contains(committee.getCommitteeId())) continue;
                returnCommitteeList.add(committee);
                committeeIds.add(committee.getCommitteeId());
            }
        }
        return returnCommitteeList;
    }

    protected abstract Class<? extends CommitteeBase> getCommitteeBOClassHook();

    protected abstract String getCommitteeTypeCodeHook();

    public List<KeyValue> getKeyValues() {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        List<CommitteeBase> committees = this.getActiveCommittees();
        if (CollectionUtils.isNotEmpty(committees)) {
            List<String> excludedCommitteeIds = this.getExcludedCommitteeIds();
            for (CommitteeBase committee : committees) {
                if (excludedCommitteeIds.contains(committee.getCommitteeId())) continue;
                keyValues.add((KeyValue)new ConcreteKeyValue(committee.getCommitteeId(), committee.getCommitteeName()));
            }
            Collections.sort(keyValues, new KeyValueComparator());
        }
        keyValues.add(0, ValuesFinderUtils.getSelectOption());
        return keyValues;
    }

    private List<String> getExcludedCommitteeIds() {
        ArrayList<String> committeeIds = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(this.correspondenceTemplates)) {
            for (ProtocolCorrespondenceTemplateBase correspondenceTemplate : this.correspondenceTemplates) {
                committeeIds.add(correspondenceTemplate.getCommitteeId());
            }
        }
        return committeeIds;
    }

    public List<ProtocolCorrespondenceTemplateBase> getCorrespondenceTemplates() {
        return this.correspondenceTemplates;
    }

    public void setCorrespondenceTemplates(List<ProtocolCorrespondenceTemplateBase> correspondenceTemplates) {
        this.correspondenceTemplates = correspondenceTemplates;
    }
}

