/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.attachment;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.attachment.KcAttachmentDataDao;
import org.kuali.coeus.common.framework.attachment.KcAttachmentDataDaoConversion;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class KcAttachmentDataDaoConversionImpl
extends QuartzJobBean
implements KcAttachmentDataDaoConversion {
    private static final Logger LOG = LogManager.getLogger(KcAttachmentDataDaoConversionImpl.class);
    private KcAttachmentDataDao kcAttachmentDataDao;
    private String tableName;
    private String blobColumn;
    private String fileDataIdColumn;
    private String primaryKeyColumn;
    private Integer fetchSize = 5;
    private DataSource dataSource;
    private String querySql;
    private String updateSql;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void executeInternal(JobExecutionContext context) throws JobExecutionException {
        LOG.info("Starting attachment conversion job for " + this.tableName);
        if (this.querySql == null) {
            this.querySql = "select " + this.primaryKeyColumn + ", " + this.blobColumn + " from " + this.tableName + " where " + this.blobColumn + " is not null";
        }
        if (this.updateSql == null) {
            this.updateSql = "update " + this.tableName + " set " + this.fileDataIdColumn + " = ?, " + this.blobColumn + " = null where " + this.primaryKeyColumn + " = ?";
        }
        boolean hasResults = true;
        while (hasResults) {
            try {
                Connection conn = this.dataSource.getConnection();
                try {
                    PreparedStatement queryStmt = conn.prepareStatement(this.querySql, 1004, 1007);
                    try {
                        PreparedStatement updateStmt = conn.prepareStatement(this.updateSql);
                        try {
                            block37: {
                                conn.setAutoCommit(false);
                                hasResults = false;
                                queryStmt.setFetchSize(Integer.MIN_VALUE);
                                queryStmt.setMaxRows(this.fetchSize);
                                try {
                                    ResultSet rs = queryStmt.executeQuery();
                                    while (true) {
                                        block36: {
                                            if (!rs.next()) break;
                                            LOG.debug(String.format("Saving %s row with %s = %d to S3", this.tableName, this.primaryKeyColumn, rs.getBigDecimal(this.primaryKeyColumn).intValue()));
                                            String fileDataId = null;
                                            if (ArrayUtils.isEmpty((byte[])rs.getBytes(this.blobColumn))) {
                                                LOG.warn(String.format("%s row with %s = %d has no content", this.tableName, this.primaryKeyColumn, rs.getBigDecimal(this.primaryKeyColumn).intValue()));
                                            } else {
                                                fileDataId = this.kcAttachmentDataDao.saveData(rs.getBytes(this.blobColumn), null);
                                            }
                                            updateStmt.setString(1, fileDataId);
                                            updateStmt.setObject(2, rs.getObject(this.primaryKeyColumn));
                                            int numUpdated = updateStmt.executeUpdate();
                                            if (numUpdated == 1) break block36;
                                            LOG.error("Expected to update a single row, but instead updated " + numUpdated + ". Job exiting.");
                                            conn.rollback();
                                            if (rs == null) return;
                                            rs.close();
                                            return;
                                        }
                                        hasResults = true;
                                        continue;
                                        break;
                                    }
                                    if (rs != null) {
                                        rs.close();
                                    }
                                    break block37;
                                    catch (Throwable throwable) {
                                        if (rs == null) throw throwable;
                                        try {
                                            rs.close();
                                            throw throwable;
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                        throw throwable;
                                    }
                                }
                                catch (SQLException e) {
                                    conn.rollback();
                                    throw e;
                                }
                            }
                            conn.commit();
                            Thread.sleep(500L);
                        }
                        finally {
                            if (updateStmt == null) continue;
                            updateStmt.close();
                        }
                    }
                    finally {
                        if (queryStmt == null) continue;
                        queryStmt.close();
                    }
                }
                finally {
                    if (conn == null) continue;
                    conn.close();
                }
            }
            catch (SQLException e) {
                LOG.error("Got sql exception in attachment conversion, job exiting.", (Throwable)e);
                return;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        LOG.info("Finishing attachment conversion job for " + this.tableName);
    }

    public KcAttachmentDataDao getKcAttachmentDataDao() {
        return this.kcAttachmentDataDao;
    }

    public void setKcAttachmentDataDao(KcAttachmentDataDao kcAttachmentDataDao) {
        this.kcAttachmentDataDao = kcAttachmentDataDao;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getBlobColumn() {
        return this.blobColumn;
    }

    public void setBlobColumn(String blobColumn) {
        this.blobColumn = blobColumn;
    }

    public String getFileDataIdColumn() {
        return this.fileDataIdColumn;
    }

    public void setFileDataIdColumn(String fileDataIdColumn) {
        this.fileDataIdColumn = fileDataIdColumn;
    }

    public String getQuerySql() {
        return this.querySql;
    }

    public void setQuerySql(String querySql) {
        this.querySql = querySql;
    }

    public String getUpdateSql() {
        return this.updateSql;
    }

    public void setUpdateSql(String updateSql) {
        this.updateSql = updateSql;
    }

    public String getPrimaryKeyColumn() {
        return this.primaryKeyColumn;
    }

    public void setPrimaryKeyColumn(String primaryKeyColumn) {
        this.primaryKeyColumn = primaryKeyColumn;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Integer getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(Integer fetchSize) {
        this.fetchSize = fetchSize;
    }
}

