/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.elasticsearch;

import org.kuali.coeus.elasticsearch.ElasticsearchIndexService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.exception.ValidationException;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.service.impl.DocumentServiceImpl;

public class ElasticsearchIndexingDocumentServiceImpl
extends DocumentServiceImpl {
    private ElasticsearchIndexService elasticsearchIndexService;

    public Document saveDocument(Document document, DocumentEvent event) throws WorkflowException {
        Document savedDoc = super.saveDocument(document, event);
        this.indexDocument(document);
        return savedDoc;
    }

    public Document saveDocument(Document document, Class<? extends DocumentEvent> kualiDocumentEventClass) throws WorkflowException, ValidationException {
        Document savedDoc = super.saveDocument(document, kualiDocumentEventClass);
        this.indexDocument(document);
        return savedDoc;
    }

    protected void indexDocument(Document document) {
        if (this.isElasticsearchEnabled()) {
            this.getElasticsearchIndexService().index(document);
        }
    }

    public boolean isElasticsearchEnabled() {
        return this.kualiConfigurationService.getPropertyValueAsBoolean("elasticsearch.enabled");
    }

    public ElasticsearchIndexService getElasticsearchIndexService() {
        if (this.elasticsearchIndexService == null) {
            this.elasticsearchIndexService = KcServiceLocator.getService(ElasticsearchIndexService.class);
        }
        return this.elasticsearchIndexService;
    }

    public void setElasticsearchIndexService(ElasticsearchIndexService elasticsearchIndexService) {
        this.elasticsearchIndexService = elasticsearchIndexService;
    }
}

