/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.api.sponsor.hierarchy.SponsorHierarchyService;
import org.kuali.coeus.common.framework.version.history.VersionHistory;
import org.kuali.coeus.common.framework.version.history.VersionHistoryService;
import org.kuali.coeus.propdev.api.core.SubmissionInfoService;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.core.ProposalTypeService;
import org.kuali.coeus.propdev.impl.s2s.S2sAppSubmission;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.proposaladmindetails.ProposalAdminDetails;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.LegacyDataAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="submissionInfoService")
public class SubmissionInfoServiceImpl
implements SubmissionInfoService {
    private static final String FEDERAL_ID_COMES_FROM_CURRENT_AWARD = "FEDERAL_ID_COMES_FROM_CURRENT_AWARD";
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="versionHistoryService")
    private VersionHistoryService versionHistoryService;
    @Autowired
    @Qualifier(value="sponsorHierarchyService")
    private SponsorHierarchyService sponsorHierarchyService;
    @Autowired
    @Qualifier(value="legacyDataAdapter")
    private LegacyDataAdapter legacyDataAdapter;
    @Autowired
    @Qualifier(value="proposalTypeService")
    private ProposalTypeService proposalTypeService;
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;

    public String getFederalId(String proposalNumber) {
        if (StringUtils.isBlank((CharSequence)proposalNumber)) {
            throw new IllegalArgumentException("proposalNumber is blank");
        }
        DevelopmentProposal proposal = (DevelopmentProposal)this.getDataObjectService().find(DevelopmentProposal.class, (Object)proposalNumber);
        InstitutionalProposal institutionalProposal = StringUtils.isNotBlank((CharSequence)proposal.getContinuedFrom()) ? this.getProposalContinuedFromVersion(proposal.getContinuedFrom()) : null;
        String federalId = null;
        if (proposal.hasS2sOpportunity() && this.isSubmissionTypeChangeCorrected(proposal.getS2sOpportunity().getS2sSubmissionTypeCode())) {
            String ggTracking;
            federalId = institutionalProposal != null ? (StringUtils.isNotBlank((CharSequence)(ggTracking = this.getGgTrackingIdFromProposal(institutionalProposal.getProposalId()))) ? ggTracking : proposal.getPrevGrantsGovTrackingID()) : proposal.getPrevGrantsGovTrackingID();
        } else if (this.isProposalTypeRenewalRevisionContinuation(proposal.getProposalTypeCode())) {
            if (StringUtils.isNotBlank((CharSequence)proposal.getSponsorProposalNumber())) {
                federalId = proposal.getSponsorProposalNumber();
            } else if (institutionalProposal != null && StringUtils.isNotBlank((CharSequence)institutionalProposal.getSponsorProposalNumber())) {
                federalId = institutionalProposal.getSponsorProposalNumber();
            } else if (this.getParameterService().getParameterValueAsBoolean(ProposalDevelopmentDocument.class, FEDERAL_ID_COMES_FROM_CURRENT_AWARD).booleanValue()) {
                Award currentAward;
                Award award = currentAward = StringUtils.isNotBlank((CharSequence)proposal.getCurrentAwardNumber()) ? this.getProposalCurrentAwardVersion(proposal.getCurrentAwardNumber()) : null;
                if (currentAward != null && StringUtils.isNotBlank((CharSequence)currentAward.getSponsorAwardNumber())) {
                    federalId = currentAward.getSponsorAwardNumber();
                }
            }
        } else if (this.isProposalTypeNew(proposal.getProposalTypeCode())) {
            if (StringUtils.isNotBlank((CharSequence)proposal.getSponsorProposalNumber())) {
                federalId = proposal.getSponsorProposalNumber();
            } else if (institutionalProposal != null && StringUtils.isNotBlank((CharSequence)institutionalProposal.getSponsorProposalNumber())) {
                federalId = institutionalProposal.getSponsorProposalNumber();
            }
        } else if (this.isProposalTypeResubmission(proposal.getProposalTypeCode())) {
            if (proposal.getSponsorCode().equals(this.getParameterService().getParameterValueAsString("KC-GEN", "All", "NSF_SPONSOR_CODE"))) {
                federalId = null;
            } else if (StringUtils.isNotBlank((CharSequence)proposal.getSponsorProposalNumber())) {
                federalId = proposal.getSponsorProposalNumber();
            } else if (institutionalProposal != null && StringUtils.isNotBlank((CharSequence)institutionalProposal.getSponsorProposalNumber())) {
                federalId = institutionalProposal.getSponsorProposalNumber();
            }
        }
        if (federalId != null && this.getSponsorHierarchyService().isSponsorNihMultiplePi(proposal.getSponsorCode())) {
            return this.fromatFederalId(federalId);
        }
        return federalId;
    }

    public String getGgTrackingIdFromProposal(Long proposalId) {
        if (proposalId == null) {
            throw new IllegalArgumentException("proposalId is null");
        }
        DevelopmentProposal newestDevProp = this.getNewestDevPropFromInstProp(proposalId);
        if (newestDevProp != null && newestDevProp.hasS2sOpportunity()) {
            S2sAppSubmission appSubmission = null;
            int submissionNo = 0;
            for (S2sAppSubmission s2AppSubmission : newestDevProp.getS2sAppSubmission()) {
                if (s2AppSubmission.getSubmissionNumber() <= submissionNo || !StringUtils.isNotBlank((CharSequence)s2AppSubmission.getGgTrackingId())) continue;
                appSubmission = s2AppSubmission;
                submissionNo = s2AppSubmission.getSubmissionNumber();
            }
            if (appSubmission != null) {
                return appSubmission.getGgTrackingId();
            }
            return null;
        }
        return null;
    }

    public String getProposalCurrentAwardSponsorAwardNumber(String currentAwardNumber) {
        if (StringUtils.isBlank((CharSequence)currentAwardNumber)) {
            throw new IllegalArgumentException("currentAwardNumber is blank");
        }
        Award award = this.getProposalCurrentAwardVersion(currentAwardNumber);
        return award != null ? award.getSponsorAwardNumber() : null;
    }

    private DevelopmentProposal getNewestDevPropFromInstProp(Long proposalId) {
        List details = this.getDataObjectService().findMatching(ProposalAdminDetails.class, QueryByCriteria.Builder.andAttributes(Collections.singletonMap("instProposalId", proposalId)).setOrderByAscending(new String[]{"devProposalNumber"}).build()).getResults();
        if (details.size() > 1) {
            ProposalAdminDetails curDetail = (ProposalAdminDetails)details.get(details.size() - 2);
            DevelopmentProposal proposal = (DevelopmentProposal)this.getDataObjectService().find(DevelopmentProposal.class, (Object)curDetail.getDevProposalNumber());
            List s2sSubmissionDetails = this.getDataObjectService().findMatching(S2sAppSubmission.class, QueryByCriteria.Builder.andAttributes(Collections.singletonMap("proposalNumber", proposal.getProposalNumber())).setOrderByAscending(new String[]{"proposalNumber"}).build()).getResults();
            proposal.setS2sAppSubmission(new ArrayList<S2sAppSubmission>(s2sSubmissionDetails));
            return proposal;
        }
        if (details.size() == 1) {
            ProposalAdminDetails curDetail = (ProposalAdminDetails)details.get(0);
            DevelopmentProposal proposal = (DevelopmentProposal)this.getDataObjectService().find(DevelopmentProposal.class, (Object)curDetail.getDevProposalNumber());
            List s2sSubmissionDetails = this.getDataObjectService().findMatching(S2sAppSubmission.class, QueryByCriteria.Builder.andAttributes(Collections.singletonMap("proposalNumber", proposal.getProposalNumber())).setOrderByAscending(new String[]{"proposalNumber"}).build()).getResults();
            proposal.setS2sAppSubmission(new ArrayList<S2sAppSubmission>(s2sSubmissionDetails));
            return proposal;
        }
        return null;
    }

    private InstitutionalProposal getProposalContinuedFromVersion(String continuedFromProposalNumber) {
        VersionHistory vh = this.getVersionHistoryService().findActiveVersion(InstitutionalProposal.class, continuedFromProposalNumber);
        InstitutionalProposal ip = null;
        if (vh != null) {
            ip = (InstitutionalProposal)vh.getSequenceOwner();
        } else if (StringUtils.isNotEmpty((CharSequence)continuedFromProposalNumber)) {
            HashMap<String, String> valueMap = new HashMap<String, String>();
            valueMap.put("proposalNumber", continuedFromProposalNumber);
            List proposals = (List)this.getLegacyDataAdapter().findMatching(InstitutionalProposal.class, valueMap);
            if (proposals != null && !proposals.isEmpty()) {
                ip = (InstitutionalProposal)proposals.get(0);
            }
        }
        return ip;
    }

    public String getProposalContinuedFromVersionSponsorProposalNumber(String continuedFromProposalNumber) {
        if (StringUtils.isBlank((CharSequence)continuedFromProposalNumber)) {
            throw new IllegalArgumentException("continuedFromProposalNumber is blank");
        }
        InstitutionalProposal ip = this.getProposalContinuedFromVersion(continuedFromProposalNumber);
        return ip != null ? ip.getSponsorProposalNumber() : null;
    }

    public Long getProposalContinuedFromVersionProposalId(String continuedFromProposalNumber) {
        if (StringUtils.isBlank((CharSequence)continuedFromProposalNumber)) {
            throw new IllegalArgumentException("continuedFromProposalNumber is blank");
        }
        InstitutionalProposal ip = this.getProposalContinuedFromVersion(continuedFromProposalNumber);
        return ip != null ? ip.getProposalId() : null;
    }

    private boolean isSubmissionTypeChangeCorrected(String submissionTypeCode) {
        return StringUtils.equalsIgnoreCase((CharSequence)submissionTypeCode, (CharSequence)this.parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, "s2s.submissiontype.changedCorrected"));
    }

    private boolean isProposalTypeRenewalRevisionContinuation(String proposalTypeCode) {
        return this.getProposalTypeService().isProposalTypeRenewalRevisionContinuation(proposalTypeCode);
    }

    private boolean isProposalTypeResubmission(String proposalTypeCode) {
        return !StringUtils.isEmpty((CharSequence)proposalTypeCode) && proposalTypeCode.equals(this.getProposalTypeService().getResubmissionProposalTypeCode());
    }

    private boolean isProposalTypeNew(String proposalTypeCode) {
        return !StringUtils.isEmpty((CharSequence)proposalTypeCode) && proposalTypeCode.equals(this.getProposalTypeService().getNewProposalTypeCode());
    }

    private String fromatFederalId(String federalId) {
        int in;
        if (federalId.length() > 7 && (in = federalId.indexOf(45, 8)) != -1) {
            federalId = federalId.substring(6, in);
        }
        return federalId;
    }

    private Award getProposalCurrentAwardVersion(String currentAwardNumber) {
        VersionHistory vh = this.getVersionHistoryService().findActiveVersion(Award.class, currentAwardNumber);
        Award award = null;
        if (vh != null) {
            award = (Award)vh.getSequenceOwner();
        } else {
            HashMap<String, String> valueMap = new HashMap<String, String>();
            valueMap.put("awardNumber", currentAwardNumber);
            List awards = (List)this.getBusinessObjectService().findMatching(Award.class, valueMap);
            if (awards != null && !awards.isEmpty()) {
                award = (Award)awards.get(0);
            }
        }
        return award;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public VersionHistoryService getVersionHistoryService() {
        return this.versionHistoryService;
    }

    public void setVersionHistoryService(VersionHistoryService versionHistoryService) {
        this.versionHistoryService = versionHistoryService;
    }

    public SponsorHierarchyService getSponsorHierarchyService() {
        return this.sponsorHierarchyService;
    }

    public void setSponsorHierarchyService(SponsorHierarchyService sponsorHierarchyService) {
        this.sponsorHierarchyService = sponsorHierarchyService;
    }

    public LegacyDataAdapter getLegacyDataAdapter() {
        return this.legacyDataAdapter;
    }

    public void setLegacyDataAdapter(LegacyDataAdapter legacyDataAdapter) {
        this.legacyDataAdapter = legacyDataAdapter;
    }

    public ProposalTypeService getProposalTypeService() {
        return this.proposalTypeService;
    }

    public void setProposalTypeService(ProposalTypeService proposalTypeService) {
        this.proposalTypeService = proposalTypeService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

