/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.auth;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.sys.framework.auth.AuthTokenResponseDto;
import org.kuali.coeus.sys.framework.auth.AuthUser;
import org.kuali.coeus.sys.framework.auth.CoreImpersonation;
import org.kuali.coeus.sys.framework.auth.JwtService;
import org.kuali.coeus.sys.framework.rest.AuthServiceRestUtilService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;

public class AuthServiceFilter
implements Filter {
    private static final String ADMIN_ROLE = "admin";
    private static final String CURRENT_USER_APPEND = "/current";
    private static final String TOKEN_APPEND = "/auth/token";
    private static final String SECONDS_TO_CACHE_AUTH_TOKEN_RESPONSE_CONFIG = "secondsToCacheAuthTokenResponse";
    private static final String BASIC_AUTH_KC_USERNAME = "admin";
    private static final long SECONDS_TO_CACHE_AUTH_TOKEN_IN_SESSION_DEFAULT = 300L;
    private static final String ACCESS_DENIED_MESSAGE = "Access Denied";
    private static final String AUTHORIZATION_PREFIX = "Bearer ";
    private static final String AUTHORIZATION_HEADER_NAME = "Authorization";
    private static final String AUTH_TOKEN_COOKIE_NAME = "authToken";
    private static final String CODE_PARAM_NAME = "code";
    private static final String AUTH_REDIRECT_URI = "/auth/authorize";
    private static final String AUTH_CLIENT_ID_PARAM = "auth.client.id";
    private static final String KC_REST_ADMIN_PASSWORD = "kc.rest.admin.password";
    private static final String KC_REST_ADMIN_USERNAME = "kc.rest.admin.username";
    private static final String REST_API_URLS_PARAM = "auth.rest.urls.regex";
    private static final String ALLOW_MISSING_ADMINS_TO_PROXY_ADMIN_ACCOUNT = "auth.filter.allow.admin.proxy";
    private static final String AUTH_ADMIN_PROXY_USER = "auth.filter.proxy.username";
    private static final String SERVICE_USER = "auth.filter.service2service.username";
    private static final String AUTH_IMPERSONATION_LOGGING = "auth.impersonation.logging";
    private static final Logger LOG = LogManager.getLogger(AuthServiceFilter.class);
    private static final String GRANT_TYPE = "grant_type";
    private static final String AUTHORIZATION_CODE = "authorization_code";
    private static final String CLIENT_ID = "client_id";
    private static final String AUTH_CODE_PARAM = "code";
    private static final String REDIRECT_URI = "redirect_uri";
    private static final String AUTH_STATE = "state";
    private static final String RESPONSE_TYPE = "response_type";
    private static final String AUTH_SERVICE_FILTER_REQ_VER_TOKEN = "AUTH_SERVICE_FILTER_REQ_VER_TOKEN";
    private static final String AUTH_SERVICE_FILTER_REDIRECT_URI = "AUTH_SERVICE_FILTER_REDIRECT_URI";
    static final String AUTH_SERVICE_FILTER_IS_SERVICE_USER = "AUTH_SERVICE_FILTER_IS_SERVICE_USER";
    static final String AUTH_SERVICE_FILTER_AUTHED_USER_ATTR = "AUTH_SERVICE_FILTER_AUTHED_USER";
    public static final String AUTH_SERVICE_FILTER_AUTH_TOKEN_SESSION_ATTR = "AUTH_SERVICE_FILTER_AUTH_TOKEN";
    private String authClientId;
    private String authRedirectURI;
    private String getCurrentUserUrl;
    private String fetchTokenUrl;
    private String hashedApiAdminBasicAuth;
    private List<Pattern> restUrlsRegex;
    private Boolean allowAdminProxy = Boolean.FALSE;
    private String adminProxyUsername;
    private String serviceProxyUsername;
    private long secondsToCacheAuthTokenInSession = 300L;
    private ConfigurationService configurationService;
    private RestOperations restTemplate;
    private AuthServiceRestUtilService authServiceRestUtilService;
    private IdentityService identityService;
    private BusinessObjectService businessObjectService;
    private ParameterService parameterService;
    private JwtService jwtService;

    public void init(FilterConfig filterConfig) {
        String secondsToCache = filterConfig.getInitParameter(SECONDS_TO_CACHE_AUTH_TOKEN_RESPONSE_CONFIG);
        if (secondsToCache != null) {
            this.secondsToCacheAuthTokenInSession = Long.parseLong(secondsToCache);
        }
        String authServiceUrl = this.getConfigurationService().getPropertyValueAsString("auth.base.url");
        this.authRedirectURI = authServiceUrl + AUTH_REDIRECT_URI;
        this.getCurrentUserUrl = this.getConfigurationService().getPropertyValueAsString("auth.users.url") + CURRENT_USER_APPEND;
        this.fetchTokenUrl = authServiceUrl + TOKEN_APPEND;
        this.allowAdminProxy = this.getConfigurationService().getPropertyValueAsBoolean(ALLOW_MISSING_ADMINS_TO_PROXY_ADMIN_ACCOUNT);
        this.adminProxyUsername = this.getConfigurationService().getPropertyValueAsString(AUTH_ADMIN_PROXY_USER);
        this.serviceProxyUsername = this.getConfigurationService().getPropertyValueAsString(SERVICE_USER);
        this.restUrlsRegex = this.buildRestUrlRegexPatterns(this.getConfigurationService().getPropertyValueAsString(REST_API_URLS_PARAM));
        this.authClientId = this.getConfigurationService().getPropertyValueAsString(AUTH_CLIENT_ID_PARAM);
        String apiUserName = this.getConfigurationService().getPropertyValueAsString(KC_REST_ADMIN_USERNAME);
        String apiPassword = this.getConfigurationService().getPropertyValueAsString(KC_REST_ADMIN_PASSWORD);
        if (StringUtils.isNotBlank((CharSequence)apiUserName) && StringUtils.isNotBlank((CharSequence)apiPassword)) {
            this.hashedApiAdminBasicAuth = "Basic " + new String(Base64.getEncoder().encode((apiUserName + ":" + apiPassword).getBytes()));
        }
    }

    protected List<Pattern> buildRestUrlRegexPatterns(String restUrlPatterns) {
        return Arrays.stream(restUrlPatterns.split(",")).map(Pattern::compile).collect(Collectors.toList());
    }

    protected boolean isUrlForRest(String requestUrl) {
        return this.restUrlsRegex.stream().anyMatch(pattern -> pattern.matcher(requestUrl).matches());
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (this.isUrlForRest(httpRequest.getRequestURI())) {
            this.authenticateBasedOnAuthorizationHeader(httpRequest.getHeader(AUTHORIZATION_HEADER_NAME), httpRequest, httpResponse, chain);
        } else {
            this.authenticateWebBasedUser(chain, httpRequest, httpResponse);
        }
    }

    protected void authenticateWebBasedUser(FilterChain chain, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        Optional<Cookie> authTokenCookie = this.findAuthTokenCookie(httpRequest);
        if (authTokenCookie.isPresent()) {
            Optional<AuthUser> authUser = this.getAuthUser(authTokenCookie.get().getValue(), httpRequest);
            if (authUser.isPresent()) {
                this.continueFilterChain(chain, httpRequest, httpResponse, authUser.get().getUsername());
                return;
            }
            this.invalidateAuthTokenCookie(httpRequest, httpResponse);
        } else if (httpRequest.getParameterMap().containsKey("code") && httpRequest.getParameterMap().containsKey(AUTH_STATE)) {
            String savedState = (String)httpRequest.getSession().getAttribute(AUTH_SERVICE_FILTER_REQ_VER_TOKEN);
            LOG.debug("Saved auth state from session: " + savedState);
            if (savedState != null && savedState.equals(httpRequest.getParameter(AUTH_STATE))) {
                Optional<AuthTokenResponseDto> authTokenResponseDto = this.fetchTokenFromCode(httpRequest.getParameter("code"), httpRequest);
                if (authTokenResponseDto.isPresent()) {
                    String authTokenValue = authTokenResponseDto.get().getAuthToken();
                    Optional<AuthUser> authUser = this.getAuthUser(authTokenValue, httpRequest);
                    if (authUser.isPresent()) {
                        this.addAuthTokenCookie(httpRequest, httpResponse, authTokenValue);
                        this.continueFilterChain(chain, httpRequest, httpResponse, authUser.get().getUsername());
                        return;
                    }
                } else {
                    LOG.debug("No token returned with code: " + httpRequest.getParameter("code"));
                }
            }
        }
        this.redirectToLogin(httpRequest, httpResponse);
    }

    private void continueFilterChain(FilterChain chain, HttpServletRequest httpRequest, HttpServletResponse httpResponse, String username) throws IOException, ServletException {
        chain.doFilter((ServletRequest)new AuthServiceRequestWrapper(username, httpRequest), (ServletResponse)httpResponse);
    }

    private Cookie createAuthTokenCookie(HttpServletRequest httpRequest, String authTokenValue, int maxAge) {
        Cookie authCookie = new Cookie(AUTH_TOKEN_COOKIE_NAME, authTokenValue);
        authCookie.setDomain(httpRequest.getServerName());
        authCookie.setPath("/");
        authCookie.setSecure(httpRequest.isSecure());
        authCookie.setMaxAge(maxAge);
        return authCookie;
    }

    private void invalidateAuthTokenCookie(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        httpResponse.addCookie(this.createAuthTokenCookie(httpRequest, "", 0));
    }

    private void addAuthTokenCookie(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String authTokenValue) {
        httpResponse.addCookie(this.createAuthTokenCookie(httpRequest, authTokenValue, -1));
    }

    private Optional<Cookie> findAuthTokenCookie(HttpServletRequest httpRequest) {
        return Optional.ofNullable(httpRequest.getCookies()).flatMap(cookies -> Stream.of(cookies).filter(cookie -> cookie.getName().equals(AUTH_TOKEN_COOKIE_NAME)).findFirst());
    }

    protected Optional<AuthUser> getAuthUser(String authTokenValue, HttpServletRequest httpRequest) {
        AuthUser authedUser;
        try {
            authedUser = this.validateAuthToken(authTokenValue, httpRequest);
        }
        catch (RuntimeException e) {
            LOG.warn("Error validating auth token", (Throwable)e);
            return Optional.empty();
        }
        if (authedUser != null && StringUtils.isNotBlank((CharSequence)authedUser.getUsername())) {
            return Optional.of(this.proxyAdminUsers(authedUser));
        }
        return Optional.empty();
    }

    protected void authenticateBasedOnAuthorizationHeader(String authorizationHeader, HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain chain) throws IOException, ServletException {
        AuthUser authedUser;
        if (this.hashedApiAdminBasicAuth != null && this.hashedApiAdminBasicAuth.equals(authorizationHeader)) {
            this.continueFilterChain(chain, httpRequest, httpResponse, "admin");
            return;
        }
        if (authorizationHeader != null && authorizationHeader.startsWith(AUTHORIZATION_PREFIX) && (authedUser = this.validateAuthToken(authorizationHeader, httpRequest)) != null) {
            authedUser = this.proxyAdminUsers(authedUser);
            this.continueFilterChain(chain, httpRequest, httpResponse, authedUser.getUsername());
            return;
        }
        httpResponse.sendError(403, ACCESS_DENIED_MESSAGE);
    }

    protected void redirectToLogin(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        try {
            String redirectUri = this.getRedirectUri(httpRequest);
            httpRequest.getSession().setAttribute(AUTH_SERVICE_FILTER_REDIRECT_URI, (Object)redirectUri);
            String requestVerificationToken = UUID.randomUUID().toString();
            httpRequest.getSession().setAttribute(AUTH_SERVICE_FILTER_REQ_VER_TOKEN, (Object)requestVerificationToken);
            URIBuilder uriBuilder = new URIBuilder(this.authRedirectURI);
            uriBuilder.addParameter(CLIENT_ID, this.authClientId);
            uriBuilder.addParameter(AUTH_STATE, requestVerificationToken);
            uriBuilder.addParameter(RESPONSE_TYPE, "code");
            uriBuilder.addParameter(REDIRECT_URI, redirectUri);
            httpResponse.sendRedirect(uriBuilder.toString());
        }
        catch (URISyntaxException e) {
            throw new ConfigurationException("authentication url is invalid: " + this.authRedirectURI, (Throwable)e);
        }
    }

    protected String getRedirectUri(HttpServletRequest httpRequest) throws URISyntaxException {
        List<String> filteredKeys = List.of(AUTH_STATE, "code");
        URIBuilder uriBuilder = new URIBuilder(httpRequest.getRequestURL().toString());
        List filteredParams = URLEncodedUtils.parse((String)httpRequest.getQueryString(), (Charset)StandardCharsets.UTF_8).stream().filter(nameValuePair -> !filteredKeys.contains(nameValuePair.getName())).collect(Collectors.toList());
        if (!filteredParams.isEmpty()) {
            uriBuilder.setParameters(filteredParams);
        }
        return uriBuilder.toString();
    }

    protected AuthUser validateAuthToken(String authTokenValue, HttpServletRequest request) {
        AuthUser authedUser = (AuthUser)request.getSession().getAttribute(AUTH_SERVICE_FILTER_AUTHED_USER_ATTR);
        if (authedUser != null && StringUtils.equals((CharSequence)authedUser.getAuthToken(), (CharSequence)authTokenValue) && authedUser.getLastValidated().plus(this.secondsToCacheAuthTokenInSession, ChronoUnit.SECONDS).isAfter(Instant.now())) {
            return authedUser;
        }
        request.getSession().removeAttribute(AUTH_SERVICE_FILTER_AUTHED_USER_ATTR);
        if (this.getJwtService().verifyToken(authTokenValue)) {
            authedUser = this.createServiceUser();
            request.getSession().setAttribute(AUTH_SERVICE_FILTER_IS_SERVICE_USER, (Object)true);
        } else {
            String currentGetUserUrl = this.fixUrlFormat(this.getCurrentUserUrl, request);
            ResponseEntity result = this.getRestTemplate().exchange(currentGetUserUrl, HttpMethod.GET, new HttpEntity((MultiValueMap)this.getAuthServiceRestUtilService().getAuthServiceStyleHttpHeadersForToken(authTokenValue)), AuthUser.class, new Object[0]);
            authedUser = (AuthUser)result.getBody();
            if (authedUser != null) {
                authedUser.setAuthToken(authTokenValue);
                request.getSession().setAttribute(AUTH_SERVICE_FILTER_AUTHED_USER_ATTR, (Object)authedUser);
                request.getSession().setAttribute(AUTH_SERVICE_FILTER_AUTH_TOKEN_SESSION_ATTR, (Object)authTokenValue);
            }
            this.logImpersonation(authedUser, request.getRequestURL().toString());
        }
        return authedUser;
    }

    protected Optional<AuthTokenResponseDto> fetchTokenFromCode(String code, HttpServletRequest request) {
        String fetchUrl = this.fixUrlFormat(this.fetchTokenUrl, request);
        LinkedMultiValueMap parts = new LinkedMultiValueMap();
        parts.add((Object)"code", (Object)code);
        parts.add((Object)GRANT_TYPE, (Object)AUTHORIZATION_CODE);
        parts.add((Object)CLIENT_ID, (Object)this.authClientId);
        parts.add((Object)REDIRECT_URI, (Object)((String)request.getSession().getAttribute(AUTH_SERVICE_FILTER_REDIRECT_URI)));
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity tokenRequest = new HttpEntity((Object)parts, (MultiValueMap)headers);
        try {
            return Optional.ofNullable((AuthTokenResponseDto)this.getRestTemplate().postForObject(fetchUrl, (Object)tokenRequest, AuthTokenResponseDto.class, new Object[0]));
        }
        catch (RestClientException e) {
            LOG.debug("Unable to fetch token using code: " + code, (Throwable)e);
            return Optional.empty();
        }
    }

    private String fixUrlFormat(String url, HttpServletRequest request) {
        return !url.startsWith("http") ? request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + url : url;
    }

    protected AuthUser createServiceUser() {
        if (this.serviceProxyUsername != null) {
            AuthUser authUser = new AuthUser();
            authUser.setUsername(this.serviceProxyUsername);
            return authUser;
        }
        throw new RuntimeException("service2service enabled, but no service user is configured");
    }

    protected AuthUser proxyAdminUsers(AuthUser authUser) {
        if (this.allowAdminProxy.booleanValue() && "admin".equals(authUser.getRole()) && this.getPrincipal(authUser.getUsername()) == null) {
            authUser.setActualUser(authUser.getUsername());
            authUser.setUsername(this.adminProxyUsername);
            LOG.warn("Proxying admin user '" + authUser.getActualUser() + "' to the proxy admin account of '" + this.adminProxyUsername + "'");
        }
        return authUser;
    }

    protected void logImpersonation(AuthUser authUser, String requestedUrl) {
        if (authUser.getImpersonatedBy() != null && this.getParameterService().getParameterValueAsBoolean("KC-SYS", "All", AUTH_IMPERSONATION_LOGGING).booleanValue()) {
            CoreImpersonation impersonation = new CoreImpersonation(authUser, requestedUrl);
            impersonation.setUpdateUser(authUser.getImpersonatedBy());
            this.getBusinessObjectService().save((PersistableBusinessObject)impersonation);
            LOG.warn("User in session'" + authUser.getUsername() + "' is being impersonated by'" + authUser.getImpersonatedBy() + "' as " + authUser.getDisplayName());
        }
    }

    protected Principal getPrincipal(String username) {
        return this.getIdentityService().getPrincipalByPrincipalName(username);
    }

    public void destroy() {
    }

    public ConfigurationService getConfigurationService() {
        if (this.configurationService == null) {
            this.configurationService = KcServiceLocator.getService(ConfigurationService.class);
        }
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public RestOperations getRestTemplate() {
        if (this.restTemplate == null) {
            this.restTemplate = KcServiceLocator.getService(RestOperations.class);
        }
        return this.restTemplate;
    }

    public void setRestTemplate(RestOperations restTemplate) {
        this.restTemplate = restTemplate;
    }

    public AuthServiceRestUtilService getAuthServiceRestUtilService() {
        if (this.authServiceRestUtilService == null) {
            this.authServiceRestUtilService = KcServiceLocator.getService(AuthServiceRestUtilService.class);
        }
        return this.authServiceRestUtilService;
    }

    public void setAuthServiceRestUtilService(AuthServiceRestUtilService authServiceRestUtilService) {
        this.authServiceRestUtilService = authServiceRestUtilService;
    }

    public IdentityService getIdentityService() {
        if (this.identityService == null) {
            this.identityService = KcServiceLocator.getService(IdentityService.class);
        }
        return this.identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public JwtService getJwtService() {
        if (this.jwtService == null) {
            this.jwtService = KcServiceLocator.getService(JwtService.class);
        }
        return this.jwtService;
    }

    public void setJwtService(JwtService jwtService) {
        this.jwtService = jwtService;
    }

    private static class AuthServiceRequestWrapper
    extends HttpServletRequestWrapper {
        private String username;

        public AuthServiceRequestWrapper(String username, HttpServletRequest request) {
            super(request);
            this.username = username;
        }

        public String getRemoteUser() {
            return this.username;
        }
    }
}

