/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.controller.rest.audit;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.sys.framework.controller.rest.audit.RestAuditLog;
import org.kuali.coeus.sys.framework.controller.rest.audit.RestAuditLoggerDao;
import org.kuali.coeus.sys.impl.controller.rest.audit.RestAuditLogDataObject;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="restAuditLoggerDao")
public class RestAuditLoggerDaoImpl
implements RestAuditLoggerDao {
    private static final Logger LOG = LogManager.getLogger(RestAuditLoggerDaoImpl.class);
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    private ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public List<RestAuditLog> getAuditLogsForDataObject(Class<?> dataObjectClass) {
        return this.getRestAuditLogsFromDatabase(dataObjectClass).stream().map(dataObject -> new RestAuditLog(dataObject.getUsername(), dataObject.getDate().toInstant(), dataObject.getClassName(), this.transformJsonToMap(dataObject.getId(), dataObject.getAdded()), this.transformJsonToMap(dataObject.getId(), dataObject.getModified()), this.transformJsonToMap(dataObject.getId(), dataObject.getDeleted()))).collect(Collectors.toList());
    }

    protected List<RestAuditLogDataObject> getRestAuditLogsFromDatabase(Class<?> dataObjectClass) {
        return this.dataObjectService.findMatching(RestAuditLogDataObject.class, QueryByCriteria.Builder.forAttribute((String)"className", (Object)dataObjectClass.getCanonicalName()).build()).getResults();
    }

    protected List<Map<String, Object>> transformJsonToMap(Long id, String json) {
        try {
            return (List)this.objectMapper.readValue(json, (TypeReference)new TypeReference<ArrayList<HashMap<String, Object>>>(){});
        }
        catch (IOException e) {
            LOG.error("Error deserializing audit log json for " + id + " -- '" + json + "'", (Throwable)e);
            return new ArrayList<Map<String, Object>>();
        }
    }

    @Override
    public void saveAuditLog(Class<?> dataObjectClass, RestAuditLog log) {
        try {
            RestAuditLogDataObject dataObject = new RestAuditLogDataObject();
            dataObject.setUsername(log.getUsername());
            dataObject.setDate(Date.from(log.getDate()));
            dataObject.setClassName(dataObjectClass.getCanonicalName());
            dataObject.setAdded(this.transformMapToJson(log.getAdded()));
            dataObject.setModified(this.transformMapToJson(log.getModified()));
            dataObject.setDeleted(this.transformMapToJson(log.getDeleted()));
            this.saveAuditLog(dataObject);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void saveAuditLog(RestAuditLogDataObject dataObject) {
        this.dataObjectService.save((Object)dataObject, new PersistenceOption[0]);
    }

    protected String transformMapToJson(List<Map<String, Object>> changes) throws IOException {
        if (changes == null || changes.size() == 0) {
            return null;
        }
        return this.objectMapper.writeValueAsString(changes);
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

