/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.species;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kra.iacuc.IacucPainCategory;
import org.kuali.kra.iacuc.IacucSpecies;
import org.kuali.kra.iacuc.IacucSpeciesCountType;
import org.kuali.kra.iacuc.species.exception.IacucProtocolException;
import org.kuali.kra.protocol.ProtocolAssociateBase;
import org.kuali.rice.krad.util.ObjectUtils;

public class IacucProtocolSpecies
extends ProtocolAssociateBase {
    private static final long serialVersionUID = 1L;
    private Integer iacucProtocolSpeciesId;
    private Integer speciesId;
    private Integer speciesCode;
    private String speciesGroup;
    private boolean usdaCovered;
    private String strain;
    private Integer speciesCount;
    private Integer painCategoryCode;
    private Integer speciesCountCode;
    private boolean exceptionsPresent;
    private String procedureSummary;
    private IacucSpecies iacucSpecies;
    private IacucSpeciesCountType iacucSpeciesCountType;
    private IacucPainCategory iacucPainCategory;
    private List<IacucProtocolException> iacucProtocolExceptions;
    private transient String groupAndSpecies;
    private transient Integer oldProtocolSpeciesId;

    public IacucProtocolSpecies() {
        this.setIacucProtocolExceptions(new ArrayList<IacucProtocolException>());
    }

    public Integer getIacucProtocolSpeciesId() {
        return this.iacucProtocolSpeciesId;
    }

    public void setIacucProtocolSpeciesId(Integer iacucProtocolSpeciesId) {
        this.iacucProtocolSpeciesId = iacucProtocolSpeciesId;
    }

    public Integer getSpeciesId() {
        return this.speciesId;
    }

    public void setSpeciesId(Integer speciesId) {
        this.speciesId = speciesId;
    }

    public Integer getSpeciesCode() {
        return this.speciesCode;
    }

    public void setSpeciesCode(Integer speciesCode) {
        this.speciesCode = speciesCode;
    }

    public String getSpeciesGroup() {
        return this.speciesGroup;
    }

    public void setSpeciesGroup(String speciesGroup) {
        this.speciesGroup = speciesGroup;
    }

    public boolean getUsdaCovered() {
        return this.usdaCovered;
    }

    public void setUsdaCovered(boolean usdaCovered) {
        this.usdaCovered = usdaCovered;
    }

    public String getStrain() {
        return this.strain;
    }

    public void setStrain(String strain) {
        this.strain = strain;
    }

    public Integer getSpeciesCount() {
        return this.speciesCount;
    }

    public void setSpeciesCount(Integer speciesCount) {
        this.speciesCount = speciesCount;
    }

    public Integer getPainCategoryCode() {
        return this.painCategoryCode;
    }

    public void setPainCategoryCode(Integer painCategoryCode) {
        this.painCategoryCode = painCategoryCode;
    }

    public Integer getSpeciesCountCode() {
        return this.speciesCountCode;
    }

    public void setSpeciesCountCode(Integer speciesCountCode) {
        this.speciesCountCode = speciesCountCode;
    }

    public boolean getExceptionsPresent() {
        return this.exceptionsPresent;
    }

    public void setExceptionsPresent(boolean exceptionsPresent) {
        this.exceptionsPresent = exceptionsPresent;
    }

    @Override
    public void resetPersistenceState() {
        this.setOldProtocolSpeciesId(this.getIacucProtocolSpeciesId());
        this.setIacucProtocolSpeciesId(null);
    }

    public String getProcedureSummary() {
        return this.procedureSummary;
    }

    public void setProcedureSummary(String procedureSummary) {
        this.procedureSummary = procedureSummary;
    }

    public IacucSpecies getIacucSpecies() {
        if (this.iacucSpecies == null) {
            this.refreshReferenceObject("iacucSpecies");
        }
        return this.iacucSpecies;
    }

    public void setIacucSpecies(IacucSpecies iacucSpecies) {
        this.iacucSpecies = iacucSpecies;
    }

    public IacucSpeciesCountType getIacucSpeciesCountType() {
        return this.iacucSpeciesCountType;
    }

    public void setIacucSpeciesCountType(IacucSpeciesCountType iacucSpeciesCountType) {
        this.iacucSpeciesCountType = iacucSpeciesCountType;
    }

    public IacucPainCategory getIacucPainCategory() {
        return this.iacucPainCategory;
    }

    public void setIacucPainCategory(IacucPainCategory iacucPainCategory) {
        this.iacucPainCategory = iacucPainCategory;
    }

    public List<IacucProtocolException> getIacucProtocolExceptions() {
        return this.iacucProtocolExceptions;
    }

    public void setIacucProtocolExceptions(List<IacucProtocolException> iacucProtocolExceptions) {
        this.iacucProtocolExceptions = iacucProtocolExceptions;
    }

    public String getSpeciesName() {
        if (this.iacucSpecies == null) {
            this.refreshReferenceObject("speciesCode");
        }
        return this.iacucSpecies.getSpeciesName();
    }

    public String getCountTypeName() {
        if (this.iacucSpeciesCountType == null) {
            this.refreshReferenceObject("iacucSpeciesCountType");
        }
        return this.iacucSpeciesCountType == null ? "None" : this.iacucSpeciesCountType.getDescription();
    }

    public String getPainCategoryName() {
        if (this.iacucPainCategory == null) {
            this.refreshReferenceObject("iacucPainCategory");
        }
        return this.iacucPainCategory == null ? "None" : this.iacucPainCategory.getPainCategory();
    }

    public String getGroupAndSpecies() {
        if (ObjectUtils.isNull((Object)this.iacucSpecies)) {
            this.refreshReferenceObject("iacucSpecies");
        }
        this.groupAndSpecies = this.speciesGroup.concat(" : ").concat(this.iacucSpecies.getSpeciesName());
        return this.groupAndSpecies;
    }

    public boolean isSameGroupAs(IacucProtocolSpecies other) {
        return StringUtils.equals((CharSequence)this.getSpeciesGroup(), (CharSequence)other.getSpeciesGroup());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.iacucProtocolSpeciesId == null ? 0 : this.iacucProtocolSpeciesId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IacucProtocolSpecies other = (IacucProtocolSpecies)obj;
        return !(this.iacucProtocolSpeciesId == null ? other.iacucProtocolSpeciesId != null : !this.iacucProtocolSpeciesId.equals(other.iacucProtocolSpeciesId));
    }

    public Integer getOldProtocolSpeciesId() {
        return this.oldProtocolSpeciesId;
    }

    public void setOldProtocolSpeciesId(Integer oldProtocolSpeciesId) {
        this.oldProtocolSpeciesId = oldProtocolSpeciesId;
    }
}

