/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.noteattachment;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kra.protocol.noteattachment.ProtocolNotepadBase;
import org.kuali.kra.protocol.noteattachment.ProtocolNotepadService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;

public class ProtocolNotepadServiceImpl
implements ProtocolNotepadService {
    private PersonService personService;
    protected final Logger LOG = LogManager.getLogger(this.getClass());
    private static final String PERSON_NOT_FOUND_FORMAT_STRING = "%s (not found)";

    @Override
    public void setProtocolNotepadUpdateUsersName(List<ProtocolNotepadBase> protocolNotepads) {
        for (ProtocolNotepadBase pnp : protocolNotepads) {
            Person person;
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug(String.format("Looking up person for update user %s.", pnp.getUpdateUser()));
            }
            pnp.setUpdateUserFullName((person = this.personService.getPersonByPrincipalName(pnp.getUpdateUser())) == null ? String.format(PERSON_NOT_FOUND_FORMAT_STRING, pnp.getUpdateUser()) : person.getName());
            if (StringUtils.isNotBlank((CharSequence)pnp.getCreateUser())) {
                Person creator = this.personService.getPersonByPrincipalName(pnp.getCreateUser());
                pnp.setCreateUserFullName(creator == null ? String.format(PERSON_NOT_FOUND_FORMAT_STRING, pnp.getCreateUser()) : creator.getName());
                continue;
            }
            pnp.setCreateUserFullName("");
        }
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }
}

