/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.AttributeDescriptorBase;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.RepositoryTags;
import org.apache.ojb.broker.metadata.XmlCapable;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;

public class ObjectReferenceDescriptor
extends AttributeDescriptorBase
implements XmlCapable {
    private static final long serialVersionUID = 5561562217150972131L;
    public static final int CASCADE_NONE = 17;
    public static final int CASCADE_LINK = 19;
    public static final int CASCADE_OBJECT = 23;
    private Class m_ClassOfItems = null;
    private Vector m_ForeignKeyFields = new Vector();
    private boolean m_CascadeRetrieve = true;
    private int m_CascadeStore = 17;
    private int m_CascadeDelete = 17;
    private int m_ProxyPrefetchingLimit = 50;
    private Class m_ProxyOfItems = null;
    private boolean m_LookedUpProxy = false;
    private boolean m_OtmDependent = false;
    private Hashtable fkFieldMap = new Hashtable();
    private boolean lazy = false;
    private boolean refresh = false;

    public ObjectReferenceDescriptor(ClassDescriptor classDescriptor) {
        super(classDescriptor);
    }

    public Class getItemProxyClass() throws PersistenceBrokerException {
        if (!this.m_LookedUpProxy) {
            this.m_ProxyOfItems = this.getClassDescriptor().getRepository().getDescriptorFor(this.m_ClassOfItems).getProxyClass();
            this.m_LookedUpProxy = true;
        }
        return this.m_ProxyOfItems;
    }

    public FieldDescriptor[] getForeignKeyFieldDescriptors(ClassDescriptor classDescriptor) {
        Vector vector;
        FieldDescriptor[] fieldDescriptorArray = (FieldDescriptor[])this.fkFieldMap.get(classDescriptor);
        if (fieldDescriptorArray == null && (vector = this.getForeignKeyFields()) != null) {
            if (classDescriptor.isInterface()) {
                Vector vector2 = classDescriptor.getExtentClasses();
                Class<Object> clazz = (Class)vector2.get(0);
                classDescriptor = this.getClassDescriptor().getRepository().getDescriptorFor(clazz);
            }
            Vector<FieldDescriptor> vector3 = new Vector<FieldDescriptor>();
            for (Class<Object> clazz : vector) {
                FieldDescriptor fieldDescriptor = null;
                for (ClassDescriptor classDescriptor2 = classDescriptor; classDescriptor2 != null; classDescriptor2 = classDescriptor2.getSuperClassDescriptor()) {
                    if (clazz instanceof Integer) {
                        Integer n = (Integer)((Object)clazz);
                        fieldDescriptor = classDescriptor.getFieldDescriptorByIndex(n);
                    } else {
                        fieldDescriptor = classDescriptor2.getFieldDescriptorByName((String)((Object)clazz));
                    }
                    if (fieldDescriptor != null) break;
                }
                if (fieldDescriptor == null) {
                    throw new OJBRuntimeException("Incorrect or not found field reference name '" + clazz + "' in descriptor " + this + " for class-descriptor '" + (classDescriptor != null ? classDescriptor.getClassNameOfObject() + "'" : "'null'"));
                }
                vector3.add(fieldDescriptor);
            }
            fieldDescriptorArray = vector3.toArray(new FieldDescriptor[vector3.size()]);
            this.fkFieldMap.put(classDescriptor, fieldDescriptorArray);
        }
        return fieldDescriptorArray;
    }

    public Object[] getForeignKeyValues(Object object, ClassDescriptor classDescriptor) throws PersistenceBrokerException {
        FieldDescriptor[] fieldDescriptorArray = this.getForeignKeyFieldDescriptors(classDescriptor);
        if (fieldDescriptorArray.length > 0) {
            object = ProxyHelper.getRealObject(object);
        }
        Object[] objectArray = new Object[fieldDescriptorArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
            PersistentField persistentField = fieldDescriptor.getPersistentField();
            objectArray[i] = persistentField.get(object);
        }
        return objectArray;
    }

    public Class getItemClass() {
        return this.m_ClassOfItems;
    }

    public String getItemClassName() {
        return this.m_ClassOfItems != null ? this.m_ClassOfItems.getName() : null;
    }

    public void setItemClass(Class clazz) {
        this.m_ClassOfItems = clazz;
    }

    public Vector getForeignKeyFields() {
        return this.m_ForeignKeyFields;
    }

    public void setForeignKeyFields(Vector vector) {
        this.m_ForeignKeyFields = vector;
    }

    public void addForeignKeyField(int n) {
        if (this.m_ForeignKeyFields == null) {
            this.m_ForeignKeyFields = new Vector();
        }
        this.m_ForeignKeyFields.add(new Integer(n));
    }

    public void addForeignKeyField(String string) {
        if (this.m_ForeignKeyFields == null) {
            this.m_ForeignKeyFields = new Vector();
        }
        this.m_ForeignKeyFields.add(string);
    }

    public boolean isRefresh() {
        return this.refresh;
    }

    public void setRefresh(boolean bl) {
        this.refresh = bl;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean bl) {
        this.lazy = bl;
    }

    public boolean getCascadeRetrieve() {
        return this.m_CascadeRetrieve;
    }

    public void setCascadeRetrieve(boolean bl) {
        this.m_CascadeRetrieve = bl;
    }

    public int getCascadingStore() {
        return this.m_CascadeStore;
    }

    public void setCascadingStore(int n) {
        this.m_CascadeStore = n;
    }

    public void setCascadingStore(String string) {
        this.setCascadingStore(this.getCascadeStoreValue(string));
    }

    public boolean getCascadeStore() {
        return this.getCascadingStore() == 23;
    }

    public void setCascadeStore(boolean bl) {
        if (bl) {
            this.setCascadingStore(this.getCascadeStoreValue("true"));
        } else {
            this.setCascadingStore(this.getCascadeStoreValue("false"));
        }
    }

    public int getCascadingDelete() {
        return this.m_CascadeDelete;
    }

    public void setCascadingDelete(int n) {
        this.m_CascadeDelete = n;
    }

    public void setCascadingDelete(String string) {
        this.setCascadingDelete(this.getCascadeDeleteValue(string));
    }

    public boolean getCascadeDelete() {
        return this.getCascadingDelete() == 23;
    }

    public void setCascadeDelete(boolean bl) {
        if (bl) {
            this.setCascadingDelete(this.getCascadeDeleteValue("true"));
        } else {
            this.setCascadingDelete(this.getCascadeDeleteValue("false"));
        }
    }

    protected int getCascadeStoreValue(String string) {
        if (string.equalsIgnoreCase("none")) {
            return 17;
        }
        if (string.equalsIgnoreCase("link")) {
            return 19;
        }
        if (string.equalsIgnoreCase("object")) {
            return 23;
        }
        if (string.equalsIgnoreCase("true")) {
            return 23;
        }
        if (string.equalsIgnoreCase("false")) {
            return 19;
        }
        throw new OJBRuntimeException("Invalid value! Given value was '" + string + "', expected values are: " + "none" + ", " + "link" + ", " + "object" + " ('false' and 'true' are deprecated but still valid)");
    }

    protected int getCascadeDeleteValue(String string) {
        if (string.equalsIgnoreCase("none")) {
            return 17;
        }
        if (string.equalsIgnoreCase("link")) {
            return 19;
        }
        if (string.equalsIgnoreCase("object")) {
            return 23;
        }
        if (string.equalsIgnoreCase("true")) {
            return 23;
        }
        if (string.equalsIgnoreCase("false")) {
            return 17;
        }
        throw new OJBRuntimeException("Invalid value! Given value was '" + string + "', expected values are: " + "none" + ", " + "link" + ", " + "object" + " ('false' and 'true' are deprecated but still valid)");
    }

    public String getCascadeAsString(int n) {
        String string = null;
        switch (n) {
            case 17: {
                string = "none";
                break;
            }
            case 19: {
                string = "link";
                break;
            }
            case 23: {
                string = "object";
            }
        }
        return string;
    }

    public int getProxyPrefetchingLimit() {
        return this.m_ProxyPrefetchingLimit;
    }

    public void setProxyPrefetchingLimit(int n) {
        this.m_ProxyPrefetchingLimit = n;
    }

    public boolean getOtmDependent() {
        return this.m_OtmDependent;
    }

    public void setOtmDependent(boolean bl) {
        this.m_OtmDependent = bl;
    }

    public boolean isSuperReferenceDescriptor() {
        return false;
    }

    public boolean hasConstraint() {
        String string = this.getAttribute("constraint");
        return string != null && string.equalsIgnoreCase("true");
    }

    public void setConstraint(boolean bl) {
        this.addAttribute("constraint", bl ? "true" : "false");
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("cascade_retrieve", this.getCascadeRetrieve()).append("cascade_store", (Object)this.getCascadeAsString(this.m_CascadeStore)).append("cascade_delete", (Object)this.getCascadeAsString(this.m_CascadeDelete)).append("is_lazy", this.lazy).append("class_of_Items", (Object)this.m_ClassOfItems).toString();
    }

    @Override
    public String toXML() {
        RepositoryTags repositoryTags = RepositoryTags.getInstance();
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("      ");
        stringBuffer.append(repositoryTags.getOpeningTagNonClosingById(20));
        stringBuffer.append(string);
        String string2 = this.getAttributeName();
        if (string2 == null) {
            string2 = "super";
        }
        stringBuffer.append("        ");
        stringBuffer.append(repositoryTags.getAttribute(16, string2));
        stringBuffer.append(string);
        stringBuffer.append("        ");
        stringBuffer.append(repositoryTags.getAttribute(22, this.getItemClassName()));
        stringBuffer.append(string);
        if (this.isLazy()) {
            stringBuffer.append("        ");
            stringBuffer.append(repositoryTags.getAttribute(48, "true"));
            stringBuffer.append(string);
            stringBuffer.append("        ");
            stringBuffer.append(repositoryTags.getAttribute(114, "" + this.getProxyPrefetchingLimit()));
            stringBuffer.append(string);
        }
        if (this.isRefresh()) {
            stringBuffer.append("        ");
            stringBuffer.append(repositoryTags.getAttribute(47, "true"));
            stringBuffer.append(string);
        }
        stringBuffer.append("        ");
        stringBuffer.append(repositoryTags.getAttribute(24, "" + this.getCascadeRetrieve()));
        stringBuffer.append(string);
        stringBuffer.append("        ");
        stringBuffer.append(repositoryTags.getAttribute(25, this.getCascadeAsString(this.getCascadingStore())));
        stringBuffer.append(string);
        stringBuffer.append("        ");
        stringBuffer.append(repositoryTags.getAttribute(26, this.getCascadeAsString(this.getCascadingDelete())));
        stringBuffer.append(string);
        if (this.getOtmDependent()) {
            stringBuffer.append("        ");
            stringBuffer.append(repositoryTags.getAttribute(102, "true"));
            stringBuffer.append(string);
        }
        stringBuffer.append("      >");
        stringBuffer.append(string);
        for (int i = 0; i < this.getForeignKeyFields().size(); ++i) {
            String string3;
            Object e = this.getForeignKeyFields().get(i);
            if (e instanceof Integer) {
                string3 = e.toString();
                stringBuffer.append("        ");
                stringBuffer.append(repositoryTags.getOpeningTagNonClosingById(49));
                stringBuffer.append(" ");
                stringBuffer.append(repositoryTags.getAttribute(70, string3));
                stringBuffer.append("/>");
                stringBuffer.append(string);
                continue;
            }
            string3 = (String)e;
            stringBuffer.append("        ");
            stringBuffer.append(repositoryTags.getOpeningTagNonClosingById(49));
            stringBuffer.append(" ");
            stringBuffer.append(repositoryTags.getAttribute(84, string3));
            stringBuffer.append("/>");
            stringBuffer.append(string);
        }
        stringBuffer.append("      ");
        stringBuffer.append(repositoryTags.getClosingTagById(20));
        stringBuffer.append(string);
        return stringBuffer.toString();
    }
}

