/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary;

import java.beans.PropertyEditor;
import java.util.List;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.data.DataType;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.krad.datadictionary.AttributeDefinitionBase;
import org.kuali.rice.krad.datadictionary.AttributeSecurity;
import org.kuali.rice.krad.datadictionary.DataDictionaryPropertyUtils;
import org.kuali.rice.krad.datadictionary.control.ControlDefinition;
import org.kuali.rice.krad.datadictionary.mask.MaskFormatterLiteral;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validation.ValidationPattern;
import org.kuali.rice.krad.datadictionary.validation.capability.CaseConstrainable;
import org.kuali.rice.krad.datadictionary.validation.capability.Formatable;
import org.kuali.rice.krad.datadictionary.validation.capability.HierarchicallyConstrainable;
import org.kuali.rice.krad.datadictionary.validation.capability.MustOccurConstrainable;
import org.kuali.rice.krad.datadictionary.validation.capability.PrerequisiteConstrainable;
import org.kuali.rice.krad.datadictionary.validation.capability.ValidCharactersConstrainable;
import org.kuali.rice.krad.datadictionary.validation.constraint.CaseConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.MustOccurConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.PrerequisiteConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.ValidCharactersConstraint;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.keyvalues.KeyValuesFinder;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.control.Control;
import org.kuali.rice.krad.util.KRADUtils;

@BeanTag(name="attributeDefinition")
public class AttributeDefinition
extends AttributeDefinitionBase
implements CaseConstrainable,
PrerequisiteConstrainable,
Formatable,
HierarchicallyConstrainable,
MustOccurConstrainable,
ValidCharactersConstrainable {
    private static final long serialVersionUID = -2490613377818442742L;
    private static final Logger LOG = LogManager.getLogger(AttributeDefinition.class);
    protected Boolean forceUppercase;
    protected Boolean unique;
    @Deprecated
    protected ValidationPattern validationPattern;
    @Deprecated
    protected ControlDefinition control;
    protected Control controlField;
    protected Control cachedDerivedControl = null;
    @Deprecated
    protected String formatterClass;
    protected PropertyEditor propertyEditor;
    protected AttributeSecurity attributeSecurity;
    protected Boolean dynamic;
    protected String customValidatorClass;
    protected ValidCharactersConstraint validCharactersConstraint;
    protected CaseConstraint caseConstraint;
    protected List<PrerequisiteConstraint> dependencyConstraints;
    protected List<MustOccurConstraint> mustOccurConstraints;
    protected String childEntryName;
    private KeyValuesFinder optionsFinder;
    protected String alternateDisplayAttributeName;
    protected String additionalDisplayAttributeName;

    public void setForceUppercase(Boolean forceUppercase) {
        this.forceUppercase = forceUppercase;
    }

    @BeanTagAttribute
    public Boolean getForceUppercase() {
        if (this.forceUppercase != null) {
            return this.forceUppercase;
        }
        if (this.getDataObjectAttribute() != null) {
            return this.getDataObjectAttribute().isForceUppercase();
        }
        return Boolean.FALSE;
    }

    @BeanTagAttribute
    public Integer getMaxLength() {
        if (this.getSimpleConstraint().getMaxLength() != null) {
            return this.getSimpleConstraint().getMaxLength();
        }
        if (this.getDataObjectAttribute() != null && this.getDataObjectAttribute().getMaxLength() != null) {
            return new Integer(this.getDataObjectAttribute().getMaxLength().intValue());
        }
        return null;
    }

    public void setMaxLength(Integer maxLength) {
        this.getSimpleConstraint().setMaxLength(maxLength);
    }

    @BeanTagAttribute
    public String getExclusiveMin() {
        return this.getSimpleConstraint().getExclusiveMin();
    }

    public void setExclusiveMin(String exclusiveMin) {
        this.getSimpleConstraint().setExclusiveMin(exclusiveMin);
    }

    @BeanTagAttribute
    public String getInclusiveMax() {
        return this.getSimpleConstraint().getInclusiveMax();
    }

    public void setInclusiveMax(String inclusiveMax) {
        this.getSimpleConstraint().setInclusiveMax(inclusiveMax);
    }

    @Deprecated
    public void setValidationPattern(ValidationPattern validationPattern) {
        this.validationPattern = validationPattern;
    }

    @Deprecated
    public boolean hasValidationPattern() {
        return this.validationPattern != null;
    }

    @Deprecated
    public ValidationPattern getValidationPattern() {
        return this.validationPattern;
    }

    @BeanTagAttribute(name="oldControl", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    @Deprecated
    public ControlDefinition getControl() {
        return this.control;
    }

    @Deprecated
    public void setControl(ControlDefinition control) {
        if (control == null) {
            throw new IllegalArgumentException("invalid (null) control");
        }
        this.control = control;
    }

    @Deprecated
    public boolean hasFormatterClass() {
        return this.formatterClass != null;
    }

    @Override
    @BeanTagAttribute
    @Deprecated
    public String getFormatterClass() {
        return this.formatterClass;
    }

    @Deprecated
    public void setFormatterClass(String formatterClass) {
        if (formatterClass == null) {
            throw new IllegalArgumentException("invalid (null) formatterClass");
        }
        this.formatterClass = formatterClass;
    }

    @BeanTagAttribute
    public PropertyEditor getPropertyEditor() {
        if (this.propertyEditor != null) {
            return this.propertyEditor;
        }
        if (this.getDataObjectAttribute() != null) {
            return this.getDataObjectAttribute().getPropertyEditor();
        }
        return null;
    }

    public void setPropertyEditor(PropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
    }

    public void setPropertyEditorClass(Class<? extends PropertyEditor> propertyEditorClass) {
        this.propertyEditor = KRADUtils.createNewObjectFromClass(propertyEditorClass);
    }

    @Override
    public void dataDictionaryPostProcessing() {
        super.dataDictionaryPostProcessing();
        if (this.getAttributeSecurity() != null) {
            this.getAttributeSecurity().dataDictionaryPostProcessing();
        }
    }

    @Override
    @Deprecated
    public void completeValidation(Class<?> rootObjectClass, Class<?> otherObjectClass) {
        this.completeValidation((Class)rootObjectClass, (Class)otherObjectClass, new ValidationTrace());
    }

    public void completeValidation(Class rootObjectClass, Class otherObjectClass, ValidationTrace tracer) {
        block11: {
            tracer.addBean(this.getClass().getSimpleName(), "id: " + this.getId());
            try {
                String[] currentValues;
                if (StringUtils.isBlank((String)this.getName())) {
                    currentValues = new String[]{"id = " + this.getId(), "class = " + rootObjectClass.getName()};
                    tracer.createError("AttributeDefinition missing name", currentValues);
                }
                if (!DataDictionaryPropertyUtils.isPropertyOf(rootObjectClass, this.getName())) {
                    currentValues = new String[]{"property = " + this.getName(), "class = " + rootObjectClass.getName()};
                    tracer.createError("Property is not found in class. Ensure that the property is defined on the class and that there is at least a public 'getter' for it.", currentValues);
                }
                if (this.getControl() == null && this.getControlField() == null) {
                    currentValues = new String[]{"property = " + this.getName(), "class = " + rootObjectClass.getName()};
                    tracer.createError("Property does not have a control defined in the class", currentValues);
                }
                if (this.getAttributeSecurity() != null) {
                    this.getAttributeSecurity().completeValidation(rootObjectClass, otherObjectClass, tracer.getCopy());
                }
                if (this.getControl() != null) {
                    this.getControl().completeValidation(rootObjectClass, otherObjectClass);
                }
                if (this.validationPattern != null) {
                    this.validationPattern.completeValidation();
                }
                if (this.getFormatterClass() == null) break block11;
                try {
                    Class formatterClassObject = ClassUtils.getClass((ClassLoader)ClassLoaderUtils.getDefaultClassLoader(), (String)this.getFormatterClass());
                    if (!Formatter.class.isAssignableFrom(formatterClassObject)) {
                        String[] currentValues2 = new String[]{"formatterClassObject = " + formatterClassObject.getName()};
                        tracer.createError("FormatterClass is not a valid instance", currentValues2);
                    }
                }
                catch (ClassNotFoundException e) {
                    String[] currentValues3 = new String[]{"class = " + this.getFormatterClass()};
                    tracer.createError("FormatterClass could not be found", currentValues3);
                }
            }
            catch (RuntimeException ex) {
                String[] currentValues = new String[]{"attribute = " + rootObjectClass + "." + this.getName(), "Exception = " + ex.getMessage()};
                tracer.createError("Unable to validate attribute", currentValues);
                LOG.error("Exception while validating AttributeDefinition: " + this.getId(), (Throwable)ex);
            }
        }
    }

    @BeanTagAttribute(name="attributeSecurity", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public AttributeSecurity getAttributeSecurity() {
        if (this.attributeSecurity != null) {
            return this.attributeSecurity;
        }
        if (this.getDataObjectAttribute() != null && this.getDataObjectAttribute().isSensitive()) {
            AttributeSecurity attrSec = new AttributeSecurity();
            attrSec.setMask(true);
            attrSec.setMaskFormatter(new MaskFormatterLiteral());
            this.attributeSecurity = attrSec;
        }
        return this.attributeSecurity;
    }

    public void setAttributeSecurity(AttributeSecurity attributeSecurity) {
        this.attributeSecurity = attributeSecurity;
    }

    public boolean hasAttributeSecurity() {
        return this.getAttributeSecurity() != null;
    }

    public Boolean getUnique() {
        return this.unique;
    }

    public void setUnique(Boolean unique) {
        this.unique = unique;
    }

    @BeanTagAttribute(name="control", type=BeanTagAttribute.AttributeType.BYTYPE)
    public Control getControlField() {
        if (this.controlField != null) {
            return this.controlField;
        }
        if (this.cachedDerivedControl == null && GlobalResourceLoader.isInitialized()) {
            this.cachedDerivedControl = KRADServiceLocatorWeb.getUifDefaultingService().deriveControlAttributeFromMetadata(this);
        }
        return this.cachedDerivedControl;
    }

    public void setControlField(Control controlField) {
        this.controlField = controlField;
    }

    @BeanTagAttribute
    public Integer getMinLength() {
        if (this.getSimpleConstraint().getMinLength() != null) {
            return this.getSimpleConstraint().getMinLength();
        }
        if (this.getDataObjectAttribute() != null && this.getDataObjectAttribute().getMinLength() != null) {
            return new Integer(this.getDataObjectAttribute().getMinLength().intValue());
        }
        return null;
    }

    public void setMinLength(Integer minLength) {
        this.getSimpleConstraint().setMinLength(minLength);
    }

    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public DataType getDataType() {
        if (this.simpleConstraint.getDataType() != null) {
            return this.simpleConstraint.getDataType();
        }
        if (this.getDataObjectAttribute() != null) {
            return this.getDataObjectAttribute().getDataType();
        }
        return DataType.STRING;
    }

    public void setDataType(DataType dataType) {
        this.simpleConstraint.setDataType(dataType);
    }

    public void setDataType(String dataType) {
        this.simpleConstraint.setDataType(DataType.valueOf((String)dataType));
    }

    @BeanTagAttribute
    public String getCustomValidatorClass() {
        return this.customValidatorClass;
    }

    public void setCustomValidatorClass(String customValidatorClass) {
        this.customValidatorClass = customValidatorClass;
    }

    @Override
    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.DIRECTORBYTYPE)
    public ValidCharactersConstraint getValidCharactersConstraint() {
        if (this.validCharactersConstraint == null && GlobalResourceLoader.isInitialized() && this.getControlField() != null && !this.getControlField().isHidden() && !Boolean.TRUE.equals(this.getControlField().getReadOnly())) {
            this.validCharactersConstraint = KRADServiceLocatorWeb.getUifDefaultingService().deriveValidCharactersConstraint(this);
        }
        return this.validCharactersConstraint;
    }

    public void setValidCharactersConstraint(ValidCharactersConstraint validCharactersConstraint) {
        this.validCharactersConstraint = validCharactersConstraint;
    }

    @Override
    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.DIRECTORBYTYPE)
    public CaseConstraint getCaseConstraint() {
        return this.caseConstraint;
    }

    public void setCaseConstraint(CaseConstraint caseConstraint) {
        this.caseConstraint = caseConstraint;
    }

    @Override
    @BeanTagAttribute
    public List<PrerequisiteConstraint> getPrerequisiteConstraints() {
        return this.dependencyConstraints;
    }

    public void setPrerequisiteConstraints(List<PrerequisiteConstraint> dependencyConstraints) {
        this.dependencyConstraints = dependencyConstraints;
    }

    @Override
    @BeanTagAttribute
    public List<MustOccurConstraint> getMustOccurConstraints() {
        return this.mustOccurConstraints;
    }

    public void setMustOccurConstraints(List<MustOccurConstraint> mustOccurConstraints) {
        this.mustOccurConstraints = mustOccurConstraints;
    }

    @Override
    @BeanTagAttribute
    public String getChildEntryName() {
        return this.childEntryName;
    }

    public void setChildEntryName(String childEntryName) {
        this.childEntryName = childEntryName;
    }

    @BeanTagAttribute
    public KeyValuesFinder getOptionsFinder() {
        if (this.optionsFinder == null && this.getDataObjectAttribute() != null && this.getDataObjectAttribute().getValidValues() != null) {
            return this.getDataObjectAttribute().getValidValues();
        }
        return this.optionsFinder;
    }

    public void setOptionsFinder(KeyValuesFinder optionsFinder) {
        this.optionsFinder = optionsFinder;
    }

    public void setOptionsFinderClass(Class<? extends KeyValuesFinder> optionsFinderClass) {
        this.optionsFinder = KRADUtils.createNewObjectFromClass(optionsFinderClass);
    }

    public void setAdditionalDisplayAttributeName(String additionalDisplayAttributeName) {
        this.additionalDisplayAttributeName = additionalDisplayAttributeName;
    }

    @BeanTagAttribute
    public String getAdditionalDisplayAttributeName() {
        return this.additionalDisplayAttributeName;
    }

    public void setAlternateDisplayAttributeName(String alternateDisplayAttributeName) {
        this.alternateDisplayAttributeName = alternateDisplayAttributeName;
    }

    @BeanTagAttribute
    public String getAlternateDisplayAttributeName() {
        return this.alternateDisplayAttributeName;
    }

    public List<PrerequisiteConstraint> getDependencyConstraints() {
        return this.dependencyConstraints;
    }

    public void setDependencyConstraints(List<PrerequisiteConstraint> dependencyConstraints) {
        this.dependencyConstraints = dependencyConstraints;
    }
}

