/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.dao.impl;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.search.SearchOperator;
import org.kuali.rice.core.api.util.type.TypeUtils;
import org.kuali.rice.core.framework.persistence.ojb.conversion.OjbCharBooleanConversion;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;
import org.kuali.rice.core.framework.persistence.platform.DatabasePlatform;
import org.kuali.rice.kns.lookup.LookupUtils;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.InactivatableFromTo;
import org.kuali.rice.krad.dao.LookupDao;
import org.kuali.rice.krad.lookup.CollectionIncomplete;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.PersistenceStructureService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;
import org.springframework.dao.DataIntegrityViolationException;
import org.springmodules.orm.ojb.OjbOperationException;

@Deprecated
public class LookupDaoOjb
extends PlatformAwareDaoBaseOjb
implements LookupDao {
    private static final Logger LOG = LogManager.getLogger(LookupDaoOjb.class);
    private DateTimeService dateTimeService;
    private PersistenceStructureService persistenceStructureService;
    private DataDictionaryService dataDictionaryService;

    public Collection findCollectionBySearchHelper(Class businessObjectClass, Map formProps, boolean unbounded, boolean usePrimaryKeyValuesOnly) {
        Integer searchResultsLimit = LookupUtils.getSearchResultsLimit(businessObjectClass);
        return this.findCollectionBySearchHelper(businessObjectClass, formProps, unbounded, usePrimaryKeyValuesOnly, searchResultsLimit);
    }

    public Collection findCollectionBySearchHelper(Class businessObjectClass, Map formProps, boolean unbounded, boolean usePrimaryKeyValuesOnly, Integer searchResultsLimit) {
        BusinessObject businessObject = this.checkBusinessObjectClass(businessObjectClass);
        if (usePrimaryKeyValuesOnly) {
            return this.executeSearch(businessObjectClass, this.getCollectionCriteriaFromMapUsingPrimaryKeysOnly(businessObjectClass, formProps), unbounded, searchResultsLimit);
        }
        Criteria crit = this.getCollectionCriteriaFromMap(businessObject, formProps);
        return this.executeSearch(businessObjectClass, crit, unbounded, searchResultsLimit);
    }

    public Criteria getCollectionCriteriaFromMap(BusinessObject example, Map formProps) {
        Criteria criteria = new Criteria();
        for (String propertyName : formProps.keySet()) {
            Boolean caseInsensitive = Boolean.TRUE;
            if (KRADServiceLocatorWeb.getDataDictionaryService().isAttributeDefined(example.getClass(), propertyName).booleanValue()) {
                caseInsensitive = KRADServiceLocatorWeb.getDataDictionaryService().getAttributeForceUppercase(example.getClass(), propertyName) == false;
            }
            if (caseInsensitive == null) {
                caseInsensitive = Boolean.TRUE;
            }
            boolean treatWildcardsAndOperatorsAsLiteral = KNSServiceLocator.getBusinessObjectDictionaryService().isLookupFieldTreatWildcardsAndOperatorsAsLiteral(example.getClass(), propertyName);
            if (formProps.get(propertyName) instanceof Collection) {
                for (String searchValue : (Collection)formProps.get(propertyName)) {
                    if (!caseInsensitive.booleanValue()) {
                        searchValue = searchValue.toUpperCase();
                    }
                    if (this.createCriteria(example, searchValue, propertyName, caseInsensitive, treatWildcardsAndOperatorsAsLiteral, criteria, formProps)) continue;
                    throw new RuntimeException("Invalid value in Collection");
                }
                continue;
            }
            String searchValue = (String)formProps.get(propertyName);
            if (!caseInsensitive.booleanValue()) {
                searchValue = searchValue.toUpperCase();
            }
            if (this.createCriteria(example, searchValue, propertyName, caseInsensitive, treatWildcardsAndOperatorsAsLiteral, criteria, formProps)) continue;
        }
        return criteria;
    }

    public Criteria getCollectionCriteriaFromMapUsingPrimaryKeysOnly(Class businessObjectClass, Map formProps) {
        BusinessObject businessObject = this.checkBusinessObjectClass(businessObjectClass);
        Criteria criteria = new Criteria();
        List pkFields = KRADServiceLocatorWeb.getLegacyDataAdapter().listPrimaryKeyFieldNames(businessObjectClass);
        for (String pkFieldName : pkFields) {
            String pkValue = (String)formProps.get(pkFieldName);
            if (StringUtils.isBlank((String)pkValue)) {
                throw new RuntimeException("Missing pk value for field " + pkFieldName + " when a search based on PK values only is performed.");
            }
            for (SearchOperator op : SearchOperator.QUERY_CHARACTERS) {
                if (!pkValue.contains(op.op())) continue;
                throw new RuntimeException("Value \"" + pkValue + "\" for PK field " + pkFieldName + " contains wildcard/operator characters.");
            }
            boolean treatWildcardsAndOperatorsAsLiteral = KNSServiceLocator.getBusinessObjectDictionaryService().isLookupFieldTreatWildcardsAndOperatorsAsLiteral(businessObjectClass, pkFieldName);
            this.createCriteria(businessObject, pkValue, pkFieldName, false, treatWildcardsAndOperatorsAsLiteral, criteria);
        }
        return criteria;
    }

    private BusinessObject checkBusinessObjectClass(Class businessObjectClass) {
        if (businessObjectClass == null) {
            throw new IllegalArgumentException("BusinessObject class passed to LookupDaoOjb findCollectionBySearchHelper... method was null");
        }
        BusinessObject businessObject = null;
        try {
            businessObject = (BusinessObject)businessObjectClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("LookupDaoOjb could not get instance of " + businessObjectClass.getName(), e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("LookupDaoOjb could not get instance of " + businessObjectClass.getName(), e);
        }
        return businessObject;
    }

    private Collection executeSearch(Class businessObjectClass, Criteria criteria, boolean unbounded, Integer searchResultsLimit) {
        ArrayList searchResults;
        Long matchingResultsCount = null;
        try {
            QueryByCriteria ojbCriteria;
            if (!unbounded && searchResultsLimit == null) {
                searchResultsLimit = LookupUtils.getSearchResultsLimit(businessObjectClass);
            }
            QueryByCriteria queryByCriteria = ojbCriteria = LookupUtils.isDistinctSearch() ? QueryFactory.newQuery((Class)businessObjectClass, (Criteria)criteria, (boolean)true) : QueryFactory.newQuery((Class)businessObjectClass, (Criteria)criteria);
            if (!unbounded && searchResultsLimit != null && searchResultsLimit >= 0) {
                matchingResultsCount = this.getPersistenceBrokerTemplate().getCount((Query)ojbCriteria);
                this.applySearchResultsLimit(businessObjectClass, criteria, this.getDbPlatform(), searchResultsLimit);
            }
            if (matchingResultsCount == null || matchingResultsCount.intValue() <= searchResultsLimit) {
                matchingResultsCount = 0L;
            }
            searchResults = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)ojbCriteria);
            ArrayList bos = new ArrayList();
            bos.addAll(searchResults);
            searchResults = bos;
        }
        catch (DataIntegrityViolationException | OjbOperationException e) {
            throw new RuntimeException("LookupDaoOjb encountered exception during executeSearch", e);
        }
        return new CollectionIncomplete(searchResults, matchingResultsCount);
    }

    protected void applySearchResultsLimit(Class businessObjectClass, Criteria criteria, DatabasePlatform platform, Integer limit) {
        String limitSql = null;
        if (limit != null) {
            limitSql = platform.applyLimitSql(limit);
        } else {
            limit = org.kuali.rice.krad.lookup.LookupUtils.getSearchResultsLimit((Class)businessObjectClass, null);
            if (limit != null) {
                limitSql = platform.applyLimitSql(limit);
            }
        }
        if (StringUtils.isNotBlank((String)limitSql)) {
            criteria.addSql(limitSql);
        }
    }

    @Override
    public boolean createCriteria(Object example, String searchValue, String propertyName, Object criteria) {
        return this.createCriteria(example, searchValue, propertyName, false, false, criteria);
    }

    @Override
    public boolean createCriteria(Object example, String searchValue, String propertyName, boolean caseInsensitive, boolean treatWildcardsAndOperatorsAsLiteral, Object criteria) {
        return this.createCriteria(example, searchValue, propertyName, caseInsensitive, treatWildcardsAndOperatorsAsLiteral, criteria, null);
    }

    public boolean createCriteria(Object example, String searchValue, String propertyName, boolean caseInsensitive, boolean treatWildcardsAndOperatorsAsLiteral, Object criteria, Map searchValues) {
        if (!(criteria instanceof Criteria) || StringUtils.isBlank((String)searchValue) || !ObjectUtils.isWriteable(example, propertyName, this.persistenceStructureService)) {
            return false;
        }
        Class propertyType = ObjectUtils.getPropertyType(example, propertyName, this.persistenceStructureService);
        if (propertyType == null) {
            return false;
        }
        if (example instanceof InactivatableFromTo) {
            if ("active".equals(propertyName)) {
                this.addInactivateableFromToActiveCriteria(example, searchValue, (Criteria)criteria, searchValues);
            } else if ("current".equals(propertyName)) {
                this.addInactivateableFromToCurrentCriteria(example, searchValue, (Criteria)criteria, searchValues);
            } else if (!"activeAsOfDate".equals(propertyName)) {
                this.addCriteria(propertyName, searchValue, propertyType, caseInsensitive, treatWildcardsAndOperatorsAsLiteral, (Criteria)criteria);
            }
        } else {
            this.addCriteria(propertyName, searchValue, propertyType, caseInsensitive, treatWildcardsAndOperatorsAsLiteral, (Criteria)criteria);
        }
        return true;
    }

    public Long findCountByMap(Object example, Map formProps) {
        Criteria criteria = new Criteria();
        for (String propertyName : formProps.keySet()) {
            Class propertyType;
            String searchValue = (String)formProps.get(propertyName);
            if (StringUtils.isBlank((String)searchValue) || !PropertyUtils.isWriteable((Object)example, (String)propertyName) || (propertyType = ObjectUtils.getPropertyType(example, propertyName, this.persistenceStructureService)) == null) continue;
            Boolean caseInsensitive = Boolean.TRUE;
            if (KRADServiceLocatorWeb.getDataDictionaryService().isAttributeDefined(example.getClass(), propertyName).booleanValue()) {
                caseInsensitive = KRADServiceLocatorWeb.getDataDictionaryService().getAttributeForceUppercase(example.getClass(), propertyName) == false;
            }
            if (caseInsensitive == null) {
                caseInsensitive = Boolean.TRUE;
            }
            boolean treatWildcardsAndOperatorsAsLiteral = KNSServiceLocator.getBusinessObjectDictionaryService().isLookupFieldTreatWildcardsAndOperatorsAsLiteral(example.getClass(), propertyName);
            if (!caseInsensitive.booleanValue()) {
                searchValue = searchValue.toUpperCase();
            }
            this.addCriteria(propertyName, searchValue, propertyType, caseInsensitive, treatWildcardsAndOperatorsAsLiteral, criteria);
        }
        QueryByCriteria query = QueryFactory.newQuery(example.getClass(), (Criteria)criteria);
        return new Long(this.getPersistenceBrokerTemplate().getCount((Query)query));
    }

    @Override
    public <T> T findObjectByMap(Class<T> type, Map<String, String> formProps) {
        Object example = null;
        try {
            example = type.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot get new instance of " + type.getName(), e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Cannot instantiate " + type.getName(), e);
        }
        if (KRADServiceLocatorWeb.getLegacyDataAdapter().isPersistable(example.getClass())) {
            Criteria criteria = new Criteria();
            for (Map.Entry<String, String> formProp : formProps.entrySet()) {
                String propertyName = formProp.getKey();
                String searchValue = "";
                if (formProp.getValue() != null) {
                    searchValue = formProp.getValue();
                }
                if (!(StringUtils.isNotBlank((String)searchValue) & PropertyUtils.isWriteable((Object)example, (String)propertyName))) continue;
                Class propertyType = ObjectUtils.getPropertyType(example, propertyName, this.persistenceStructureService);
                if (TypeUtils.isIntegralClass((Class)propertyType) || TypeUtils.isDecimalClass((Class)propertyType)) {
                    criteria.addEqualTo(propertyName, (Object)this.cleanNumeric(searchValue));
                    continue;
                }
                if (TypeUtils.isTemporalClass((Class)propertyType)) {
                    criteria.addEqualTo(propertyName, (Object)this.parseDate(ObjectUtils.clean(searchValue)));
                    continue;
                }
                criteria.addEqualTo(propertyName, (Object)searchValue);
            }
            QueryByCriteria query = QueryFactory.newQuery(example.getClass(), (Criteria)criteria);
            return (T)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
        }
        return null;
    }

    private void addCriteria(String propertyName, String propertyValue, Class propertyType, boolean caseInsensitive, boolean treatWildcardsAndOperatorsAsLiteral, Criteria criteria) {
        if (!treatWildcardsAndOperatorsAsLiteral && StringUtils.contains((String)propertyValue, (String)SearchOperator.OR.op())) {
            this.addOrCriteria((String)propertyName, propertyValue, propertyType, caseInsensitive, criteria);
            return;
        }
        if (!treatWildcardsAndOperatorsAsLiteral && StringUtils.contains((String)propertyValue, (String)SearchOperator.AND.op())) {
            this.addAndCriteria((String)propertyName, propertyValue, propertyType, caseInsensitive, criteria);
            return;
        }
        if (StringUtils.equalsIgnoreCase((String)propertyValue, (String)SearchOperator.NULL.op()) || StringUtils.equalsIgnoreCase((String)propertyValue, (String)SearchOperator.NOT_NULL.op())) {
            if (StringUtils.contains((String)propertyValue, (String)SearchOperator.NOT.op())) {
                criteria.addNotNull((String)propertyName);
            } else {
                criteria.addIsNull((String)propertyName);
            }
        } else if (TypeUtils.isStringClass((Class)propertyType)) {
            if (caseInsensitive) {
                propertyName = this.getDbPlatform().getUpperCaseFunction() + "(" + (String)propertyName + ")";
                propertyValue = propertyValue.toUpperCase();
            }
            if (!treatWildcardsAndOperatorsAsLiteral && StringUtils.contains((String)propertyValue, (String)SearchOperator.NOT.op())) {
                this.addNotCriteria((String)propertyName, propertyValue, propertyType, caseInsensitive, criteria);
            } else if (!treatWildcardsAndOperatorsAsLiteral && propertyValue != null && (StringUtils.contains((String)propertyValue, (String)SearchOperator.BETWEEN.op()) || propertyValue.startsWith(">") || propertyValue.startsWith("<"))) {
                this.addStringRangeCriteria((String)propertyName, propertyValue, criteria);
            } else {
                if (treatWildcardsAndOperatorsAsLiteral) {
                    propertyValue = StringUtils.replace((String)propertyValue, (String)"*", (String)"\\*");
                }
                criteria.addLike(propertyName, (Object)propertyValue);
            }
        } else if (TypeUtils.isIntegralClass((Class)propertyType) || TypeUtils.isDecimalClass((Class)propertyType)) {
            this.addNumericRangeCriteria((String)propertyName, propertyValue, treatWildcardsAndOperatorsAsLiteral, criteria);
        } else if (TypeUtils.isTemporalClass((Class)propertyType)) {
            this.addDateRangeCriteria((String)propertyName, propertyValue, treatWildcardsAndOperatorsAsLiteral, criteria);
        } else if (TypeUtils.isBooleanClass((Class)propertyType)) {
            criteria.addEqualTo((String)propertyName, (Object)ObjectUtils.clean(propertyValue));
        } else {
            LOG.error("not adding criterion for: " + (String)propertyName + "," + propertyType + "," + propertyValue);
        }
    }

    protected void addInactivateableFromToActiveCriteria(Object example, String activeSearchValue, Criteria criteria, Map searchValues) {
        Timestamp activeTimestamp = org.kuali.rice.krad.lookup.LookupUtils.getActiveDateTimestampForCriteria((Map)searchValues);
        String activeBooleanStr = (String)new OjbCharBooleanConversion().javaToSql(activeSearchValue);
        if ("Y".equals(activeBooleanStr)) {
            Criteria criteriaBeginDate = new Criteria();
            criteriaBeginDate.addLessOrEqualThan((Object)"activeFromDate", (Object)activeTimestamp);
            Criteria criteriaBeginDateNull = new Criteria();
            criteriaBeginDateNull.addIsNull("activeFromDate");
            criteriaBeginDate.addOrCriteria(criteriaBeginDateNull);
            criteria.addAndCriteria(criteriaBeginDate);
            Criteria criteriaEndDate = new Criteria();
            criteriaEndDate.addGreaterThan((Object)"activeToDate", (Object)activeTimestamp);
            Criteria criteriaEndDateNull = new Criteria();
            criteriaEndDateNull.addIsNull("activeToDate");
            criteriaEndDate.addOrCriteria(criteriaEndDateNull);
            criteria.addAndCriteria(criteriaEndDate);
        } else if ("N".equals(activeBooleanStr)) {
            Criteria criteriaNonActive = new Criteria();
            criteriaNonActive.addGreaterThan((Object)"activeFromDate", (Object)activeTimestamp);
            Criteria criteriaEndDate = new Criteria();
            criteriaEndDate.addLessOrEqualThan((Object)"activeToDate", (Object)activeTimestamp);
            criteriaNonActive.addOrCriteria(criteriaEndDate);
            criteria.addAndCriteria(criteriaNonActive);
        }
    }

    protected void addInactivateableFromToCurrentCriteria(Object example, String currentSearchValue, Criteria criteria, Map searchValues) {
        Criteria maxBeginDateCriteria = new Criteria();
        Timestamp activeTimestamp = org.kuali.rice.krad.lookup.LookupUtils.getActiveDateTimestampForCriteria((Map)searchValues);
        maxBeginDateCriteria.addLessOrEqualThan((Object)"activeFromDate", (Object)activeTimestamp);
        List groupByFieldList = this.dataDictionaryService.getGroupByAttributesForEffectiveDating(example.getClass());
        if (groupByFieldList == null) {
            return;
        }
        String[] groupBy = new String[groupByFieldList.size()];
        for (int i = 0; i < groupByFieldList.size(); ++i) {
            String groupByField;
            groupBy[i] = groupByField = (String)groupByFieldList.get(i);
            maxBeginDateCriteria.addEqualToField(groupByField, "parentQuery." + groupByField);
        }
        String[] columns = new String[]{"max(activeFromDate)"};
        ReportQueryByCriteria query = QueryFactory.newReportQuery(example.getClass(), (String[])columns, (Criteria)maxBeginDateCriteria, (boolean)true);
        query.addGroupBy(groupBy);
        String currentBooleanStr = (String)new OjbCharBooleanConversion().javaToSql(currentSearchValue);
        if ("Y".equals(currentBooleanStr)) {
            criteria.addIn((Object)"activeFromDate", (Query)query);
        } else if ("N".equals(currentBooleanStr)) {
            criteria.addNotIn("activeFromDate", (Query)query);
        }
    }

    private void addOrCriteria(String propertyName, String propertyValue, Class propertyType, boolean caseInsensitive, Criteria criteria) {
        this.addLogicalOperatorCriteria(propertyName, propertyValue, propertyType, caseInsensitive, criteria, SearchOperator.OR.op());
    }

    private void addAndCriteria(String propertyName, String propertyValue, Class propertyType, boolean caseInsensitive, Criteria criteria) {
        this.addLogicalOperatorCriteria(propertyName, propertyValue, propertyType, caseInsensitive, criteria, SearchOperator.AND.op());
    }

    private void addNotCriteria(String propertyName, String propertyValue, Class propertyType, boolean caseInsensitive, Criteria criteria) {
        Object[] splitPropVal = StringUtils.split((String)propertyValue, (String)SearchOperator.NOT.op());
        try {
            int strLength = splitPropVal.length;
            if (strLength == 0) {
                throw new IllegalArgumentException("Improper syntax of NOT operator in " + propertyName);
            }
            if (strLength > 1) {
                String expandedNot = SearchOperator.NOT + StringUtils.join((Object[])splitPropVal, (String)(SearchOperator.AND.op() + SearchOperator.NOT.op()));
                this.addCriteria(propertyName, expandedNot, propertyType, caseInsensitive, false, criteria);
            } else {
                criteria.addNotLike(propertyName, (Object)splitPropVal[0]);
            }
        }
        catch (IllegalArgumentException ex) {
            GlobalVariables.getMessageMap().putError("lookupCriteria[" + propertyName + "]", "error.notSyntax", new String[]{propertyName});
        }
    }

    private void addLogicalOperatorCriteria(String propertyName, String propertyValue, Class propertyType, boolean caseInsensitive, Criteria criteria, String splitValue) {
        String[] splitPropVal = StringUtils.split((String)propertyValue, (String)splitValue);
        Criteria subCriteria = new Criteria();
        for (int i = 0; i < splitPropVal.length; ++i) {
            Criteria predicate = new Criteria();
            this.addCriteria(propertyName, splitPropVal[i], propertyType, caseInsensitive, false, predicate);
            if (splitValue.equals(SearchOperator.OR.op())) {
                subCriteria.addOrCriteria(predicate);
            }
            if (!splitValue.equals(SearchOperator.AND.op())) continue;
            subCriteria.addAndCriteria(predicate);
        }
        criteria.addAndCriteria(subCriteria);
    }

    private Date parseDate(String dateString) {
        dateString = dateString.trim();
        try {
            return this.dateTimeService.convertToSqlDate(dateString);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    private void addDateRangeCriteria(String propertyName, String propertyValue, boolean treatWildcardsAndOperatorsAsLiteral, Criteria criteria) {
        try {
            if (StringUtils.contains((String)propertyValue, (String)SearchOperator.BETWEEN.op())) {
                if (treatWildcardsAndOperatorsAsLiteral) {
                    throw new RuntimeException("Wildcards and operators are not allowed on this date field: " + propertyName);
                }
                String[] rangeValues = StringUtils.split((String)propertyValue, (String)SearchOperator.BETWEEN.op());
                if (rangeValues.length < 2) {
                    throw new IllegalArgumentException("Improper syntax of BETWEEN operator in " + propertyName);
                }
                criteria.addBetween((Object)propertyName, (Object)this.parseDate(ObjectUtils.clean(rangeValues[0])), (Object)this.parseDate(ObjectUtils.clean(rangeValues[1])));
            } else if (propertyValue.startsWith(SearchOperator.GREATER_THAN_EQUAL.op())) {
                if (treatWildcardsAndOperatorsAsLiteral) {
                    throw new RuntimeException("Wildcards and operators are not allowed on this date field: " + propertyName);
                }
                criteria.addGreaterOrEqualThan((Object)propertyName, (Object)this.parseDate(ObjectUtils.clean(propertyValue)));
            } else if (propertyValue.startsWith(SearchOperator.LESS_THAN_EQUAL.op())) {
                if (treatWildcardsAndOperatorsAsLiteral) {
                    throw new RuntimeException("Wildcards and operators are not allowed on this date field: " + propertyName);
                }
                criteria.addLessOrEqualThan((Object)propertyName, (Object)this.parseDate(ObjectUtils.clean(propertyValue)));
            } else if (propertyValue.startsWith(SearchOperator.GREATER_THAN.op())) {
                if (treatWildcardsAndOperatorsAsLiteral) {
                    throw new RuntimeException("Wildcards and operators are not allowed on this date field: " + propertyName);
                }
                criteria.addGreaterThan((Object)propertyName, (Object)this.parseDate(ObjectUtils.clean(propertyValue)));
            } else if (propertyValue.startsWith(SearchOperator.LESS_THAN.op())) {
                if (treatWildcardsAndOperatorsAsLiteral) {
                    throw new RuntimeException("Wildcards and operators are not allowed on this date field: " + propertyName);
                }
                criteria.addLessThan((Object)propertyName, (Object)this.parseDate(ObjectUtils.clean(propertyValue)));
            } else {
                criteria.addEqualTo(propertyName, (Object)this.parseDate(ObjectUtils.clean(propertyValue)));
            }
        }
        catch (IllegalArgumentException ex) {
            GlobalVariables.getMessageMap().putError("lookupCriteria[" + propertyName + "]", "error.betweenSyntax", new String[]{propertyName});
        }
    }

    private BigDecimal cleanNumeric(String value) {
        Object cleanedValue = value.replaceAll("[^-0-9.]", "");
        if (((String)cleanedValue).lastIndexOf(45) > 0) {
            cleanedValue = ((String)cleanedValue).charAt(0) == '-' ? "-" + ((String)cleanedValue).replaceAll("-", "") : ((String)cleanedValue).replaceAll("-", "");
        }
        int decimalLoc = ((String)cleanedValue).lastIndexOf(46);
        if (((String)cleanedValue).indexOf(46) != decimalLoc) {
            cleanedValue = ((String)cleanedValue).substring(0, decimalLoc).replaceAll("\\.", "") + ((String)cleanedValue).substring(decimalLoc);
        }
        try {
            return new BigDecimal((String)cleanedValue);
        }
        catch (NumberFormatException ex) {
            GlobalVariables.getMessageMap().putError("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", "error.custom", new String[]{"Invalid Numeric Input: " + value});
            return null;
        }
    }

    private void addNumericRangeCriteria(String propertyName, String propertyValue, boolean treatWildcardsAndOperatorsAsLiteral, Criteria criteria) {
        try {
            if (StringUtils.contains((String)propertyValue, (String)SearchOperator.BETWEEN.op())) {
                if (treatWildcardsAndOperatorsAsLiteral) {
                    throw new RuntimeException("Cannot use wildcards and operators on numeric field " + propertyName);
                }
                String[] rangeValues = StringUtils.split((String)propertyValue, (String)SearchOperator.BETWEEN.op());
                if (rangeValues.length < 2) {
                    throw new IllegalArgumentException("Improper syntax of BETWEEN operator in " + propertyName);
                }
                criteria.addBetween((Object)propertyName, (Object)this.cleanNumeric(rangeValues[0]), (Object)this.cleanNumeric(rangeValues[1]));
            } else if (propertyValue.startsWith(SearchOperator.GREATER_THAN_EQUAL.op())) {
                if (treatWildcardsAndOperatorsAsLiteral) {
                    throw new RuntimeException("Cannot use wildcards and operators on numeric field " + propertyName);
                }
                criteria.addGreaterOrEqualThan((Object)propertyName, (Object)this.cleanNumeric(propertyValue));
            } else if (propertyValue.startsWith(SearchOperator.LESS_THAN_EQUAL.op())) {
                if (treatWildcardsAndOperatorsAsLiteral) {
                    throw new RuntimeException("Cannot use wildcards and operators on numeric field " + propertyName);
                }
                criteria.addLessOrEqualThan((Object)propertyName, (Object)this.cleanNumeric(propertyValue));
            } else if (propertyValue.startsWith(SearchOperator.GREATER_THAN.op())) {
                if (treatWildcardsAndOperatorsAsLiteral) {
                    throw new RuntimeException("Cannot use wildcards and operators on numeric field " + propertyName);
                }
                criteria.addGreaterThan((Object)propertyName, (Object)this.cleanNumeric(propertyValue));
            } else if (propertyValue.startsWith(SearchOperator.LESS_THAN.op())) {
                if (treatWildcardsAndOperatorsAsLiteral) {
                    throw new RuntimeException("Cannot use wildcards and operators on numeric field " + propertyName);
                }
                criteria.addLessThan((Object)propertyName, (Object)this.cleanNumeric(propertyValue));
            } else {
                criteria.addEqualTo(propertyName, (Object)this.cleanNumeric(propertyValue));
            }
        }
        catch (IllegalArgumentException ex) {
            GlobalVariables.getMessageMap().putError("lookupCriteria[" + propertyName + "]", "error.betweenSyntax", new String[]{propertyName});
        }
    }

    private void addStringRangeCriteria(String propertyName, String propertyValue, Criteria criteria) {
        try {
            if (StringUtils.contains((String)propertyValue, (String)SearchOperator.BETWEEN.op())) {
                String[] rangeValues = StringUtils.split((String)propertyValue, (String)SearchOperator.BETWEEN.op());
                if (rangeValues.length < 2) {
                    throw new IllegalArgumentException("Improper syntax of BETWEEN operator in " + propertyName);
                }
                criteria.addBetween((Object)propertyName, (Object)rangeValues[0], (Object)rangeValues[1]);
            } else if (propertyValue.startsWith(SearchOperator.GREATER_THAN_EQUAL.op())) {
                criteria.addGreaterOrEqualThan((Object)propertyName, (Object)ObjectUtils.clean(propertyValue));
            } else if (propertyValue.startsWith(SearchOperator.LESS_THAN_EQUAL.op())) {
                criteria.addLessOrEqualThan((Object)propertyName, (Object)ObjectUtils.clean(propertyValue));
            } else if (propertyValue.startsWith(SearchOperator.GREATER_THAN.op())) {
                criteria.addGreaterThan((Object)propertyName, (Object)ObjectUtils.clean(propertyValue));
            } else if (propertyValue.startsWith(SearchOperator.LESS_THAN.op())) {
                criteria.addLessThan((Object)propertyName, (Object)ObjectUtils.clean(propertyValue));
            } else {
                criteria.addEqualTo(propertyName, (Object)ObjectUtils.clean(propertyValue));
            }
        }
        catch (IllegalArgumentException ex) {
            GlobalVariables.getMessageMap().putError("lookupCriteria[" + propertyName + "]", "error.betweenSyntax", new String[]{propertyName});
        }
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setPersistenceStructureService(PersistenceStructureService persistenceStructureService) {
        this.persistenceStructureService = persistenceStructureService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }
}

