/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.data.metadata.DataObjectAttribute;
import org.kuali.rice.krad.data.metadata.DataObjectAttributeRelationship;
import org.kuali.rice.krad.data.metadata.DataObjectCollection;
import org.kuali.rice.krad.data.metadata.DataObjectMetadata;
import org.kuali.rice.krad.data.metadata.DataObjectRelationship;
import org.kuali.rice.krad.data.provider.MetadataProvider;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.CollectionDefinition;
import org.kuali.rice.krad.datadictionary.ComplexAttributeDefinition;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntry;
import org.kuali.rice.krad.datadictionary.DataDictionaryException;
import org.kuali.rice.krad.datadictionary.DictionaryBeanBase;
import org.kuali.rice.krad.datadictionary.PrimitiveAttributeDefinition;
import org.kuali.rice.krad.datadictionary.RelationshipDefinition;
import org.kuali.rice.krad.datadictionary.exception.DuplicateEntryException;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.state.StateMapping;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.exception.ValidationException;
import org.springframework.beans.BeanUtils;

public abstract class DataDictionaryEntryBase
extends DictionaryBeanBase
implements DataDictionaryEntry,
Serializable {
    private static final Logger LOG = LogManager.getLogger(DataDictionaryEntryBase.class);
    private static final long serialVersionUID = 5133059101016080533L;
    protected DataObjectMetadata dataObjectMetadata;
    protected List<AttributeDefinition> attributes = new ArrayList<AttributeDefinition>();
    protected List<ComplexAttributeDefinition> complexAttributes = new ArrayList<ComplexAttributeDefinition>();
    protected List<CollectionDefinition> collections = new ArrayList<CollectionDefinition>();
    protected List<RelationshipDefinition> relationships = new ArrayList<RelationshipDefinition>();
    protected Map<String, AttributeDefinition> attributeMap = new LinkedHashMap<String, AttributeDefinition>();
    protected Map<String, ComplexAttributeDefinition> complexAttributeMap = new LinkedHashMap<String, ComplexAttributeDefinition>();
    protected Map<String, CollectionDefinition> collectionMap = new LinkedHashMap<String, CollectionDefinition>();
    protected Map<String, RelationshipDefinition> relationshipMap = new LinkedHashMap<String, RelationshipDefinition>();
    protected StateMapping stateMapping;
    protected static final Set<String> EXCLUDED_PROPERTY_NAMES = new HashSet<String>();

    public abstract Class<?> getEntryClass();

    @Override
    public AttributeDefinition getAttributeDefinition(String attributeName) {
        if (StringUtils.isBlank((String)attributeName)) {
            throw new IllegalArgumentException("invalid (blank) attributeName");
        }
        return this.attributeMap.get(attributeName);
    }

    @BeanTagAttribute(name="attributes", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<AttributeDefinition> getAttributes() {
        return this.attributes;
    }

    public List<ComplexAttributeDefinition> getComplexAttributes() {
        return this.complexAttributes;
    }

    public void setComplexAttributes(List<ComplexAttributeDefinition> complexAttributes) {
        this.complexAttributeMap.clear();
        for (ComplexAttributeDefinition complexAttribute : complexAttributes) {
            if (complexAttribute == null) {
                throw new DataDictionaryException("invalid (null) complexAttributeDefinition on " + this);
            }
            String complexAttributeName = complexAttribute.getName();
            if (StringUtils.isBlank((String)complexAttributeName)) {
                throw new DataDictionaryException("invalid (blank) complexAttributeName on " + this);
            }
            if (this.complexAttributeMap.containsKey(complexAttributeName)) {
                throw new DuplicateEntryException("complex attribute '" + complexAttributeName + "' already defined as an complex attribute for class '" + this.getEntryClass().getName() + "'");
            }
            if (this.collectionMap.containsKey(complexAttributeName)) {
                throw new DuplicateEntryException("complex attribute '" + complexAttributeName + "' already defined as a Collection for class '" + this.getEntryClass().getName() + "'");
            }
            if (this.attributeMap.containsKey(complexAttributeName)) {
                throw new DuplicateEntryException("complex attribute '" + complexAttributeName + "' already defined as an Attribute for class '" + this.getEntryClass().getName() + "'");
            }
            this.complexAttributeMap.put(complexAttributeName, complexAttribute);
        }
        this.complexAttributes = complexAttributes;
    }

    public CollectionDefinition getCollectionDefinition(String collectionName) {
        if (StringUtils.isBlank((String)collectionName)) {
            throw new IllegalArgumentException("invalid (blank) collectionName");
        }
        return this.collectionMap.get(collectionName);
    }

    @BeanTagAttribute(name="collections", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<CollectionDefinition> getCollections() {
        return this.collections;
    }

    public RelationshipDefinition getRelationshipDefinition(String relationshipName) {
        if (StringUtils.isBlank((String)relationshipName)) {
            throw new IllegalArgumentException("invalid (blank) relationshipName");
        }
        return this.getRelationshipMap().get(relationshipName);
    }

    @Override
    @BeanTagAttribute(name="relationships", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<RelationshipDefinition> getRelationships() {
        return this.relationships;
    }

    @Override
    public void completeValidation() {
        this.completeValidation(new ValidationTrace());
    }

    protected void embedMetadata() {
        MetadataProvider metadataProvider = KradDataServiceLocator.getProviderRegistry().getMetadataProvider(this.getEntryClass());
        if (metadataProvider != null) {
            this.dataObjectMetadata = metadataProvider.getMetadataForType(this.getEntryClass());
            if (this.dataObjectMetadata == null) {
                LOG.warn("No metadata defined for " + this.getEntryClass() + " even though provider returned.");
            } else {
                this.injectMetadataIntoAttributes(this.dataObjectMetadata);
                this.injectMetadataIntoCollections(this.dataObjectMetadata);
                this.injectMetadataIntoRelationships(this.dataObjectMetadata);
            }
        } else {
            LOG.info("No metadata provider exists which handles: " + this.getEntryClass());
        }
    }

    protected void injectMetadataIntoRelationships(DataObjectMetadata dataObjectMetadata) {
        List<RelationshipDefinition> relationships = this.getRelationships();
        if (relationships == null) {
            relationships = new ArrayList<RelationshipDefinition>();
        }
        for (DataObjectRelationship rel : dataObjectMetadata.getRelationships()) {
            if (rel.getAttributeRelationships().isEmpty()) continue;
            if (StringUtils.isNotBlank((String)rel.getName())) {
                RelationshipDefinition relationshipDefinition = this.getRelationshipDefinition(rel.getName());
                if (relationshipDefinition != null) continue;
                relationshipDefinition = new RelationshipDefinition();
                relationshipDefinition.setObjectAttributeName(rel.getName());
                relationshipDefinition.setSourceClass(this.getEntryClass());
                relationshipDefinition.setTargetClass(rel.getRelatedType());
                for (DataObjectAttributeRelationship attrRel : rel.getAttributeRelationships()) {
                    PrimitiveAttributeDefinition attrDef = new PrimitiveAttributeDefinition();
                    attrDef.setSourceName(attrRel.getParentAttributeName());
                    attrDef.setTargetName(attrRel.getChildAttributeName());
                    relationshipDefinition.getPrimitiveAttributes().add(attrDef);
                }
                relationshipDefinition.setGeneratedFromMetadata(true);
                relationshipDefinition.setEmbeddedDataObjectMetadata(true);
                relationships.add(relationshipDefinition);
                continue;
            }
            LOG.warn("Relationship in metadata model contained blank name attribute: " + rel);
        }
    }

    protected void injectMetadataIntoCollections(DataObjectMetadata dataObjectMetadata) {
        List<CollectionDefinition> collections = this.getCollections();
        boolean collectionsChanged = false;
        if (collections == null) {
            collections = new ArrayList<CollectionDefinition>();
        }
        for (DataObjectCollection coll : dataObjectMetadata.getCollections()) {
            if (StringUtils.isNotBlank((String)coll.getName())) {
                if (this.getAttributeDefinition(coll.getName()) != null) continue;
                CollectionDefinition collectionDefinition = this.getCollectionDefinition(coll.getName());
                if (collectionDefinition == null) {
                    collectionDefinition = new CollectionDefinition();
                    collectionDefinition.setName(coll.getName());
                    collectionDefinition.setDataObjectClass(coll.getRelatedType().getName());
                    collectionDefinition.setGeneratedFromMetadata(true);
                    collections.add(collectionDefinition);
                    collectionsChanged = true;
                }
                collectionDefinition.setDataObjectCollection(coll);
                collectionDefinition.setEmbeddedDataObjectMetadata(true);
                continue;
            }
            LOG.warn("Relationship in metadata model contained blank name attribute: " + coll);
        }
        if (collectionsChanged) {
            this.setCollections(collections);
        }
    }

    protected void injectMetadataIntoAttributes(DataObjectMetadata dataObjectMetadata) {
        List<AttributeDefinition> originalDataObjectEntryAttributes = this.getAttributes();
        if (originalDataObjectEntryAttributes == null) {
            originalDataObjectEntryAttributes = new ArrayList<AttributeDefinition>();
        }
        ArrayList<AttributeDefinition> dataObjectEntryAttributes = new ArrayList<AttributeDefinition>();
        for (DataObjectAttribute attr : dataObjectMetadata.getAttributes()) {
            if (StringUtils.isBlank((String)attr.getName())) {
                LOG.warn("Attribute in metadata model contained blank name attribute: " + attr);
                continue;
            }
            if (EXCLUDED_PROPERTY_NAMES.contains(attr.getName())) continue;
            AttributeDefinition attributeDefinition = this.getAttributeDefinition(attr.getName());
            originalDataObjectEntryAttributes.remove(attributeDefinition);
            if (attributeDefinition == null) {
                attributeDefinition = new AttributeDefinition();
                attributeDefinition.setName(attr.getName());
                attributeDefinition.setGeneratedFromMetadata(true);
            }
            attributeDefinition.setDataObjectAttribute(attr);
            attributeDefinition.setEmbeddedDataObjectMetadata(true);
            dataObjectEntryAttributes.add(attributeDefinition);
        }
        dataObjectEntryAttributes.addAll(originalDataObjectEntryAttributes);
        this.setAttributes(dataObjectEntryAttributes);
    }

    @Override
    public void dataDictionaryPostProcessing() {
        super.dataDictionaryPostProcessing();
        this.embedMetadata();
        if (this.relationships != null) {
            this.relationshipMap.clear();
            for (RelationshipDefinition relationshipDefinition : this.relationships) {
                if (relationshipDefinition == null) {
                    LOG.warn("Skipping invalid (null) relationshipDefinition on " + this);
                    continue;
                }
                String relationshipName = relationshipDefinition.getObjectAttributeName();
                if (StringUtils.isBlank((String)relationshipName)) {
                    LOG.warn("Skipping invalid relationshipDefinition with blank relationshipName on " + this);
                    continue;
                }
                relationshipDefinition.setSourceClass(this.getEntryClass());
                this.relationshipMap.put(relationshipName, relationshipDefinition);
            }
        }
        if (this.complexAttributes != null) {
            for (ComplexAttributeDefinition complexAttributeDefinition : this.complexAttributes) {
                if (complexAttributeDefinition == null) continue;
                this.addNestedAttributes(complexAttributeDefinition, complexAttributeDefinition.getName());
            }
        }
        for (AttributeDefinition attributeDefinition : this.getAttributes()) {
            attributeDefinition.dataDictionaryPostProcessing();
        }
        for (CollectionDefinition collectionDefinition : this.getCollections()) {
            collectionDefinition.dataDictionaryPostProcessing();
        }
        for (RelationshipDefinition relationshipDefinition : this.getRelationships()) {
            relationshipDefinition.dataDictionaryPostProcessing();
        }
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        if (this.getEntryClass() != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing Validation for " + this.getClass().getSimpleName() + " for class: " + this.getEntryClass().getName());
            }
            tracer.addBean(this.getClass().getSimpleName(), this.getEntryClass().getSimpleName());
            for (AttributeDefinition attributeDefinition : this.getAttributes()) {
                attributeDefinition.completeValidation((Class)this.getEntryClass(), (Class)null, tracer.getCopy());
            }
            for (CollectionDefinition collectionDefinition : this.getCollections()) {
                collectionDefinition.completeValidation((Class)this.getEntryClass(), (Class)null, tracer.getCopy());
            }
            for (RelationshipDefinition relationshipDefinition : this.getRelationships()) {
                relationshipDefinition.completeValidation((Class)this.getEntryClass(), (Class)null, tracer.getCopy());
            }
        } else {
            tracer.addBean(this.getClass().getSimpleName(), this.toString());
            tracer.createError("DataObjectClass is not set,  remaining validations aborted", null);
        }
    }

    public void setAttributes(List<AttributeDefinition> attributes) {
        this.attributeMap.clear();
        for (AttributeDefinition attribute : attributes) {
            if (attribute == null) {
                throw new IllegalArgumentException("invalid (null) attributeDefinition");
            }
            String attributeName = attribute.getName();
            if (StringUtils.isBlank((String)attributeName)) {
                throw new ValidationException("invalid (blank) attributeName");
            }
            if (this.attributeMap.containsKey(attributeName)) {
                throw new DuplicateEntryException("attribute '" + attributeName + "' already defined as an Attribute for class '" + this.getEntryClass().getName() + "'");
            }
            if (this.collectionMap.containsKey(attributeName)) {
                throw new DuplicateEntryException("attribute '" + attributeName + "' already defined as a Collection for class '" + this.getEntryClass().getName() + "'");
            }
            if (this.complexAttributeMap.containsKey(attributeName)) {
                throw new DuplicateEntryException("attribute '" + attributeName + "' already defined as an Complex Attribute for class '" + this.getEntryClass().getName() + "'");
            }
            this.attributeMap.put(attributeName, attribute);
        }
        this.attributes = attributes;
    }

    public void setCollections(List<CollectionDefinition> collections) {
        this.collectionMap.clear();
        for (CollectionDefinition collection : collections) {
            if (collection == null) {
                throw new IllegalArgumentException("invalid (null) collectionDefinition");
            }
            String collectionName = collection.getName();
            if (StringUtils.isBlank((String)collectionName)) {
                throw new ValidationException("invalid (blank) collectionName");
            }
            if (this.collectionMap.containsKey(collectionName)) {
                throw new DuplicateEntryException("collection '" + collectionName + "' already defined for class '" + this.getEntryClass().getName() + "'");
            }
            if (this.attributeMap.containsKey(collectionName)) {
                throw new DuplicateEntryException("collection '" + collectionName + "' already defined as an Attribute for class '" + this.getEntryClass().getName() + "'");
            }
            if (this.complexAttributeMap.containsKey(collectionName)) {
                throw new DuplicateEntryException("collection '" + collectionName + "' already defined as Complex Attribute for class '" + this.getEntryClass().getName() + "'");
            }
            this.collectionMap.put(collectionName, collection);
        }
        this.collections = collections;
    }

    public void setRelationships(List<RelationshipDefinition> relationships) {
        this.relationships = relationships;
    }

    public Set<String> getCollectionNames() {
        return this.collectionMap.keySet();
    }

    public Set<String> getAttributeNames() {
        return this.attributeMap.keySet();
    }

    public Set<String> getRelationshipNames() {
        return this.relationshipMap.keySet();
    }

    private void addNestedAttributes(ComplexAttributeDefinition complexAttribute, String attrPath) {
        DataDictionaryEntryBase dataDictionaryEntry = (DataDictionaryEntryBase)complexAttribute.getDataObjectEntry();
        for (AttributeDefinition attribute : dataDictionaryEntry.getAttributes()) {
            String nestedAttributeName = attrPath + "." + attribute.getName();
            AttributeDefinition nestedAttribute = this.copyAttributeDefinition(attribute);
            nestedAttribute.setName(nestedAttributeName);
            if (this.attributeMap.containsKey(nestedAttributeName)) continue;
            this.attributes.add(nestedAttribute);
            this.attributeMap.put(nestedAttributeName, nestedAttribute);
        }
        List<ComplexAttributeDefinition> nestedComplexAttributes = dataDictionaryEntry.getComplexAttributes();
        if (nestedComplexAttributes != null) {
            for (ComplexAttributeDefinition nestedComplexAttribute : nestedComplexAttributes) {
                this.addNestedAttributes(nestedComplexAttribute, attrPath + "." + nestedComplexAttribute.getName());
            }
        }
    }

    private AttributeDefinition copyAttributeDefinition(AttributeDefinition attrDefToCopy) {
        AttributeDefinition attrDefCopy = new AttributeDefinition();
        try {
            BeanUtils.copyProperties((Object)attrDefToCopy, (Object)attrDefCopy, (String[])new String[]{"formatterClass"});
            attrDefCopy.setRequired(attrDefToCopy.isRequired());
        }
        catch (Exception e) {
            LOG.warn("Problem copying properties from attribute definition: " + attrDefToCopy, (Throwable)e);
        }
        return attrDefCopy;
    }

    @Override
    @BeanTagAttribute(name="stateMapping", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public StateMapping getStateMapping() {
        return this.stateMapping;
    }

    @Override
    public void setStateMapping(StateMapping stateMapping) {
        this.stateMapping = stateMapping;
    }

    public boolean hasEmbeddedDataObjectMetadata() {
        return this.getDataObjectMetadata() != null;
    }

    public DataObjectMetadata getDataObjectMetadata() {
        return this.dataObjectMetadata;
    }

    public void setDataObjectMetadata(DataObjectMetadata dataObjectMetadata) {
        this.dataObjectMetadata = dataObjectMetadata;
    }

    public Map<String, RelationshipDefinition> getRelationshipMap() {
        if (this.relationshipMap.isEmpty() && !this.getRelationships().isEmpty()) {
            for (RelationshipDefinition rel : this.getRelationships()) {
                this.relationshipMap.put(rel.getObjectAttributeName(), rel);
            }
        }
        return this.relationshipMap;
    }

    public void setRelationshipMap(Map<String, RelationshipDefinition> relationshipMap) {
        this.relationshipMap = relationshipMap;
    }

    static {
        EXCLUDED_PROPERTY_NAMES.add("objectId");
        EXCLUDED_PROPERTY_NAMES.add("versionNumber");
    }
}

