/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.modifier;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleUtils;
import org.kuali.rice.krad.uif.modifier.ComponentModifierBase;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.util.RecycleUtils;

@BeanTags(value={@BeanTag(name="componentConverterModifier", parent="Uif-ComponentConverter-Modifier"), @BeanTag(name="checkboxToRadioConverterModifier", parent="Uif-CheckboxToRadioConverter-Modifier")})
public class ComponentConvertModifier
extends ComponentModifierBase {
    private static final long serialVersionUID = -7566547737669924605L;
    private Class<? extends Component> componentTypeToReplace;
    private Component componentReplacementPrototype;

    @Override
    public void performModification(Object model, Component component) {
        if (component == null) {
            return;
        }
        int idSuffix = 0;
        this.convertToReplacement(component, idSuffix);
    }

    protected void convertToReplacement(Component component, int idSuffix) {
        if (component == null) {
            return;
        }
        Queue elementQueue = RecycleUtils.getInstance(LinkedList.class);
        elementQueue.offer(component);
        while (elementQueue.isEmpty()) {
            LifecycleElement element = (LifecycleElement)elementQueue.poll();
            elementQueue.addAll(ViewLifecycleUtils.getElementsForLifecycle(element).values());
            if (!(element instanceof Component)) continue;
            Set<String> componentProperties = ObjectPropertyUtils.getReadablePropertyNames(component.getClass());
            for (String propertyPath : componentProperties) {
                Object propValue = ObjectPropertyUtils.getPropertyValue(component, propertyPath);
                if (propValue == null || !this.getComponentTypeToReplace().isAssignableFrom(propValue.getClass())) continue;
                this.performConversion(component, propertyPath, idSuffix++);
            }
        }
        elementQueue.clear();
        RecycleUtils.recycle(elementQueue);
    }

    protected void performConversion(Component component, String componentProperty, int idSuffix) {
        Component componentReplacement = ComponentUtils.copy(this.getComponentReplacementPrototype(), Integer.toString(idSuffix));
        ObjectPropertyUtils.setPropertyValue(component, componentProperty, componentReplacement);
    }

    @Override
    public Set<Class<? extends Component>> getSupportedComponents() {
        HashSet<Class<? extends Component>> components = new HashSet<Class<? extends Component>>();
        components.add(Component.class);
        return components;
    }

    @Override
    public List<Component> getComponentPrototypes() {
        ArrayList<Component> components = new ArrayList<Component>();
        components.add(this.componentReplacementPrototype);
        return components;
    }

    @BeanTagAttribute
    public Class<? extends Component> getComponentTypeToReplace() {
        return this.componentTypeToReplace;
    }

    public void setComponentTypeToReplace(Class<? extends Component> componentTypeToReplace) {
        this.componentTypeToReplace = componentTypeToReplace;
    }

    @BeanTagAttribute
    public Component getComponentReplacementPrototype() {
        return this.componentReplacementPrototype;
    }

    public void setComponentReplacementPrototype(Component componentReplacementPrototype) {
        this.componentReplacementPrototype = componentReplacementPrototype;
    }
}

