/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.action.search.SearchShard;
import org.elasticsearch.action.search.SearchShardIterator;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.aggregations.InternalAggregations;

abstract class SearchProgressListener {
    private static final Logger logger = LogManager.getLogger(SearchProgressListener.class);
    public static final SearchProgressListener NOOP = new SearchProgressListener(){};
    private List<SearchShard> shards;

    SearchProgressListener() {
    }

    public void onListShards(List<SearchShard> shards, boolean fetchPhase) {
    }

    public void onQueryResult(int shardIndex) {
    }

    public void onQueryFailure(int shardIndex, Exception exc) {
    }

    public void onPartialReduce(List<SearchShard> shards, TotalHits totalHits, InternalAggregations aggs, int version) {
    }

    public void onReduce(List<SearchShard> shards, TotalHits totalHits, InternalAggregations aggs) {
    }

    public void onFetchResult(int shardIndex) {
    }

    public void onFetchFailure(int shardIndex, Exception exc) {
    }

    final void notifyListShards(List<SearchShard> shards, boolean fetchPhase) {
        this.shards = shards;
        try {
            this.onListShards(shards, fetchPhase);
        }
        catch (Exception e) {
            logger.warn(() -> new ParameterizedMessage("Failed to execute progress listener on list shards", new Object[0]), (Throwable)e);
        }
    }

    final void notifyQueryResult(int shardIndex) {
        try {
            this.onQueryResult(shardIndex);
        }
        catch (Exception e) {
            logger.warn(() -> new ParameterizedMessage("[{}] Failed to execute progress listener on query result", (Object)this.shards.get(shardIndex)), (Throwable)e);
        }
    }

    final void notifyQueryFailure(int shardIndex, Exception exc) {
        try {
            this.onQueryFailure(shardIndex, exc);
        }
        catch (Exception e) {
            logger.warn(() -> new ParameterizedMessage("[{}] Failed to execute progress listener on query failure", (Object)this.shards.get(shardIndex)), (Throwable)e);
        }
    }

    final void notifyPartialReduce(List<SearchShard> shards, TotalHits totalHits, InternalAggregations aggs, int version) {
        try {
            this.onPartialReduce(shards, totalHits, aggs, version);
        }
        catch (Exception e) {
            logger.warn(() -> new ParameterizedMessage("Failed to execute progress listener on partial reduce", new Object[0]), (Throwable)e);
        }
    }

    final void notifyReduce(List<SearchShard> shards, TotalHits totalHits, InternalAggregations aggs) {
        try {
            this.onReduce(shards, totalHits, aggs);
        }
        catch (Exception e) {
            logger.warn(() -> new ParameterizedMessage("Failed to execute progress listener on reduce", new Object[0]), (Throwable)e);
        }
    }

    final void notifyFetchResult(int shardIndex) {
        try {
            this.onFetchResult(shardIndex);
        }
        catch (Exception e) {
            logger.warn(() -> new ParameterizedMessage("[{}] Failed to execute progress listener on fetch result", (Object)this.shards.get(shardIndex)), (Throwable)e);
        }
    }

    final void notifyFetchFailure(int shardIndex, Exception exc) {
        try {
            this.onFetchFailure(shardIndex, exc);
        }
        catch (Exception e) {
            logger.warn(() -> new ParameterizedMessage("[{}] Failed to execute progress listener on fetch failure", (Object)this.shards.get(shardIndex)), (Throwable)e);
        }
    }

    final List<SearchShard> searchShards(List<? extends SearchPhaseResult> results) {
        List lst = results.stream().filter(Objects::nonNull).map(SearchPhaseResult::getSearchShardTarget).map(e -> new SearchShard(e.getClusterAlias(), e.getShardId())).collect(Collectors.toList());
        return Collections.unmodifiableList(lst);
    }

    final List<SearchShard> searchShards(SearchShardTarget[] results) {
        List lst = Arrays.stream(results).filter(Objects::nonNull).map(e -> new SearchShard(e.getClusterAlias(), e.getShardId())).collect(Collectors.toList());
        return Collections.unmodifiableList(lst);
    }

    final List<SearchShard> searchShards(GroupShardsIterator<SearchShardIterator> its) {
        List lst = StreamSupport.stream(its.spliterator(), false).map(e -> new SearchShard(e.getClusterAlias(), e.shardId())).collect(Collectors.toList());
        return Collections.unmodifiableList(lst);
    }
}

