/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermStates;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.ConstantIndexFieldData;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.query.QueryShardContext;

public class TypeFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_type";
    public static final String CONTENT_TYPE = "_type";

    private TypeFieldMapper(IndexSettings indexSettings, MappedFieldType existing) {
        this(existing == null ? TypeFieldMapper.defaultFieldType(indexSettings) : existing.clone(), indexSettings);
    }

    private TypeFieldMapper(MappedFieldType fieldType, IndexSettings indexSettings) {
        super("_type", fieldType, TypeFieldMapper.defaultFieldType(indexSettings), indexSettings.getSettings());
    }

    private static MappedFieldType defaultFieldType(IndexSettings indexSettings) {
        MappedFieldType defaultFieldType = Defaults.FIELD_TYPE.clone();
        defaultFieldType.setIndexOptions(IndexOptions.NONE);
        defaultFieldType.setHasDocValues(false);
        return defaultFieldType;
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public void parse(ParseContext context) throws IOException {
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        if (this.fieldType().indexOptions() == IndexOptions.NONE && !this.fieldType().stored()) {
            return;
        }
        fields.add((IndexableField)new Field(this.fieldType().name(), (CharSequence)context.sourceToParse().type(), (IndexableFieldType)this.fieldType()));
        if (this.fieldType().hasDocValues()) {
            fields.add((IndexableField)new SortedSetDocValuesField(this.fieldType().name(), new BytesRef((CharSequence)context.sourceToParse().type())));
        }
    }

    @Override
    protected String contentType() {
        return "_type";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder;
    }

    @Override
    protected void doMerge(Mapper mergeWith) {
    }

    public static class Defaults {
        public static final String NAME = "_type";
        public static final MappedFieldType FIELD_TYPE = new TypeFieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setName("_type");
            FIELD_TYPE.freeze();
        }
    }

    public static class TypesQuery
    extends Query {
        private static final int BOOLEAN_REWRITE_TERM_COUNT_THRESHOLD = 16;
        private final BytesRef[] types;

        public TypesQuery(BytesRef ... types) {
            if (types == null) {
                throw new NullPointerException("types cannot be null.");
            }
            if (types.length == 0) {
                throw new IllegalArgumentException("types must contains at least one value.");
            }
            this.types = types;
        }

        public BytesRef[] getTerms() {
            return this.types;
        }

        public Query rewrite(IndexReader reader) throws IOException {
            int threshold = Math.min(16, BooleanQuery.getMaxClauseCount());
            if (this.types.length <= threshold) {
                HashSet<BytesRef> uniqueTypes = new HashSet<BytesRef>();
                BooleanQuery.Builder bq = new BooleanQuery.Builder();
                int totalDocFreq = 0;
                for (BytesRef type : this.types) {
                    if (!uniqueTypes.add(type)) continue;
                    Term term = new Term("_type", type);
                    TermStates context = TermStates.build((IndexReaderContext)reader.getContext(), (Term)term, (boolean)true);
                    if (context.docFreq() == 0) continue;
                    if ((totalDocFreq += context.docFreq()) >= reader.maxDoc()) {
                        assert (totalDocFreq == reader.maxDoc());
                        return new MatchAllDocsQuery();
                    }
                    bq.add((Query)new TermQuery(term, context), BooleanClause.Occur.SHOULD);
                }
                return new ConstantScoreQuery((Query)bq.build());
            }
            return new TermInSetQuery("_type", this.types);
        }

        public boolean equals(Object obj) {
            if (!this.sameClassAs(obj)) {
                return false;
            }
            TypesQuery that = (TypesQuery)((Object)obj);
            return Arrays.equals(this.types, that.types);
        }

        public int hashCode() {
            return 31 * this.classHash() + Arrays.hashCode(this.types);
        }

        public String toString(String field) {
            StringBuilder builder = new StringBuilder();
            for (BytesRef type : this.types) {
                if (builder.length() > 0) {
                    builder.append(' ');
                }
                builder.append(new Term("_type", type).toString());
            }
            return builder.toString();
        }
    }

    public static final class TypeFieldType
    extends StringFieldType {
        TypeFieldType() {
        }

        protected TypeFieldType(TypeFieldType ref) {
            super(ref);
        }

        @Override
        public MappedFieldType clone() {
            return new TypeFieldType(this);
        }

        @Override
        public String typeName() {
            return "_type";
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            Function<MapperService, String> typeFunction = mapperService -> mapperService.documentMapper().type();
            return new ConstantIndexFieldData.Builder(typeFunction);
        }

        @Override
        public boolean isSearchable() {
            return true;
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            return new MatchAllDocsQuery();
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            return this.termsQuery(Arrays.asList(value), context);
        }

        @Override
        public Query termsQuery(List<?> values, QueryShardContext context) {
            DocumentMapper mapper = context.getMapperService().documentMapper();
            if (mapper == null) {
                return new MatchNoDocsQuery("No types");
            }
            BytesRef indexType = this.indexedValueForSearch(mapper.type());
            if (values.stream().map(this::indexedValueForSearch).anyMatch(arg_0 -> ((BytesRef)indexType).equals(arg_0))) {
                if (context.getMapperService().hasNested()) {
                    return Queries.newNonNestedFilter(context.indexVersionCreated());
                }
                return new MatchAllDocsQuery();
            }
            return new MatchNoDocsQuery("Type list does not contain the index type");
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
            MatchAllDocsQuery result = new MatchAllDocsQuery();
            String type = context.getMapperService().documentMapper().type();
            if (type != null) {
                int comp;
                BytesRef typeBytes = new BytesRef((CharSequence)type);
                if (lowerTerm != null && ((comp = this.indexedValueForSearch(lowerTerm).compareTo(typeBytes)) > 0 || comp == 0 && !includeLower)) {
                    result = new MatchNoDocsQuery("[_type] was lexicographically smaller than lower bound of range");
                }
                if (upperTerm != null && ((comp = this.indexedValueForSearch(upperTerm).compareTo(typeBytes)) < 0 || comp == 0 && !includeUpper)) {
                    result = new MatchNoDocsQuery("[_type] was lexicographically greater than upper bound of range");
                }
            }
            return result;
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        @Override
        public MetadataFieldMapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            throw new MapperParsingException("_type is not configurable");
        }

        @Override
        public MetadataFieldMapper getDefault(MappedFieldType fieldType, Mapper.TypeParser.ParserContext context) {
            IndexSettings indexSettings = context.mapperService().getIndexSettings();
            return new TypeFieldMapper(indexSettings, fieldType);
        }
    }
}

