/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.schemaspy.model.Database;
import net.sourceforge.schemaspy.model.Table;

public class RemoteTable
extends Table {
    private final String baseContainer;
    private static final Logger logger = Logger.getLogger(RemoteTable.class.getName());
    private static final boolean finerEnabled = logger.isLoggable(Level.FINER);

    public RemoteTable(Database database, String string, String string2, String string3, String string4) throws SQLException {
        super(database, string, string2, string3, null);
        this.baseContainer = string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectForeignKeys(Map<String, Table> map) throws SQLException {
        if (finerEnabled) {
            logger.finer("Connecting foreign keys to " + this.getFullName());
        }
        try (ResultSet resultSet = null;){
            resultSet = this.db.getMetaData().getImportedKeys(this.getCatalog(), this.getSchema(), this.getName());
            while (resultSet.next()) {
                String string = resultSet.getString("PKTABLE_SCHEM");
                String string2 = resultSet.getString("PKTABLE_CAT");
                if (!this.baseContainer.equals(string) && !this.baseContainer.equals(string2)) continue;
                this.addForeignKey(resultSet.getString("FK_NAME"), resultSet.getString("FKCOLUMN_NAME"), string2, string, resultSet.getString("PKTABLE_NAME"), resultSet.getString("PKCOLUMN_NAME"), resultSet.getInt("UPDATE_RULE"), resultSet.getInt("DELETE_RULE"), map);
            }
        }
    }

    @Override
    public boolean isRemote() {
        return true;
    }
}

