/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.doctype;

import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlElement;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.api.doctype.RoutePath;
import org.kuali.rice.kew.api.document.node.RouteNodeInstance;
import org.springframework.cache.annotation.Cacheable;

@WebService(name="documentTypeService", targetNamespace="http://rice.kuali.org/kew/v2_0")
@SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
public interface DocumentTypeService {
    @WebMethod(operationName="getIdByName")
    @WebResult(name="documentTypeId")
    @XmlElement(name="documentTypeId", required=false)
    public String getIdByName(@WebParam(name="documentTypeName") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getNameById")
    @WebResult(name="documentTypeName")
    @XmlElement(name="documentTypeName", required=false)
    public String getNameById(@WebParam(name="documentTypeId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getDocumentTypeById")
    @WebResult(name="documentType")
    @XmlElement(name="documentType", required=false)
    @Cacheable(value={"http://rice.kuali.org/kew/v2_0/DocumentTypeType"}, key="'documentTypeId=' + #p0")
    public DocumentType getDocumentTypeById(@WebParam(name="documentTypeId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getDocumentTypeByName")
    @WebResult(name="documentType")
    @XmlElement(name="documentType", required=false)
    @Cacheable(value={"http://rice.kuali.org/kew/v2_0/DocumentTypeType"}, key="'documentTypeName=' + #p0")
    public DocumentType getDocumentTypeByName(@WebParam(name="documentTypeName") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findAllDocumentTypes")
    @WebResult(name="documentTypes")
    @XmlElement(name="documentTypes", required=false)
    @Cacheable(value={"http://rice.kuali.org/kew/v2_0/DocumentTypeType"}, key="'all'")
    public List<DocumentType> findAllDocumentTypes();

    @WebMethod(operationName="isSuperUserForDocumentTypeId")
    @WebResult(name="isSuperUser")
    @XmlElement(name="isSuperUser", required=true)
    public boolean isSuperUserForDocumentTypeId(@WebParam(name="principalId") String var1, @WebParam(name="documentTypeId") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="isSuperUserForDocumentTypeName")
    @WebResult(name="isSuperUser")
    @XmlElement(name="isSuperUser", required=true)
    public boolean isSuperUserForDocumentTypeName(@WebParam(name="principalId") String var1, @WebParam(name="documentTypeName") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="canSuperUserApproveSingleActionRequest")
    @WebResult(name="isSuperUser")
    @XmlElement(name="isSuperUser", required=true)
    public boolean canSuperUserApproveSingleActionRequest(@WebParam(name="principalId") String var1, @WebParam(name="documentTypeName") String var2, @WebParam(name="routeNodeInstances") List<RouteNodeInstance> var3, @WebParam(name="routeStatusCode") String var4) throws RiceIllegalArgumentException;

    @WebMethod(operationName="canSuperUserApproveDocument")
    @WebResult(name="isSuperUser")
    @XmlElement(name="isSuperUser", required=true)
    public boolean canSuperUserApproveDocument(@WebParam(name="principalId") String var1, @WebParam(name="documentTypeName") String var2, @WebParam(name="routeNodeInstances") List<RouteNodeInstance> var3, @WebParam(name="routeStatusCode") String var4) throws RiceIllegalArgumentException;

    @WebMethod(operationName="canSuperUserDisapproveDocument")
    @WebResult(name="isSuperUser")
    @XmlElement(name="isSuperUser", required=true)
    public boolean canSuperUserDisapproveDocument(@WebParam(name="principalId") String var1, @WebParam(name="documentTypeName") String var2, @WebParam(name="routeNodeInstances") List<RouteNodeInstance> var3, @WebParam(name="routeStatusCode") String var4) throws RiceIllegalArgumentException;

    @WebMethod(operationName="hasRouteNodeForDocumentTypeName")
    @WebResult(name="hasRouteNode")
    @XmlElement(name="hasRouteNode", required=true)
    public boolean hasRouteNodeForDocumentTypeName(@WebParam(name="routeNodeName") String var1, @WebParam(name="documentTypeName") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="hasRouteNodeForDocumentTypeId")
    @WebResult(name="hasRouteNode")
    @XmlElement(name="hasRouteNode", required=true)
    public boolean hasRouteNodeForDocumentTypeId(@WebParam(name="routeNodeName") String var1, @WebParam(name="documentTypeId") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="isActiveById")
    @WebResult(name="isActive")
    @XmlElement(name="isActive", required=true)
    public boolean isActiveById(@WebParam(name="documentTypeId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="isActiveByName")
    @WebResult(name="isActive")
    @XmlElement(name="isActive", required=true)
    public boolean isActiveByName(@WebParam(name="documentTypeName") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getRoutePathForDocumentTypeId")
    @WebResult(name="routePath")
    @XmlElement(name="routePath", required=false)
    @Cacheable(value={"http://rice.kuali.org/kew/v2_0/RoutePathType"}, key="'documentTypeId=' + #p0")
    public RoutePath getRoutePathForDocumentTypeId(@WebParam(name="documentTypeId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getRoutePathForDocumentTypeName")
    @WebResult(name="routePath")
    @XmlElement(name="routePath", required=false)
    @Cacheable(value={"http://rice.kuali.org/kew/v2_0/RoutePathType"}, key="'documentTypeName=' + #p0")
    public RoutePath getRoutePathForDocumentTypeName(@WebParam(name="documentTypeName") String var1) throws RiceIllegalArgumentException;
}

