/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.keyword;

import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.keyword.AbstractScienceKeyword;
import org.kuali.coeus.common.framework.keyword.KeywordsManager;
import org.kuali.coeus.common.framework.keyword.KeywordsService;
import org.kuali.coeus.common.framework.keyword.ScienceKeyword;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.model.MultiLookupForm;
import org.kuali.rice.kns.lookup.LookupResultsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="keywordsService")
public class KeywordsServiceImpl
implements KeywordsService {
    private static final Logger LOG = LogManager.getLogger(KeywordsServiceImpl.class);
    @Autowired
    @Qualifier(value="lookupResultsService")
    private LookupResultsService lookupResultsService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;

    public void addKeyword(KeywordsManager document, ScienceKeyword scienceKeyword) {
        if (!this.isDuplicateKeyword(scienceKeyword.getCode(), document.getKeywords())) {
            document.addKeyword(scienceKeyword);
        }
    }

    public void deleteKeyword(KeywordsManager keywordsDocument) {
        List scienceKeywords = keywordsDocument.getKeywords();
        for (int i = scienceKeywords.size() - 1; i >= 0; --i) {
            AbstractScienceKeyword abstractScienceKeyword = (AbstractScienceKeyword)scienceKeywords.get(i);
            if (!abstractScienceKeyword.getSelectKeyword().booleanValue()) continue;
            scienceKeywords.remove(abstractScienceKeyword);
        }
    }

    protected boolean isDuplicateKeyword(String newScienceKeywordCode, List<AbstractScienceKeyword> keywords) {
        for (AbstractScienceKeyword abstractScienceKeyword : keywords) {
            if (!newScienceKeywordCode.equals(abstractScienceKeyword.getScienceKeywordCode())) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public void addKeywords(KeywordsManager document, MultiLookupForm multiLookUpForm) {
        try {
            String lookupResultsSequenceNumber;
            if ("multipleValues".equals(multiLookUpForm.getRefreshCaller()) && StringUtils.isNotBlank((CharSequence)(lookupResultsSequenceNumber = multiLookUpForm.getLookupResultsSequenceNumber()))) {
                Class<ScienceKeyword> lookupResultsBOClass = Class.forName(multiLookUpForm.getLookupResultsBOClassName());
                Collection rawValues = this.lookupResultsService.retrieveSelectedResultBOs(lookupResultsSequenceNumber, lookupResultsBOClass, this.globalVariableService.getUserSession().getPrincipalId());
                if (lookupResultsBOClass.isAssignableFrom(ScienceKeyword.class)) {
                    for (ScienceKeyword scienceKeyword : rawValues) {
                        this.addKeyword(document, scienceKeyword);
                    }
                }
            }
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public LookupResultsService getLookupResultsService() {
        return this.lookupResultsService;
    }

    public void setLookupResultsService(LookupResultsService lookupResultsService) {
        this.lookupResultsService = lookupResultsService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }
}

