/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.location;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.propdev.api.location.CongressionalDistrictContract;
import org.kuali.coeus.propdev.impl.location.ProposalSite;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;

@Entity
@Table(name="EPS_PROP_CONG_DISTRICT")
public class CongressionalDistrict
extends KcPersistableBusinessObjectBase
implements CongressionalDistrictContract {
    public static final int DISTRICT_NUMBER_LENGTH = 3;
    private static final long serialVersionUID = 9043098848918407500L;
    @PortableSequenceGenerator(name="SEQ_CONG_DISTRICT_ID_KRA")
    @GeneratedValue(generator="SEQ_CONG_DISTRICT_ID_KRA")
    @Id
    @Column(name="CONG_DISTRICT_ID")
    private Long id;
    @ManyToOne(cascade={CascadeType.REFRESH})
    @JoinColumns(value={@JoinColumn(name="PROPOSAL_NUMBER", referencedColumnName="PROPOSAL_NUMBER"), @JoinColumn(name="SITE_NUMBER", referencedColumnName="SITE_NUMBER")})
    private ProposalSite proposalSite;
    @Column(name="CONG_DISTRICT")
    private String congressionalDistrict;
    @Transient
    private String newState;
    @Transient
    private String newDistrictNumber;

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public String getCongressionalDistrict() {
        return this.congressionalDistrict;
    }

    public void setCongressionalDistrict(String stateCode, String districtNumber) {
        this.setCongressionalDistrict(stateCode + "-" + districtNumber);
    }

    public void setCongressionalDistrict(String congressionalDistrict) {
        this.congressionalDistrict = congressionalDistrict;
    }

    public String getNewState() {
        return this.newState;
    }

    public void setNewState(String newState) {
        this.newState = newState;
    }

    public String getNewDistrictNumber() {
        if (StringUtils.isNumeric((CharSequence)this.newDistrictNumber)) {
            this.newDistrictNumber = StringUtils.leftPad((String)this.newDistrictNumber, (int)3, (String)"0");
        }
        return this.newDistrictNumber;
    }

    public void setNewDistrictNumber(String newDistrictNumber) {
        this.newDistrictNumber = newDistrictNumber;
    }

    public ProposalSite getProposalSite() {
        return this.proposalSite;
    }

    public void setProposalSite(ProposalSite proposalSite) {
        this.proposalSite = proposalSite;
    }

    public Integer getSiteNumber() {
        if (this.getProposalSite() != null) {
            return this.getProposalSite().getSiteNumber();
        }
        return null;
    }

    public String getProposalNumber() {
        if (this.getProposalSite() != null && this.getProposalSite().getDevelopmentProposal() != null) {
            return this.getProposalSite().getDevelopmentProposal().getProposalNumber();
        }
        return null;
    }
}

