/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s.map;

import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.api.income.BudgetProjectIncomeContract;
import org.kuali.coeus.propdev.api.budget.ProposalDevelopmentBudgetExtContract;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.kuali.coeus.propdev.impl.s2s.map.BudgetMappingService;
import org.kuali.coeus.propdev.impl.s2s.map.BudgetPeriod;
import org.kuali.coeus.propdev.impl.s2s.map.BudgetSummary;
import org.kuali.coeus.propdev.impl.s2s.map.ProjectIncome;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.springframework.stereotype.Service;

@Service(value="budgetMappingService")
public class BudgetMappingServiceImpl
implements BudgetMappingService {
    @Override
    public BudgetSummary getBudgetSummary(DevelopmentProposalContract proposal) {
        BudgetSummary budgetSummary = new BudgetSummary();
        ProposalDevelopmentBudgetExtContract budget = Optional.ofNullable(proposal.getFinalBudget()).orElseGet(() -> ((DevelopmentProposalContract)proposal).getLatestBudget());
        if (budget != null) {
            budgetSummary.setBudgetPeriods(budget.getBudgetPeriods().stream().map(budgetPeriod -> {
                BudgetPeriod p = new BudgetPeriod();
                p.setBudgetPeriod(budgetPeriod.getBudgetPeriod());
                p.setProjectIncome(budget.getBudgetProjectIncomes().stream().filter(projectIncome -> budgetPeriod.getBudgetPeriod().equals(projectIncome.getBudgetPeriodNumber())).reduce(new ProjectIncome(), (pi, projectIncome) -> this.sumIncomes((ProjectIncome)pi, this.toProjectIncome((BudgetProjectIncomeContract)projectIncome)), this::sumIncomes));
                return p;
            }).collect(Collectors.toList()));
        }
        return budgetSummary;
    }

    private ProjectIncome toProjectIncome(BudgetProjectIncomeContract incomeContract) {
        ProjectIncome projectIncome = new ProjectIncome();
        projectIncome.setSource(incomeContract.getDescription());
        projectIncome.setAnticipatedAmount(incomeContract.getProjectIncome().doubleValue());
        return projectIncome;
    }

    private ProjectIncome sumIncomes(ProjectIncome a, ProjectIncome b) {
        ProjectIncome agg = new ProjectIncome();
        agg.setAnticipatedAmount(((ScaleTwoDecimal)Optional.ofNullable(a.getAnticipatedAmount()).map(ScaleTwoDecimal::new).orElse(ScaleTwoDecimal.ZERO).add((AbstractDecimal)Optional.ofNullable(b.getAnticipatedAmount()).map(ScaleTwoDecimal::new).orElse(ScaleTwoDecimal.ZERO))).doubleValue());
        if (StringUtils.isNotBlank((CharSequence)a.getSource())) {
            if (StringUtils.isNotBlank((CharSequence)b.getSource())) {
                agg.setSource(a.getSource() + ";" + b.getSource());
            } else {
                agg.setSource(a.getSource());
            }
        } else if (StringUtils.isNotBlank((CharSequence)b.getSource())) {
            agg.setSource(b.getSource());
        }
        return agg;
    }
}

