/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s.nih;

import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.safety.Whitelist;
import org.kuali.coeus.propdev.impl.s2s.nih.NihValidationMappingOverrideType;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;

public class NihValidationMapping
extends KcPersistableBusinessObjectBase {
    public static final String A_TAG = "a";
    public static final String HREF = "href";
    public static final String TARGET = "target";
    private Long id;
    private String ruleNumber;
    private String customMessage;
    private boolean forceError = Boolean.FALSE;
    private String overrideTypeValue = NihValidationMappingOverrideType.NONE.name();
    private boolean appendToOriginal = Boolean.TRUE;
    private String pageId;
    private String sectionId;
    private boolean active = Boolean.TRUE;

    public String getRuleNumber() {
        return this.ruleNumber;
    }

    public void setRuleNumber(String ruleNumber) {
        this.ruleNumber = ruleNumber;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCustomMessage() {
        return this.customMessage;
    }

    public void setCustomMessage(String customMessage) {
        this.customMessage = customMessage;
    }

    public boolean getForceError() {
        return this.forceError;
    }

    public void setForceError(boolean forceError) {
        this.forceError = forceError;
    }

    public String getOverrideTypeValue() {
        return this.overrideTypeValue;
    }

    public void setOverrideTypeValue(String overrideTypeValue) {
        this.overrideTypeValue = overrideTypeValue;
    }

    public NihValidationMappingOverrideType getOverrideType() {
        return NihValidationMappingOverrideType.valueOf(this.getOverrideTypeValue());
    }

    public void setOverrideType(NihValidationMappingOverrideType overrideType) {
        this.setOverrideTypeValue(overrideType == null ? NihValidationMappingOverrideType.NONE.name() : overrideType.name());
    }

    public boolean getAppendToOriginal() {
        return this.appendToOriginal;
    }

    public void setAppendToOriginal(boolean appendToOriginal) {
        this.appendToOriginal = appendToOriginal;
    }

    public String getPageId() {
        return this.pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public String getSectionId() {
        return this.sectionId;
    }

    public void setSectionId(String sectionId) {
        this.sectionId = sectionId;
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    protected void prePersist() {
        super.prePersist();
        this.cleanCustomMessage();
    }

    @Override
    protected void preUpdate() {
        super.preUpdate();
        this.cleanCustomMessage();
    }

    public void cleanCustomMessage() {
        if (StringUtils.isNotBlank((CharSequence)this.customMessage)) {
            Whitelist basic = Whitelist.basic();
            basic.addAttributes(A_TAG, new String[]{HREF, TARGET});
            this.setCustomMessage(Jsoup.clean((String)this.customMessage, (Whitelist)basic));
        }
    }
}

