/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.service;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.sys.framework.config.DbConnectionConfigUtil;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.impl.config.property.JAXBConfigImpl;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class KcApplicationInitializer
implements ServletContextListener {
    private static final Logger LOG = LogManager.getLogger(KcApplicationInitializer.class);
    private static final String DEFAULT_SPRING_BEANS_REPLACEMENT_VALUE = "${bootstrap.spring.file}";
    private static final String LOCALE_PROPERTY_NAME = "locale";
    private static final String WEB_BOOTSTRAP_SPRING_FILE = "web.bootstrap.spring.file";
    private static final String QUARTZ_START = "quartz.start";
    private static final String SPRING_PROFILES_ACTIVE_FROM_BUILD_PROPERTY = "spring.profiles.active.from.build";
    private static final String SPRING_PROFILES_ACTIVE_FROM_CONFIG_PROPERTY = "spring.profiles.active.from.config";
    private static final String SPRING_PROFILES_ACTIVE_PROPERTY = "spring.profiles.active";
    private static final String SPRING_PROFILES_DELIMITER = ",";
    private XmlWebApplicationContext context;

    public void contextInitialized(ServletContextEvent sce) {
        String bootstrapSpringInitParam;
        long startInit = System.currentTimeMillis();
        LOG.info("Initializing Kuali Coeus Application...");
        System.setProperty("org.terracotta.quartz.skipUpdateCheck", "true");
        String bootstrapSpringBeans = "";
        if (!StringUtils.isBlank((CharSequence)System.getProperty(WEB_BOOTSTRAP_SPRING_FILE))) {
            bootstrapSpringBeans = System.getProperty(WEB_BOOTSTRAP_SPRING_FILE);
        } else if (!StringUtils.isBlank((CharSequence)sce.getServletContext().getInitParameter(WEB_BOOTSTRAP_SPRING_FILE)) && !DEFAULT_SPRING_BEANS_REPLACEMENT_VALUE.equals(bootstrapSpringInitParam = sce.getServletContext().getInitParameter(WEB_BOOTSTRAP_SPRING_FILE))) {
            bootstrapSpringBeans = bootstrapSpringInitParam;
            LOG.info("Found bootstrap Spring Beans file defined in servlet context: " + bootstrapSpringBeans);
        }
        Properties baseProps = new Properties();
        baseProps.putAll((Map<?, ?>)this.getContextParameters(sce.getServletContext()));
        baseProps.putAll((Map<?, ?>)System.getProperties());
        String configFile = baseProps.getProperty("web.bootstrap.config.file");
        JAXBConfigImpl config = StringUtils.isNotBlank((CharSequence)configFile) ? new JAXBConfigImpl(configFile, baseProps) : new JAXBConfigImpl(baseProps);
        try {
            config.parseConfig();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        config.putProperties(System.getProperties());
        this.configureActiveSpringProfiles(config);
        DbConnectionConfigUtil.setUpdatedDatabaseConnection(config);
        ConfigContext.init((Config)config);
        this.setDefaultLocale(config.getProperty(LOCALE_PROPERTY_NAME));
        this.context = new XmlWebApplicationContext();
        if (!StringUtils.isEmpty((CharSequence)bootstrapSpringBeans)) {
            this.context.setConfigLocation(bootstrapSpringBeans);
        }
        this.context.setServletContext(sce.getServletContext());
        this.context.refresh();
        this.context.start();
        KcServiceLocator.setAppContext((ApplicationContext)this.getContext());
        this.getDistinctSchedulers().forEach(s -> this.start((Scheduler)s, ConfigContext.getCurrentContextConfig().getBooleanProperty(QUARTZ_START)));
        long endInit = System.currentTimeMillis();
        LOG.info("...Kuali Coeus Application successfully initialized, startup took " + (endInit - startInit) + " ms.");
    }

    protected Properties getContextParameters(ServletContext context) {
        Properties properties = new Properties();
        for (String paramName : org.kuali.rice.core.api.util.collect.CollectionUtils.toIterable((Enumeration)context.getInitParameterNames())) {
            properties.put(paramName, context.getInitParameter(paramName));
        }
        return properties;
    }

    protected void setDefaultLocale(String locale) {
        if (StringUtils.isNotBlank((CharSequence)locale)) {
            try {
                Locale.setDefault(LocaleUtils.toLocale((String)locale));
            }
            catch (IllegalArgumentException e) {
                LOG.error(String.format("Invalid locale format: %s", locale), (Throwable)e);
            }
        }
    }

    protected void configureActiveSpringProfiles(JAXBConfigImpl config) {
        String activeProfiles;
        if (StringUtils.isBlank((CharSequence)System.getProperty(SPRING_PROFILES_ACTIVE_PROPERTY)) && StringUtils.isNotBlank((CharSequence)(activeProfiles = Stream.of(config.getProperty(SPRING_PROFILES_ACTIVE_FROM_BUILD_PROPERTY), config.getProperty(SPRING_PROFILES_ACTIVE_FROM_CONFIG_PROPERTY)).filter(StringUtils::isNotBlank).map(String::trim).distinct().collect(Collectors.joining(SPRING_PROFILES_DELIMITER))))) {
            System.setProperty(SPRING_PROFILES_ACTIVE_PROPERTY, activeProfiles);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        LOG.info("Shutting down Kuali Coeus...");
        this.getDistinctSchedulers().forEach(s -> this.shutdown((Scheduler)s, ConfigContext.getCurrentContextConfig().getBooleanProperty(QUARTZ_START)));
        if (this.context != null) {
            this.context.close();
        }
        LOG.info("...completed shutdown of Kuali Coeus.");
    }

    private Stream<Scheduler> getDistinctSchedulers() {
        return KcServiceLocator.getServicesOfType(Scheduler.class).stream().filter(CollectionUtils.distinctByKey(this::getSchedulerName));
    }

    private String getSchedulerName(Scheduler scheduler) {
        try {
            return scheduler.getSchedulerName();
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    private void start(Scheduler scheduler, boolean start) {
        try {
            if (!scheduler.isStarted()) {
                if (start) {
                    LOG.info("Starting Scheduler on Context Initialized: " + scheduler.getSchedulerName());
                    scheduler.start();
                } else {
                    LOG.info("Ignoring Scheduler on Context Initialized - quartz.start=" + start + ": " + scheduler.getSchedulerName());
                }
            } else {
                LOG.warn("Ignoring Scheduler on Context Initialized - Already Started" + (String)(start ? "" : " but quartz.start=" + start) + ": " + scheduler.getSchedulerName());
            }
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    private void shutdown(Scheduler scheduler, boolean start) {
        try {
            if (!scheduler.isShutdown()) {
                if (start) {
                    LOG.info("Stopping Scheduler on Context Destroyed: " + scheduler.getSchedulerName());
                } else {
                    LOG.warn("Stopping Scheduler on Context Destroyed - quartz.start=" + start + ": " + scheduler.getSchedulerName());
                }
                scheduler.shutdown();
            } else if (start) {
                LOG.warn("Ignoring Scheduler on Context Destroyed - Already Stopped but quartz.start=" + start + ": " + scheduler.getSchedulerName());
            } else {
                LOG.info("Ignoring Scheduler on Context Destroyed - Already Stopped: " + scheduler.getSchedulerName());
            }
        }
        catch (SchedulerException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public XmlWebApplicationContext getContext() {
        return this.context;
    }
}

