/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.view;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.util.RiceConstants;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.uif.view.TransactionalDocumentView;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.web.form.TransactionalDocumentFormBase;

public class KcTransactionalDocumentView
extends TransactionalDocumentView {
    private static final String KC_ERROR_TRANSACTIONAL_LOCKED = "kc.error.transactional.locked";
    private ParameterService parameterService;

    public List<String> getAdditionalScriptFiles() {
        List files = super.getAdditionalScriptFiles();
        if (!files.contains("scripts/sys/pessimisticLock.js")) {
            files.add("scripts/sys/pessimisticLock.js");
            this.setAdditionalScriptFiles(files);
        }
        return files;
    }

    protected void generatePessimisticLockMessages(TransactionalDocumentFormBase form) {
        if (!this.getParameterService().getParameterValueAsBoolean("KC-GEN", "All", "ALLOW_CLEAR_PESSIMISTIC_LOCK").booleanValue()) {
            super.generatePessimisticLockMessages(form);
        } else {
            Document document = form.getDocument();
            Person user = GlobalVariables.getUserSession().getPerson();
            for (PessimisticLock lock : document.getPessimisticLocks()) {
                if (lock.isOwnedByUser(user)) continue;
                String lockDescriptor = (String)StringUtils.defaultIfBlank((CharSequence)lock.getLockDescriptor(), (CharSequence)"full");
                String lockOwner = lock.getOwnedByUser().getName();
                String lockTime = RiceConstants.getDefaultTimeFormat().format(lock.getGeneratedTimestamp());
                String lockDate = RiceConstants.getDefaultDateFormat().format(lock.getGeneratedTimestamp());
                GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", KC_ERROR_TRANSACTIONAL_LOCKED, new String[]{lockDescriptor, lockOwner, lockTime, lockDate, lock.getId().toString()});
            }
        }
    }

    public ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

