/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.service.AwardHierarchyUIService;
import org.kuali.kra.timeandmoney.AwardHierarchyNode;
import org.kuali.rice.kns.inquiry.KualiInquirableImpl;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.kns.web.ui.Section;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.util.ObjectUtils;

public class AwardInquirable
extends KualiInquirableImpl {
    private static final Logger LOG = LogManager.getLogger(AwardInquirable.class);

    public List<Section> getSections(BusinessObject bo) {
        ArrayList<Section> sections = new ArrayList<Section>();
        Section section = new Section();
        section.setRows(new ArrayList());
        section.setDefaultOpen(true);
        section.setNumberOfColumns(2);
        AwardHierarchyUIService service = this.getAwardHierarchyUIService();
        Award award = (Award)bo;
        AwardHierarchyNode awardNode = null;
        try {
            awardNode = service.getRootAwardNode(award);
        }
        catch (ParseException e) {
            LOG.error("Error parsing award information", (Throwable)e);
        }
        Object sectionTitle = "";
        sectionTitle = (String)sectionTitle + awardNode.getAwardNumber();
        sectionTitle = (String)sectionTitle + " ";
        sectionTitle = (String)sectionTitle + ":";
        sectionTitle = (String)sectionTitle + " ";
        if (ObjectUtils.isNotNull((Object)award.getAccountNumber())) {
            sectionTitle = (String)sectionTitle + awardNode.getAccountNumber();
            sectionTitle = (String)sectionTitle + " ";
            sectionTitle = (String)sectionTitle + ":";
            sectionTitle = (String)sectionTitle + " ";
        }
        if (ObjectUtils.isNotNull((Object)awardNode.getPrincipalInvestigatorName())) {
            sectionTitle = (String)sectionTitle + awardNode.getPrincipalInvestigatorName();
            sectionTitle = (String)sectionTitle + " ";
            sectionTitle = (String)sectionTitle + ":";
            sectionTitle = (String)sectionTitle + " ";
        }
        if (ObjectUtils.isNotNull((Object)awardNode.getLeadUnitName())) {
            sectionTitle = (String)sectionTitle + awardNode.getLeadUnitName();
        }
        section.setSectionTitle((String)sectionTitle);
        section.setRows(new ArrayList());
        Row row1 = new Row();
        this.addField("" + awardNode.getProjectStartDate(), row1, "projectStartDate", "Project Start Date");
        this.addField("" + awardNode.getCurrentFundEffectiveDate(), row1, "obligationStartDate", "Obligation Start Date");
        section.getRows().add(row1);
        Row row2 = new Row();
        this.addField("" + awardNode.getFinalExpirationDate(), row2, "projectEndDate", "Project End Date");
        this.addField("" + awardNode.getObligationExpirationDate(), row2, "obligationEndDate", "Obligation End Date");
        section.getRows().add(row2);
        Row row3 = new Row();
        this.addField("" + awardNode.getAnticipatedTotalAmount(), row3, "anticipatedAmount", "Anticipated Amount");
        this.addField("" + awardNode.getAmountObligatedToDate(), row3, "obligatedAmount", "Obligated Amount");
        section.getRows().add(row3);
        Row row4 = new Row();
        this.addField(awardNode.getTitle(), row4, "title", "Title");
        this.addField(award.getSponsorAwardNumber(), row4, "sponsorAwardNumber", "Sponsor Award Number");
        section.getRows().add(row4);
        Row row5 = new Row();
        this.addField(award.getAwardNumber(), row5, "awardNumber", "Award Number");
        this.addField(award.getAwardStatus().getStatusCode(), row5, "awardStatusCode", "Award Status Code");
        section.getRows().add(row5);
        Row row6 = new Row();
        this.addField(award.getOspAdministratorName(), row6, "ospAdminName", "OSP Administrator Name");
        this.addField("" + award.getCloseoutDate(), row6, "closeoutDate", "Closeout Date");
        section.getRows().add(row6);
        section.getRows().addAll(IntStream.range(0, award.getAwardCfdas().size()).mapToObj(i -> {
            Row row = new Row();
            this.addField(award.getAwardCfdas().get(i).getCfdaNumber(), row, String.format("awardCfdas[%s].cfdaNumber", i), "CFDA Number " + i + "1");
            this.addField(award.getAwardCfdas().get(i).getCfdaNumber(), row, String.format("awardCfdas[%s].cfdaDescription", i), "CFDA Program Title Name " + i + "1");
            return row;
        }).collect(Collectors.toList()));
        sections.add(section);
        return sections;
    }

    private void addField(String text, Row row1, String propertyName, String fieldLabel) {
        Field field = new Field();
        field.setPropertyName(propertyName);
        field.setFieldLabel(fieldLabel);
        field.setFieldType("text");
        if (StringUtils.equalsIgnoreCase((CharSequence)text, (CharSequence)" &nbsp; ")) {
            text = "";
        }
        field.setPropertyValue(text);
        row1.getFields().add(field);
    }

    private AwardHierarchyUIService getAwardHierarchyUIService() {
        return KcServiceLocator.getService(AwardHierarchyUIService.class);
    }
}

