/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.lookup.keyvalue;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.kuali.coeus.sys.framework.keyvalue.FormViewAwareUifKeyValuesFinderBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.lookup.AwardTransactionLookupService;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;

public class AwardTransactionValuesFinder
extends FormViewAwareUifKeyValuesFinderBase {
    private AwardTransactionLookupService transactionLookupService;

    public List<KeyValue> getKeyValues() {
        AwardForm form = this.getAwardForm();
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        Integer usableSequence = form.getAwardPrintChangeReport().getAwardVersion();
        if (usableSequence == null) {
            usableSequence = form.getAwardDocument().getAward().getSequenceNumber();
        }
        Map<Integer, String> transactionValues = this.getTransactionLookupService().getApplicableTransactionIds(form.getAwardDocument().getAward().getAwardNumber(), usableSequence);
        keyValues.addAll(transactionValues.entrySet().stream().map(entry -> new ConcreteKeyValue(((Integer)entry.getKey()).toString(), (String)entry.getValue())).collect(Collectors.toList()));
        return keyValues;
    }

    private AwardForm getAwardForm() {
        return (AwardForm)this.getFormOrView();
    }

    public AwardTransactionLookupService getTransactionLookupService() {
        if (this.transactionLookupService == null) {
            this.transactionLookupService = KcServiceLocator.getService(AwardTransactionLookupService.class);
        }
        return this.transactionLookupService;
    }

    public void setTransactionLookupService(AwardTransactionLookupService transactionLookupService) {
        this.transactionLookupService = transactionLookupService;
    }
}

