/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.project;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.excon.project.ExconProjectAssociate;
import org.kuali.kra.excon.project.ExconProjectAssociatedDocumentType;
import org.kuali.kra.excon.project.service.ExconProjectService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;

public class ExconProjectAssociatedDocument
extends ExconProjectAssociate
implements Comparable<ExconProjectAssociatedDocument> {
    private static final long serialVersionUID = 12345233343469217L;
    private static final Logger LOG = LogManager.getLogger(ExconProjectAssociatedDocument.class);
    private Long projectAssocDocId;
    private String assocDocTypeCode;
    private String assocDocNumber;
    private String assocDocTitle;
    private ExconProjectAssociatedDocumentType assocDocType;
    private transient ConfigurationService configurationService;
    private transient ExconProjectService exconProjectService;

    public Long getProjectAssocDocId() {
        return this.projectAssocDocId;
    }

    public void setProjectAssocDocId(Long projectAssocDocId) {
        this.projectAssocDocId = projectAssocDocId;
    }

    public String getAssocDocTypeCode() {
        return this.assocDocTypeCode;
    }

    public void setAssocDocTypeCode(String assocDocTypeCode) {
        this.assocDocTypeCode = assocDocTypeCode;
    }

    public String getAssocDocNumber() {
        return this.assocDocNumber;
    }

    public void setAssocDocNumber(String assocDocNumber) {
        this.assocDocNumber = assocDocNumber;
    }

    public String getAssocDocTitle() {
        return this.assocDocTitle;
    }

    public void setAssocDocTitle(String assocDocTitle) {
        this.assocDocTitle = assocDocTitle;
    }

    public ExconProjectAssociatedDocumentType getAssocDocType() {
        if (this.assocDocTypeCode != null) {
            this.refreshReferenceObject("assocDocType");
        }
        return this.assocDocType;
    }

    public void setAssocDocType(ExconProjectAssociatedDocumentType assocDocType) {
        this.assocDocType = assocDocType;
    }

    public Class<PersistableBusinessObject> getAssocDocTypeClass() {
        try {
            return Class.forName(this.getAssocDocType().getAssocDocTypeClassName());
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getAssocDocViewURL() {
        String docViewURL = this.getConfigurationService().getPropertyValueAsString("kc.excon.assocDoc.viewURL." + this.getAssocDocTypeCode());
        if (!StringUtils.isEmpty((CharSequence)docViewURL)) {
            docViewURL = docViewURL.replace("[assocDocNumber]", this.getAssocDocNumber());
        } else {
            Optional<Document> document = this.getExconProjectService().getAssociatedDocument(this);
            if (document.isPresent()) {
                return this.getConfigurationService().getPropertyValueAsString("kew.url") + "/DocHandler.do?command=displayDocSearchView&docId=" + document.get().getDocumentNumber();
            }
        }
        return docViewURL;
    }

    public String getAssocDocLookupURL(String formKey) {
        String docLookupURL = null;
        String docLookupURLParm = this.getConfigurationService().getPropertyValueAsString("kc.excon.assocDoc.lookupURL." + this.getAssocDocTypeCode());
        if (!StringUtils.isEmpty((CharSequence)docLookupURLParm)) {
            docLookupURL = docLookupURLParm.replace("[formKey]", formKey);
        }
        return docLookupURL;
    }

    @Override
    public void resetPersistenceState() {
        this.projectAssocDocId = null;
        this.versionNumber = null;
    }

    @Override
    public int compareTo(ExconProjectAssociatedDocument exconProjectAssociatedDocumentArg) {
        return exconProjectAssociatedDocumentArg.getProjectAssocDocId().compareTo(this.getProjectAssocDocId());
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ExconProjectAssociatedDocument)) {
            return false;
        }
        ExconProjectAssociatedDocument oDoc = (ExconProjectAssociatedDocument)o;
        if (this.getProjectAssocDocId() != null) {
            return oDoc.getProjectAssocDocId().equals(this.getProjectAssocDocId());
        }
        return oDoc.getAssocDocTypeCode().equals(this.getAssocDocTypeCode()) && oDoc.getAssocDocNumber().equals(this.getAssocDocNumber());
    }

    private ConfigurationService getConfigurationService() {
        if (this.configurationService == null) {
            this.configurationService = KcServiceLocator.getService(ConfigurationService.class);
        }
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public ExconProjectService getExconProjectService() {
        if (this.exconProjectService == null) {
            this.exconProjectService = KcServiceLocator.getService(ExconProjectService.class);
        }
        return this.exconProjectService;
    }

    public void setExconProjectService(ExconProjectService exconProjectService) {
        this.exconProjectService = exconProjectService;
    }
}

