/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.shipment.document.authorization;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.kuali.coeus.common.framework.auth.KcTransactionalDocumentAuthorizerBase;
import org.kuali.kra.excon.shipment.document.ExconIntlShipmentDocument;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;

public class ExconIntlShipmentDocumentAuthorizer
extends KcTransactionalDocumentAuthorizerBase {
    private static final long serialVersionUID = 23244002799843L;

    public Set<String> getEditModes(Document document, Person user, Set<String> currentEditModes) {
        HashSet<String> editModes = new HashSet<String>();
        String userId = user.getPrincipalId();
        ExconIntlShipmentDocument exconIntlShipmentDocument = (ExconIntlShipmentDocument)document;
        if (exconIntlShipmentDocument.getExconIntlShipment().getApplicantId() == null) {
            editModes.add("fullEntry");
        } else {
            if (this.canEdit((Document)exconIntlShipmentDocument, user) && exconIntlShipmentDocument.isEditable()) {
                editModes.add("fullEntry");
            } else if (this.canOpen((Document)exconIntlShipmentDocument, user)) {
                editModes.add("viewOnly");
            } else {
                editModes.add("unviewable");
            }
            if (this.canCreateExconIntlShipment(userId)) {
                editModes.add("createExconIntlShipment");
            }
        }
        return editModes;
    }

    private boolean canCreateExconIntlShipment(String userId) {
        return true;
    }

    public boolean canOpen(Document document, Person user) {
        ExconIntlShipmentDocument exconIntlShipmentDocument = (ExconIntlShipmentDocument)document;
        if (exconIntlShipmentDocument.getExconIntlShipment().getShipmentId() == null) {
            return true;
        }
        if (exconIntlShipmentDocument.getExconIntlShipment().getApplicantId().equals(GlobalVariables.getUserSession().getPrincipalId())) {
            return true;
        }
        return this.canEditAll(user);
    }

    @Override
    public boolean canApprove(Document document, Person user) {
        return this.isWaitingApproval(document) && !this.isWaitingComplete(document);
    }

    @Override
    public boolean canDisapprove(Document document, Person user) {
        return this.canApprove(document, user);
    }

    @Override
    public boolean canComplete(Document document) {
        return super.canComplete(document) || this.isWaitingComplete(document);
    }

    protected boolean canEditAll(Person user) {
        HashMap<String, String> roleQualifiers = new HashMap<String, String>();
        roleQualifiers.put("projectTypeCode", "RPS");
        return ExconIntlShipmentDocumentAuthorizer.getPermissionService().isAuthorized(user.getPrincipalId(), "KC-EXCON", "Create Project Document", roleQualifiers);
    }

    @Override
    protected boolean isFinal(Document document) {
        return "F".equals(document.getDocumentHeader().getWorkflowDocument().getStatus().getCode());
    }

    protected boolean isProcessed(Document document) {
        boolean isProcessed = false;
        String status = document.getDocumentHeader().getWorkflowDocument().getStatus().getCode();
        if (status.equalsIgnoreCase("P")) {
            isProcessed = true;
        }
        return isProcessed;
    }

    @Override
    protected boolean isEnroute(Document document) {
        return "R".equals(document.getDocumentHeader().getWorkflowDocument().getStatus().getCode());
    }

    protected boolean isInitiated(Document document) {
        return "I".equals(document.getDocumentHeader().getWorkflowDocument().getStatus().getCode());
    }

    protected boolean isWaitingComplete(Document document) {
        return this.isEnroute(document) && document.getDocumentHeader().getWorkflowDocument().getRequestedActions().contains(ActionRequestType.COMPLETE);
    }

    protected boolean isWaitingApproval(Document document) {
        return this.isEnroute(document) && document.getDocumentHeader().getWorkflowDocument().getRequestedActions().contains(ActionRequestType.APPROVE);
    }

    public boolean canInitiate(String documentTypeName, Person user) {
        return this.canCreateExconIntlShipment(user.getPrincipalId());
    }

    @Override
    public boolean canEdit(Document document, Person user) {
        return this.canOpen(document, user) || this.canEditAll(user);
    }

    public boolean canSendNoteFyi(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canFyi(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canSave(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canClose(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canBlanketApprove(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canSendAdhocRequests(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canReload(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canCancel(Document document, Person user) {
        return this.isInitiated(document);
    }
}

