/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.service.impl;

import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.impl.krms.KcKrmsJavaFunctionTermServiceBase;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.subaward.bo.SubAwardAmountInfo;
import org.kuali.kra.subaward.bo.SubAwardAttachment;
import org.kuali.kra.subaward.bo.SubAwardComment;
import org.kuali.kra.subaward.bo.SubAwardFundingSource;
import org.kuali.kra.subaward.bo.SubAwardTemplateAttachment;
import org.kuali.kra.subaward.service.SubAwardJavaFunctionKrmsTermService;

public class SubAwardJavaFunctionKrmsTermServiceImpl
extends KcKrmsJavaFunctionTermServiceBase
implements SubAwardJavaFunctionKrmsTermService {
    @Override
    public Boolean ffataCrosscheck(SubAward subAward, Double obligatedAmountGreaterThan) {
        boolean foundFederalSponsorInFundingSources = subAward.getSubAwardFundingSourceList().stream().map(SubAwardFundingSource::getActiveAward).anyMatch(this::hasFederalSponsorCode);
        return subAward.getFfataRequired() == false && subAward.getTotalObligatedAmount().isGreaterThan((AbstractDecimal)new ScaleTwoDecimal(obligatedAmountGreaterThan.doubleValue())) && foundFederalSponsorInFundingSources;
    }

    private Boolean hasFederalSponsorCode(Award award) {
        Collection federalSponsorTypes = this.getParameterService().getParameterValuesAsString(AwardDocument.class, "FEDERAL_SPONSOR_TYPE_CODE");
        return federalSponsorTypes.contains(award.getSponsor().getSponsorTypeCode()) || award.getPrimeSponsor() != null && federalSponsorTypes.contains(award.getPrimeSponsor().getSponsorTypeCode());
    }

    @Override
    public Boolean purchaseOrderOnActiveEntryIsNotNull(SubAward subAward) {
        SubAwardAmountInfo latestSubAwardAmountInfo = subAward.getLatestSubAwardAmountInfo();
        return latestSubAwardAmountInfo != null && latestSubAwardAmountInfo.getPurchaseOrderNum() != null;
    }

    @Override
    public Boolean checkCommentEntered(SubAward subaward, String commentTypeCode) {
        if (commentTypeCode != null && commentTypeCode.equalsIgnoreCase("null")) {
            commentTypeCode = null;
        }
        for (SubAwardComment comment : subaward.getSubAwardComments()) {
            if (!StringUtils.equals((CharSequence)comment.getCommentTypeCode(), (CharSequence)commentTypeCode) || !StringUtils.isNotBlank((CharSequence)comment.getComments())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean subAwardCommentsRule(SubAward subaward, String comments, String commentTypeCode) {
        String commentOfSameType = this.getCommentOfType(commentTypeCode, subaward);
        return commentOfSameType == null && comments.equalsIgnoreCase("null") || StringUtils.equalsIgnoreCase((CharSequence)comments, (CharSequence)commentOfSameType);
    }

    private String getCommentOfType(String commentTypeCode, SubAward subaward) {
        SubAwardComment subAwardComment = subaward.getSubAwardComments().stream().filter(comment -> StringUtils.equals((CharSequence)comment.getCommentTypeCode(), (CharSequence)commentTypeCode)).findFirst().orElse(null);
        return subAwardComment == null ? null : subAwardComment.getComments();
    }

    @Override
    public Boolean attachmentTypeRule(SubAward subaward, String attachmentTypeCode) {
        List<SubAwardAttachment> attachments = subaward.getSubAwardAttachments();
        for (SubAwardAttachment attachment : attachments) {
            if (!StringUtils.equals((CharSequence)attachment.getSubAwardAttachmentTypeCode().toString(), (CharSequence)attachmentTypeCode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean templateAttachmentTypeRule(SubAward subaward, String attachmentTypeCode) {
        List<SubAwardTemplateAttachment> attachments = subaward.getSubAwardTemplateAttachments();
        for (SubAwardTemplateAttachment attachment : attachments) {
            if (!StringUtils.equals((CharSequence)attachment.getSubAwardAttachmentTypeCode().toString(), (CharSequence)attachmentTypeCode)) continue;
            return true;
        }
        return false;
    }
}

