/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.identity.personal;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Years;
import org.joda.time.format.DateTimeFormat;
import org.kuali.rice.kim.api.identity.personal.EntityBioDemographics;
import org.kuali.rice.kim.api.identity.personal.EntityBioDemographicsContract;
import org.kuali.rice.kim.api.identity.privacy.EntityPrivacyPreferences;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.bo.DataObjectBase;

@Entity
@Table(name="KRIM_ENTITY_BIO_T")
public class EntityBioDemographicsBo
extends DataObjectBase
implements EntityBioDemographicsContract,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="ENTITY_ID")
    private String entityId;
    @Temporal(value=TemporalType.DATE)
    @Column(name="BIRTH_DT")
    private Date birthDateValue;
    @Column(name="GNDR_CD")
    private String genderCode;
    @Column(name="GNDR_CHG_CD")
    private String genderChangeCode;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DECEASED_DT")
    private Date deceasedDateValue;
    @Column(name="MARITAL_STATUS")
    private String maritalStatusCode;
    @Column(name="PRIM_LANG_CD")
    private String primaryLanguageCode;
    @Column(name="SEC_LANG_CD")
    private String secondaryLanguageCode;
    @Column(name="BIRTH_CNTRY_CD")
    private String birthCountry;
    @Column(name="BIRTH_STATE_PVC_CD")
    private String birthStateProvinceCode;
    @Column(name="BIRTH_CITY")
    private String birthCity;
    @Column(name="GEO_ORIGIN")
    private String geographicOrigin;
    @Column(name="NOTE_MSG")
    private String noteMessage;
    @Transient
    private boolean suppressPersonal;

    public static EntityBioDemographics to(EntityBioDemographicsBo bo) {
        if (bo == null) {
            return null;
        }
        return EntityBioDemographics.Builder.create((EntityBioDemographicsContract)bo).build();
    }

    public static EntityBioDemographicsBo from(EntityBioDemographics immutable) {
        if (immutable == null) {
            return null;
        }
        EntityBioDemographicsBo bo = new EntityBioDemographicsBo();
        bo._persistence_set_entityId(immutable.getEntityId());
        if (immutable.getBirthDateUnmasked() != null) {
            bo._persistence_set_birthDateValue(DateTimeFormat.forPattern((String)"yyyy-MM-dd").parseDateTime(immutable.getBirthDateUnmasked()).toDate());
        }
        bo._persistence_set_birthStateProvinceCode(immutable.getBirthStateProvinceCodeUnmasked());
        bo._persistence_set_birthCity(immutable.getBirthCityUnmasked());
        bo._persistence_set_birthCountry(immutable.getBirthCountryUnmasked());
        if (immutable.getDeceasedDate() != null) {
            bo._persistence_set_deceasedDateValue(DateTimeFormat.forPattern((String)"yyyy-MM-dd").parseDateTime(immutable.getDeceasedDate()).toDate());
        }
        bo._persistence_set_genderCode(immutable.getGenderCodeUnmasked());
        bo._persistence_set_geographicOrigin(immutable.getGeographicOriginUnmasked());
        bo._persistence_set_maritalStatusCode(immutable.getMaritalStatusCodeUnmasked());
        bo._persistence_set_primaryLanguageCode(immutable.getPrimaryLanguageCodeUnmasked());
        bo._persistence_set_secondaryLanguageCode(immutable.getSecondaryLanguageCodeUnmasked());
        bo._persistence_set_noteMessage(immutable.getNoteMessage());
        bo.suppressPersonal = immutable.isSuppressPersonal();
        bo.setVersionNumber(immutable.getVersionNumber());
        bo.setObjectId(immutable.getObjectId());
        return bo;
    }

    public String getBirthDate() {
        if (this._persistence_get_birthDateValue() != null) {
            if (this.isSuppressPersonal()) {
                return "Xxxxxx";
            }
            return new SimpleDateFormat("yyyy-MM-dd").format(this._persistence_get_birthDateValue());
        }
        return null;
    }

    public Integer getAge() {
        if (this._persistence_get_birthDateValue() != null && !this.isSuppressPersonal()) {
            DateTime endDate = this._persistence_get_deceasedDateValue() != null ? new DateTime((Object)this._persistence_get_deceasedDateValue()) : new DateTime();
            return Years.yearsBetween((ReadableInstant)new DateTime((Object)this._persistence_get_birthDateValue()), (ReadableInstant)endDate).getYears();
        }
        return null;
    }

    public String getDeceasedDate() {
        if (this._persistence_get_deceasedDateValue() != null) {
            return new SimpleDateFormat("yyyy-MM-dd").format(this._persistence_get_deceasedDateValue());
        }
        return null;
    }

    public String getBirthDateUnmasked() {
        if (this._persistence_get_birthDateValue() != null) {
            return new SimpleDateFormat("yyyy-MM-dd").format(this._persistence_get_birthDateValue());
        }
        return null;
    }

    public boolean isSuppressPersonal() {
        try {
            EntityPrivacyPreferences privacy = KimApiServiceLocator.getIdentityService().getEntityPrivacyPreferences(this.getEntityId());
            this.suppressPersonal = privacy != null ? privacy.isSuppressPersonal() : false;
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (ClassCastException c) {
            return false;
        }
        return this.suppressPersonal;
    }

    public String getGenderCode() {
        if (this.isSuppressPersonal()) {
            return "XX";
        }
        return this._persistence_get_genderCode();
    }

    public String getGenderChangeCode() {
        if (this.isSuppressPersonal()) {
            return "XX";
        }
        return this._persistence_get_genderChangeCode();
    }

    public String getMaritalStatusCode() {
        if (this.isSuppressPersonal()) {
            return "XX";
        }
        return this._persistence_get_maritalStatusCode();
    }

    public String getPrimaryLanguageCode() {
        if (this.isSuppressPersonal()) {
            return "XX";
        }
        return this._persistence_get_primaryLanguageCode();
    }

    public String getSecondaryLanguageCode() {
        if (this.isSuppressPersonal()) {
            return "XX";
        }
        return this._persistence_get_secondaryLanguageCode();
    }

    public String getBirthCountry() {
        if (this.isSuppressPersonal()) {
            return "XX";
        }
        return this._persistence_get_birthCountry();
    }

    public String getBirthStateProvinceCode() {
        if (this.isSuppressPersonal()) {
            return "XX";
        }
        return this._persistence_get_birthStateProvinceCode();
    }

    public String getBirthCity() {
        if (this.isSuppressPersonal()) {
            return "XX";
        }
        return this._persistence_get_birthCity();
    }

    public String getGeographicOrigin() {
        if (this.isSuppressPersonal()) {
            return "XX";
        }
        return this._persistence_get_geographicOrigin();
    }

    public String getGenderCodeUnmasked() {
        return this._persistence_get_genderCode();
    }

    public String getGenderChangeCodeUnmasked() {
        return this._persistence_get_genderChangeCode();
    }

    public String getMaritalStatusCodeUnmasked() {
        return this._persistence_get_maritalStatusCode();
    }

    public String getPrimaryLanguageCodeUnmasked() {
        return this._persistence_get_primaryLanguageCode();
    }

    public String getSecondaryLanguageCodeUnmasked() {
        return this._persistence_get_secondaryLanguageCode();
    }

    public String getBirthCountryUnmasked() {
        return this._persistence_get_birthCountry();
    }

    public String getBirthStateProvinceCodeUnmasked() {
        return this._persistence_get_birthStateProvinceCode();
    }

    public String getBirthCityUnmasked() {
        return this._persistence_get_birthCity();
    }

    public String getGeographicOriginUnmasked() {
        return this._persistence_get_geographicOrigin();
    }

    public String getEntityId() {
        return this._persistence_get_entityId();
    }

    public void setEntityId(String entityId) {
        this._persistence_set_entityId(entityId);
    }

    public Date getBirthDateValue() {
        return this._persistence_get_birthDateValue();
    }

    public void setBirthDateValue(Date birthDateValue) {
        this._persistence_set_birthDateValue(birthDateValue);
    }

    public void setGenderCode(String genderCode) {
        this._persistence_set_genderCode(genderCode);
    }

    public void setGenderChangeCode(String genderChangeCode) {
        this._persistence_set_genderChangeCode(genderChangeCode);
    }

    public Date getDeceasedDateValue() {
        return this._persistence_get_deceasedDateValue();
    }

    public void setDeceasedDateValue(Date deceasedDateValue) {
        this._persistence_set_deceasedDateValue(deceasedDateValue);
    }

    public void setMaritalStatusCode(String maritalStatusCode) {
        this._persistence_set_maritalStatusCode(maritalStatusCode);
    }

    public void setPrimaryLanguageCode(String primaryLanguageCode) {
        this._persistence_set_primaryLanguageCode(primaryLanguageCode);
    }

    public void setSecondaryLanguageCode(String secondaryLanguageCode) {
        this._persistence_set_secondaryLanguageCode(secondaryLanguageCode);
    }

    public void setBirthCountry(String birthCountry) {
        this._persistence_set_birthCountry(birthCountry);
    }

    public void setBirthStateProvinceCode(String birthStateProvinceCode) {
        this._persistence_set_birthStateProvinceCode(birthStateProvinceCode);
    }

    public void setBirthCity(String birthCity) {
        this._persistence_set_birthCity(birthCity);
    }

    public void setGeographicOrigin(String geographicOrigin) {
        this._persistence_set_geographicOrigin(geographicOrigin);
    }

    public String getNoteMessage() {
        return this._persistence_get_noteMessage();
    }

    public void setNoteMessage(String noteMessage) {
        this._persistence_set_noteMessage(noteMessage);
    }

    public void setSuppressPersonal(boolean suppressPersonal) {
        this.suppressPersonal = suppressPersonal;
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new EntityBioDemographicsBo();
    }

    public Object _persistence_get(String string) {
        if (string == "birthDateValue") {
            return this.birthDateValue;
        }
        if (string == "entityId") {
            return this.entityId;
        }
        if (string == "birthCity") {
            return this.birthCity;
        }
        if (string == "noteMessage") {
            return this.noteMessage;
        }
        if (string == "secondaryLanguageCode") {
            return this.secondaryLanguageCode;
        }
        if (string == "maritalStatusCode") {
            return this.maritalStatusCode;
        }
        if (string == "genderCode") {
            return this.genderCode;
        }
        if (string == "birthStateProvinceCode") {
            return this.birthStateProvinceCode;
        }
        if (string == "primaryLanguageCode") {
            return this.primaryLanguageCode;
        }
        if (string == "birthCountry") {
            return this.birthCountry;
        }
        if (string == "deceasedDateValue") {
            return this.deceasedDateValue;
        }
        if (string == "geographicOrigin") {
            return this.geographicOrigin;
        }
        if (string == "genderChangeCode") {
            return this.genderChangeCode;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "birthDateValue") {
            this.birthDateValue = (Date)object;
            return;
        }
        if (string == "entityId") {
            this.entityId = (String)object;
            return;
        }
        if (string == "birthCity") {
            this.birthCity = (String)object;
            return;
        }
        if (string == "noteMessage") {
            this.noteMessage = (String)object;
            return;
        }
        if (string == "secondaryLanguageCode") {
            this.secondaryLanguageCode = (String)object;
            return;
        }
        if (string == "maritalStatusCode") {
            this.maritalStatusCode = (String)object;
            return;
        }
        if (string == "genderCode") {
            this.genderCode = (String)object;
            return;
        }
        if (string == "birthStateProvinceCode") {
            this.birthStateProvinceCode = (String)object;
            return;
        }
        if (string == "primaryLanguageCode") {
            this.primaryLanguageCode = (String)object;
            return;
        }
        if (string == "birthCountry") {
            this.birthCountry = (String)object;
            return;
        }
        if (string == "deceasedDateValue") {
            this.deceasedDateValue = (Date)object;
            return;
        }
        if (string == "geographicOrigin") {
            this.geographicOrigin = (String)object;
            return;
        }
        if (string == "genderChangeCode") {
            this.genderChangeCode = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Date _persistence_get_birthDateValue() {
        this._persistence_checkFetched("birthDateValue");
        return this.birthDateValue;
    }

    public void _persistence_set_birthDateValue(Date date) {
        this._persistence_checkFetchedForSet("birthDateValue");
        this._persistence_propertyChange("birthDateValue", this.birthDateValue, date);
        this.birthDateValue = date;
    }

    public String _persistence_get_entityId() {
        this._persistence_checkFetched("entityId");
        return this.entityId;
    }

    public void _persistence_set_entityId(String string) {
        this._persistence_checkFetchedForSet("entityId");
        this._persistence_propertyChange("entityId", this.entityId, string);
        this.entityId = string;
    }

    public String _persistence_get_birthCity() {
        this._persistence_checkFetched("birthCity");
        return this.birthCity;
    }

    public void _persistence_set_birthCity(String string) {
        this._persistence_checkFetchedForSet("birthCity");
        this._persistence_propertyChange("birthCity", this.birthCity, string);
        this.birthCity = string;
    }

    public String _persistence_get_noteMessage() {
        this._persistence_checkFetched("noteMessage");
        return this.noteMessage;
    }

    public void _persistence_set_noteMessage(String string) {
        this._persistence_checkFetchedForSet("noteMessage");
        this._persistence_propertyChange("noteMessage", this.noteMessage, string);
        this.noteMessage = string;
    }

    public String _persistence_get_secondaryLanguageCode() {
        this._persistence_checkFetched("secondaryLanguageCode");
        return this.secondaryLanguageCode;
    }

    public void _persistence_set_secondaryLanguageCode(String string) {
        this._persistence_checkFetchedForSet("secondaryLanguageCode");
        this._persistence_propertyChange("secondaryLanguageCode", this.secondaryLanguageCode, string);
        this.secondaryLanguageCode = string;
    }

    public String _persistence_get_maritalStatusCode() {
        this._persistence_checkFetched("maritalStatusCode");
        return this.maritalStatusCode;
    }

    public void _persistence_set_maritalStatusCode(String string) {
        this._persistence_checkFetchedForSet("maritalStatusCode");
        this._persistence_propertyChange("maritalStatusCode", this.maritalStatusCode, string);
        this.maritalStatusCode = string;
    }

    public String _persistence_get_genderCode() {
        this._persistence_checkFetched("genderCode");
        return this.genderCode;
    }

    public void _persistence_set_genderCode(String string) {
        this._persistence_checkFetchedForSet("genderCode");
        this._persistence_propertyChange("genderCode", this.genderCode, string);
        this.genderCode = string;
    }

    public String _persistence_get_birthStateProvinceCode() {
        this._persistence_checkFetched("birthStateProvinceCode");
        return this.birthStateProvinceCode;
    }

    public void _persistence_set_birthStateProvinceCode(String string) {
        this._persistence_checkFetchedForSet("birthStateProvinceCode");
        this._persistence_propertyChange("birthStateProvinceCode", this.birthStateProvinceCode, string);
        this.birthStateProvinceCode = string;
    }

    public String _persistence_get_primaryLanguageCode() {
        this._persistence_checkFetched("primaryLanguageCode");
        return this.primaryLanguageCode;
    }

    public void _persistence_set_primaryLanguageCode(String string) {
        this._persistence_checkFetchedForSet("primaryLanguageCode");
        this._persistence_propertyChange("primaryLanguageCode", this.primaryLanguageCode, string);
        this.primaryLanguageCode = string;
    }

    public String _persistence_get_birthCountry() {
        this._persistence_checkFetched("birthCountry");
        return this.birthCountry;
    }

    public void _persistence_set_birthCountry(String string) {
        this._persistence_checkFetchedForSet("birthCountry");
        this._persistence_propertyChange("birthCountry", this.birthCountry, string);
        this.birthCountry = string;
    }

    public Date _persistence_get_deceasedDateValue() {
        this._persistence_checkFetched("deceasedDateValue");
        return this.deceasedDateValue;
    }

    public void _persistence_set_deceasedDateValue(Date date) {
        this._persistence_checkFetchedForSet("deceasedDateValue");
        this._persistence_propertyChange("deceasedDateValue", this.deceasedDateValue, date);
        this.deceasedDateValue = date;
    }

    public String _persistence_get_geographicOrigin() {
        this._persistence_checkFetched("geographicOrigin");
        return this.geographicOrigin;
    }

    public void _persistence_set_geographicOrigin(String string) {
        this._persistence_checkFetchedForSet("geographicOrigin");
        this._persistence_propertyChange("geographicOrigin", this.geographicOrigin, string);
        this.geographicOrigin = string;
    }

    public String _persistence_get_genderChangeCode() {
        this._persistence_checkFetched("genderChangeCode");
        return this.genderChangeCode;
    }

    public void _persistence_set_genderChangeCode(String string) {
        this._persistence_checkFetchedForSet("genderChangeCode");
        this._persistence_propertyChange("genderChangeCode", this.genderChangeCode, string);
        this.genderChangeCode = string;
    }
}

