/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.document;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.rules.MaintenanceDocumentRuleBase;

public class DocumentTypeMaintainableBusRule
extends MaintenanceDocumentRuleBase {
    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        boolean result = super.processCustomSaveDocumentBusinessRules(document);
        result &= this.checkDoctypeName(document);
        return result &= this.checkDoctypeLabel(document);
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        boolean result = super.processCustomRouteDocumentBusinessRules(document);
        result &= this.checkDoctypeName(document);
        return result &= this.checkDoctypeLabel(document);
    }

    public boolean checkDoctypeName(MaintenanceDocument document) {
        boolean result = true;
        DocumentType bo = (DocumentType)document.getNewMaintainableObject().getDataObject();
        if (null != bo.getName()) {
            DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findByName(bo.getName());
            if (null != documentType && document.isNew()) {
                result = false;
                this.putFieldError("name", "documenttype.name.duplicate");
            }
        } else {
            result = false;
        }
        return result;
    }

    public boolean checkDoctypeLabel(MaintenanceDocument document) {
        boolean isValid = true;
        DocumentType bo = (DocumentType)document.getNewMaintainableObject().getDataObject();
        isValid = !StringUtils.isBlank((String)bo.getLabel());
        return isValid;
    }
}

