/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.document;

import java.util.Collections;
import javax.jws.WebParam;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.document.DocumentProcessingOptions;
import org.kuali.rice.kew.api.document.DocumentProcessingQueue;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeIndexingQueue;
import org.kuali.rice.kew.engine.OrchestrationConfig;
import org.kuali.rice.kew.engine.WorkflowEngineFactory;
import org.kuali.rice.kew.impl.document.DocumentProcessingQueueAsyncCapableImpl;
import org.kuali.rice.ksb.api.messaging.AsyncCapableService;
import org.kuali.rice.ksb.api.messaging.AsyncWrappable;

public class DocumentProcessingQueueImpl
implements DocumentProcessingQueue,
AsyncWrappable<DocumentProcessingQueue> {
    private static final Logger LOG = LogManager.getLogger(DocumentProcessingQueueImpl.class);
    private WorkflowEngineFactory workflowEngineFactory;
    private DocumentAttributeIndexingQueue documentAttributeIndexingQueue;
    private AsyncCapableService asyncCapableService;

    public void process(@WebParam(name="documentId") String documentId) {
        this.processWithOptions(documentId, null);
    }

    public void processWithOptions(@WebParam(name="documentId") String documentId, @WebParam(name="options") DocumentProcessingOptions options) {
        if (StringUtils.isBlank((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId was a null or blank value");
        }
        if (options == null) {
            options = DocumentProcessingOptions.createDefault();
        }
        OrchestrationConfig config = new OrchestrationConfig(OrchestrationConfig.EngineCapability.STANDARD, Collections.emptySet(), null, options.isSendNotifications(), options.isRunPostProcessor());
        Object engine = this.getWorkflowEngineFactory().newEngine(config);
        try {
            engine.process(documentId);
        }
        catch (Exception e) {
            LOG.error("Failed to process document through the workflow engine", (Throwable)e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new WorkflowRuntimeException((Throwable)e);
        }
        if (options.isIndexSearchAttributes()) {
            this.getDocumentAttributeIndexingQueue().indexDocument(documentId);
        }
    }

    public WorkflowEngineFactory getWorkflowEngineFactory() {
        return this.workflowEngineFactory;
    }

    public void setWorkflowEngineFactory(WorkflowEngineFactory workflowEngineFactory) {
        this.workflowEngineFactory = workflowEngineFactory;
    }

    public DocumentAttributeIndexingQueue getDocumentAttributeIndexingQueue() {
        return this.documentAttributeIndexingQueue;
    }

    public void setDocumentAttributeIndexingQueue(DocumentAttributeIndexingQueue documentAttributeIndexingQueue) {
        this.documentAttributeIndexingQueue = documentAttributeIndexingQueue;
    }

    public DocumentProcessingQueue wrap(QName qname, String applicationId) {
        return new DocumentProcessingQueueAsyncCapableImpl(this.asyncCapableService, this, qname, applicationId);
    }

    public AsyncCapableService getAsyncCapableService() {
        return this.asyncCapableService;
    }

    public void setAsyncCapableService(AsyncCapableService asyncCapableService) {
        this.asyncCapableService = asyncCapableService;
    }
}

