/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.lookup;

import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimTypeInfoService;
import org.kuali.rice.kns.document.authorization.DocumentAuthorizer;
import org.kuali.rice.kns.document.authorization.DocumentPresentationController;
import org.kuali.rice.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.rice.kns.service.DocumentHelperService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.util.GlobalVariables;

public class KimLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    private static final long serialVersionUID = 1L;
    private static DocumentHelperService documentHelperService;
    private static KimTypeInfoService typeInfoService;

    public boolean allowsNewOrCopyAction(String documentTypeName) {
        DocumentAuthorizer documentAuthorizer = this.getDocumentHelperService().getDocumentAuthorizer(documentTypeName);
        DocumentPresentationController documentPresentationController = this.getDocumentHelperService().getDocumentPresentationController(documentTypeName);
        Person currentUser = GlobalVariables.getUserSession().getPerson();
        return documentPresentationController.canInitiate(documentTypeName) && documentAuthorizer.canInitiate(documentTypeName, currentUser);
    }

    protected DocumentHelperService getDocumentHelperService() {
        if (documentHelperService == null) {
            documentHelperService = KNSServiceLocator.getDocumentHelperService();
        }
        return documentHelperService;
    }

    protected KimTypeInfoService getTypeInfoService() {
        if (typeInfoService == null) {
            typeInfoService = KimApiServiceLocator.getKimTypeInfoService();
        }
        return typeInfoService;
    }
}

