/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.framework.util;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class ApplicationThreadLocal<T>
extends ThreadLocal<T> {
    private static final Collection<WeakReference<ApplicationThreadLocal>> threadLocals = Collections.synchronizedCollection(new ArrayList());

    public ApplicationThreadLocal() {
        threadLocals.add(new WeakReference<ApplicationThreadLocal>(this));
    }

    protected boolean remove(Thread t) {
        return ApplicationThreadLocal.removeThreadLocal(t, this);
    }

    public static boolean removeThreadLocal(Thread thread, ThreadLocal threadLocal) {
        try {
            Method getMap = ThreadLocal.class.getDeclaredMethod("getMap", Thread.class);
            getMap.setAccessible(true);
            Object map = getMap.invoke((Object)threadLocal, thread);
            if (map != null) {
                Method remove = map.getClass().getDeclaredMethod("remove", ThreadLocal.class);
                remove.setAccessible(true);
                remove.invoke(map, threadLocal);
            }
            return true;
        }
        catch (NoSuchMethodException nsme) {
            nsme.printStackTrace();
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean clear() {
        ArrayList<WeakReference<ApplicationThreadLocal>> toRemove;
        Collection<WeakReference<ApplicationThreadLocal>> collection = threadLocals;
        synchronized (collection) {
            toRemove = new ArrayList<WeakReference<ApplicationThreadLocal>>(threadLocals);
            threadLocals.clear();
        }
        boolean success = true;
        Set<Thread> allThreads = Thread.getAllStackTraces().keySet();
        for (WeakReference weakReference : toRemove) {
            ApplicationThreadLocal tl = (ApplicationThreadLocal)weakReference.get();
            if (tl == null) continue;
            for (Thread t : allThreads) {
                success &= tl.remove(t);
            }
        }
        return success;
    }
}

