/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import javax.sql.DataSource;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.metadata.MetadataException;

public class JdbcMetadataUtils {
    public static final String PROPERTY_PROTOCOL = "protocol";
    public static final String PROPERTY_SUBPROTOCOL = "subprotocol";
    public static final String PROPERTY_DBALIAS = "dbAlias";
    public static final String PLATFORM_DB2 = "Db2";
    public static final String PLATFORM_FIREBIRD = "Firebird";
    public static final String PLATFORM_HSQLDB = "Hsqldb";
    public static final String PLATFORM_INFORMIX = "Informix";
    public static final String PLATFORM_MAXDB = "MaxDB";
    public static final String PLATFORM_MCKOI = "McKoi";
    public static final String PLATFORM_MSACCESS = "MsAccess";
    public static final String PLATFORM_MSSQLSERVER = "MsSQLServer";
    public static final String PLATFORM_MYSQL = "MySQL";
    public static final String PLATFORM_ORACLE = "Oracle";
    public static final String PLATFORM_ORACLE9I = "Oracle9i";
    public static final String PLATFORM_POSTGRESQL = "PostgreSQL";
    public static final String PLATFORM_SYBASE = "Sybase";
    public static final String PLATFORM_SYBASEASA = "SybaseASA";
    public static final String PLATFORM_SYBASEASE = "SybaseASE";
    public static final String PLATFORM_WLORACLE9I = "WLOracle9i";
    public static final String DRIVER_DB2 = "COM.ibm.db2.jdbc.app.DB2Driver";
    public static final String DRIVER_DB2_INET = "com.inet.drda.DRDADriver";
    public static final String DRIVER_FIREBIRD = "org.firebirdsql.jdbc.FBDriver";
    public static final String DRIVER_HSQLDB = "org.hsqldb.jdbcDriver";
    public static final String DRIVER_INET_POOLED = "com.inet.pool.PoolDriver";
    public static final String DRIVER_INFORMIX = "com.informix.jdbc.IfxDriver";
    public static final String DRIVER_JTDS = "net.sourceforge.jtds.jdbc.Driver";
    public static final String DRIVER_MAXDB = "com.sap.dbtech.jdbc.DriverSapDB";
    public static final String DRIVER_MCKOI = "com.mckoi.JDBCDriver";
    public static final String DRIVER_MSSQLSERVER = "com.microsoft.jdbc.sqlserver.SQLServerDriver";
    public static final String DRIVER_MSSQLSERVER_INET = "com.inet.tds.TdsDriver";
    public static final String DRIVER_MSSQLSERVER_JSQLCONNECT = "com.jnetdirect.jsql.JSQLDriver";
    public static final String DRIVER_MYSQL = "com.mysql.jdbc.Driver";
    public static final String DRIVER_MYSQL_OLD = "org.gjt.mm.mysql.Driver";
    public static final String DRIVER_ORACLE = "oracle.jdbc.driver.OracleDriver";
    public static final String DRIVER_ORACLE_INET = "com.inet.ora.OraDriver";
    public static final String DRIVER_POSTGRESQL = "org.postgresql.Driver";
    public static final String DRIVER_SAPDB = "com.sap.dbtech.jdbc.DriverSapDB";
    public static final String DRIVER_SYBASE = "com.sybase.jdbc2.jdbc.SybDriver";
    public static final String DRIVER_SYBASE_OLD = "com.sybase.jdbc.SybDriver";
    public static final String DRIVER_SYBASE_INET = "com.inet.syb.SybDriver";
    public static final String SUBPROTOCOL_DB2 = "db2";
    public static final String SUBPROTOCOL_DB2_INET = "inetdb2";
    public static final String SUBPROTOCOL_FIREBIRD = "firebirdsql";
    public static final String SUBPROTOCOL_HSQLDB = "hsqldb";
    public static final String SUBPROTOCOL_INFORMIX = "informix-sqli";
    public static final String SUBPROTOCOL_MAXDB = "sapdb";
    public static final String SUBPROTOCOL_MCKOI = "mckoi";
    public static final String SUBPROTOCOL_MSSQLSERVER = "microsoft:sqlserver";
    public static final String SUBPROTOCOL_MSSQLSERVER_INET = "inetdae";
    public static final String SUBPROTOCOL_MSSQLSERVER6_INET = "inetdae6";
    public static final String SUBPROTOCOL_MSSQLSERVER7_INET = "inetdae7";
    public static final String SUBPROTOCOL_MSSQLSERVER7A_INET = "inetdae7a";
    public static final String SUBPROTOCOL_MSSQLSERVER_INET_POOLED = "inetpool:inetdae";
    public static final String SUBPROTOCOL_MSSQLSERVER6_INET_POOLED = "inetpool:inetdae6";
    public static final String SUBPROTOCOL_MSSQLSERVER7_INET_POOLED = "inetpool:inetdae7";
    public static final String SUBPROTOCOL_MSSQLSERVER7A_INET_POOLED = "inetpool:inetdae7a";
    public static final String SUBPROTOCOL_MSSQLSERVER_JSQLCONNECT = "JSQLConnect";
    public static final String SUBPROTOCOL_MSSQLSERVER_JTDS = "jtds:sqlserver";
    public static final String SUBPROTOCOL_MYSQL = "mysql";
    public static final String SUBPROTOCOL_ORACLE = "oracle";
    public static final String SUBPROTOCOL_ORACLE_INET = "inetora";
    public static final String SUBPROTOCOL_POSTGRESQL = "postgresql";
    public static final String SUBPROTOCOL_SAPDB = "sapdb";
    public static final String SUBPROTOCOL_SYBASE = "sybase:Tds";
    public static final String SUBPROTOCOL_SYBASE_INET = "inetsyb";
    public static final String SUBPROTOCOL_SYBASE_INET_POOLED = "inetpool:inetsyb";
    public static final String SUBPROTOCOL_SYBASE_JTDS = "jtds:sybase";
    private HashMap jdbcSubProtocolToPlatform = new HashMap();
    private HashMap jdbcDriverToPlatform = new HashMap();

    public JdbcMetadataUtils() {
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_DB2, PLATFORM_DB2);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_DB2_INET, PLATFORM_DB2);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_FIREBIRD, PLATFORM_FIREBIRD);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_HSQLDB, PLATFORM_HSQLDB);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_INFORMIX, PLATFORM_INFORMIX);
        this.jdbcSubProtocolToPlatform.put("sapdb", PLATFORM_MAXDB);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_MSSQLSERVER, PLATFORM_MSSQLSERVER);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_MSSQLSERVER_INET, PLATFORM_MSSQLSERVER);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_MSSQLSERVER6_INET, PLATFORM_MSSQLSERVER);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_MSSQLSERVER7_INET, PLATFORM_MSSQLSERVER);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_MSSQLSERVER7A_INET, PLATFORM_MSSQLSERVER);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_MSSQLSERVER_INET_POOLED, PLATFORM_MSSQLSERVER);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_MSSQLSERVER6_INET_POOLED, PLATFORM_MSSQLSERVER);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_MSSQLSERVER7_INET_POOLED, PLATFORM_MSSQLSERVER);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_MSSQLSERVER7A_INET_POOLED, PLATFORM_MSSQLSERVER);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_MSSQLSERVER_JTDS, PLATFORM_MSSQLSERVER);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_MYSQL, PLATFORM_MYSQL);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_ORACLE, PLATFORM_ORACLE);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_ORACLE_INET, PLATFORM_ORACLE);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_POSTGRESQL, PLATFORM_POSTGRESQL);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_SYBASE, PLATFORM_SYBASE);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_SYBASE_INET, PLATFORM_SYBASE);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_SYBASE_INET_POOLED, PLATFORM_SYBASE);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_SYBASE_JTDS, PLATFORM_SYBASE);
        this.jdbcDriverToPlatform.put(DRIVER_DB2, PLATFORM_DB2);
        this.jdbcDriverToPlatform.put(DRIVER_DB2_INET, PLATFORM_DB2);
        this.jdbcDriverToPlatform.put(DRIVER_FIREBIRD, PLATFORM_FIREBIRD);
        this.jdbcDriverToPlatform.put(DRIVER_HSQLDB, PLATFORM_HSQLDB);
        this.jdbcDriverToPlatform.put(DRIVER_INFORMIX, PLATFORM_INFORMIX);
        this.jdbcDriverToPlatform.put("com.sap.dbtech.jdbc.DriverSapDB", PLATFORM_MAXDB);
        this.jdbcDriverToPlatform.put(DRIVER_MCKOI, PLATFORM_MCKOI);
        this.jdbcDriverToPlatform.put(DRIVER_MSSQLSERVER, PLATFORM_MSSQLSERVER);
        this.jdbcDriverToPlatform.put(DRIVER_MSSQLSERVER_INET, PLATFORM_MSSQLSERVER);
        this.jdbcDriverToPlatform.put(DRIVER_MSSQLSERVER_JSQLCONNECT, PLATFORM_MSSQLSERVER);
        this.jdbcDriverToPlatform.put(DRIVER_MYSQL, PLATFORM_MYSQL);
        this.jdbcDriverToPlatform.put(DRIVER_MYSQL_OLD, PLATFORM_MYSQL);
        this.jdbcDriverToPlatform.put(DRIVER_ORACLE, PLATFORM_ORACLE);
        this.jdbcDriverToPlatform.put(DRIVER_ORACLE_INET, PLATFORM_ORACLE);
        this.jdbcDriverToPlatform.put(DRIVER_POSTGRESQL, PLATFORM_POSTGRESQL);
        this.jdbcDriverToPlatform.put(DRIVER_SYBASE, PLATFORM_SYBASE);
        this.jdbcDriverToPlatform.put(DRIVER_SYBASE_OLD, PLATFORM_SYBASE);
        this.jdbcDriverToPlatform.put(DRIVER_SYBASE_INET, PLATFORM_SYBASE);
    }

    public void fillJCDFromDataSource(JdbcConnectionDescriptor jdbcConnectionDescriptor, DataSource dataSource, String string, String string2) throws MetadataException {
        Serializable serializable;
        String string3 = jdbcConnectionDescriptor.getUserName() != null ? jdbcConnectionDescriptor.getUserName() : string;
        String string4 = jdbcConnectionDescriptor.getPassWord() != null ? jdbcConnectionDescriptor.getPassWord() : string2;
        Connection connection = null;
        DatabaseMetaData databaseMetaData = null;
        try {
            connection = string3 != null ? dataSource.getConnection(string3, string4) : dataSource.getConnection();
            databaseMetaData = connection.getMetaData();
        }
        catch (Throwable throwable) {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            throw new MetadataException("Could not get the metadata from the given datasource", throwable);
        }
        try {
            serializable = this.parseConnectionUrl(databaseMetaData.getURL());
            if (((HashMap)serializable).containsKey(PROPERTY_DBALIAS)) {
                jdbcConnectionDescriptor.setProtocol((String)((HashMap)serializable).get(PROPERTY_PROTOCOL));
                jdbcConnectionDescriptor.setSubProtocol((String)((HashMap)serializable).get(PROPERTY_SUBPROTOCOL));
                jdbcConnectionDescriptor.setDbAlias((String)((HashMap)serializable).get(PROPERTY_DBALIAS));
                if (this.jdbcSubProtocolToPlatform.containsKey(jdbcConnectionDescriptor.getSubProtocol())) {
                    jdbcConnectionDescriptor.setDbms((String)this.jdbcSubProtocolToPlatform.get(jdbcConnectionDescriptor.getSubProtocol()));
                }
            }
        }
        catch (Throwable throwable) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw new MetadataException("Could not get the metadata from the given datasource", throwable);
        }
        try {
            serializable = (Integer)PropertyUtils.getProperty((Object)databaseMetaData, (String)"JDBCMajorVersion");
            Integer n = (Integer)PropertyUtils.getProperty((Object)databaseMetaData, (String)"JDBCMinorVersion");
            jdbcConnectionDescriptor.setJdbcLevel(Double.parseDouble(((Integer)serializable).toString() + "." + n.toString()));
        }
        catch (Throwable throwable) {
            jdbcConnectionDescriptor.setJdbcLevel(2.0);
        }
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public HashMap parseConnectionUrl(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string == null) {
            return hashMap;
        }
        int n = string.indexOf(58);
        hashMap.put(PROPERTY_PROTOCOL, string.substring(0, n));
        int n2 = n;
        n = string.indexOf(58, n2 + 1);
        String string2 = string.substring(n2 + 1, n);
        if ("inetpool".equals(string2)) {
            int n3 = string.indexOf(58, n + 1);
            if ("inetpool:jdbc".equals(string.substring(n2 + 1, n3))) {
                n = n3;
                n3 = string.indexOf(58, n + 1);
            }
            string2 = string2 + ":" + string.substring(n + 1, n3);
        } else if ("jtds".equals(string2) || "microsoft".equals(string2) || "sybase".equals(string2)) {
            n = string.indexOf(58, n + 1);
            string2 = ":" + string.substring(n2 + 1, n);
        }
        hashMap.put(PROPERTY_SUBPROTOCOL, string2);
        hashMap.put(PROPERTY_DBALIAS, string.substring(n + 1));
        return hashMap;
    }

    public String findPlatformFor(String string, String string2) {
        String string3 = (String)this.jdbcSubProtocolToPlatform.get(string);
        if (string3 == null) {
            string3 = (String)this.jdbcDriverToPlatform.get(string2);
        }
        return string3;
    }
}

