--
-- Kuali Coeus, a comprehensive research administration system for higher education.
--
-- Copyright 2005-2020 Kuali, Inc.
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.
--
-- You should have received a copy of the GNU Affero General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--

INSERT INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES (SEQ_VALID_NARR_FORMS_ID.NEXTVAL, 'PHSHumanSubjectsAndClinicalTrialsInfo_2_0-V2.0', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'PHS_HumanSubjectsAndCT_InvolveHumanSpecExp'), 'N', 'admin', sysdate, sys_guid());

INSERT INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES (SEQ_VALID_NARR_FORMS_ID.NEXTVAL, 'PHSHumanSubjectsAndClinicalTrialsInfo_2_0-V2.0', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'PHS_HumanSubjectsAndCT_OtherRequestedInfo'), 'N', 'admin', sysdate, sys_guid());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/PHSHumanSubjectsAndClinicalTrialsInfo_2_0/Explanation', 'Human Subjects Explanation attachment is required for the Human Subjects Clinical Trials form when human specimens and/or data are involved.', 'abstractsAttachments', sysdate, 'admin', 1, sys_guid());

UPDATE KRMS_TERM_PARM_T SET VAL = 'PHS_HumanSubjectsAndClinicalTrialsInfo_V1.0,PHSHumanSubjectsAndClinicalTrialsInfo_2_0-V2.0'
WHERE TERM_ID = 'RES-BOOT10020' AND VAL = 'PHS_HumanSubjectsAndClinicalTrialsInfo_V1.0';
