/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.api.core;

public class S2SException
extends RuntimeException {
    public static final String ERROR_S2S_UNKNOWN = "error.s2s.unknown";
    private String errorMessage = "";
    private String errorKey = "error.s2s.unknown";
    private int messageType;
    private String[] params = new String[0];
    private String tabErrorKey;

    public S2SException() {
    }

    public S2SException(Exception ex) {
        super(ex);
        this.errorMessage = ex.getMessage();
    }

    public S2SException(String message, Exception ex) {
        super(message, ex);
        this.errorMessage = message;
    }

    public S2SException(String msg) {
        super(msg);
        this.errorMessage = msg;
    }

    public S2SException(String errorKey, String msg) {
        super(msg);
        this.errorMessage = msg;
        this.errorKey = errorKey;
    }

    public S2SException(String errorKey, String msg, String ... params) {
        super(msg);
        this.errorMessage = msg;
        this.errorKey = errorKey;
        this.params = params;
    }

    public S2SException(String msg, int messageType) {
        super(msg);
        this.errorMessage = msg;
        this.messageType = messageType;
    }

    @Override
    public String getMessage() {
        return this.errorMessage;
    }

    public String[] getMessageWithParams() {
        String[] messageWithParams = new String[this.getParams().length + 1];
        messageWithParams[0] = this.errorMessage;
        System.arraycopy(this.params, 0, messageWithParams, 1, messageWithParams.length - 1);
        return messageWithParams;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorKey() {
        return this.errorKey;
    }

    public void setErrorKey(String errorKey) {
        this.errorKey = errorKey;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public void setMessageType(int messageType) {
        this.messageType = messageType;
    }

    public String[] getParams() {
        return this.params;
    }

    public void setParams(String[] params) {
        this.params = params;
    }

    public String getTabErrorKey() {
        return this.tabErrorKey;
    }

    public void setTabErrorKey(String tabErrorKey) {
        this.tabErrorKey = tabErrorKey;
    }
}

