/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.web.impex;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.impex.ExportDataSet;
import org.kuali.rice.core.api.impex.xml.XmlExporterService;

public class ExportServlet
extends HttpServlet {
    private static final long serialVersionUID = -7766819916650887737L;
    public static final String EXPORT_DATA_SET_KEY = "ExportDataSet";

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ExportDataSet dataSet = (ExportDataSet)request.getSession().getAttribute(EXPORT_DATA_SET_KEY);
        request.getSession().removeAttribute(EXPORT_DATA_SET_KEY);
        if (dataSet == null) {
            throw new ServletException("No data set was specified.");
        }
        String contentType = "application/xml";
        XmlExporterService exporter = CoreApiServiceLocator.getXmlExporterService();
        byte[] data = exporter.export(dataSet);
        response.setContentType(contentType);
        response.setContentLength(data.length);
        response.setHeader("Content-disposition", "attachment; filename=" + this.extractFileName(request));
        response.getOutputStream().write(data);
        response.getOutputStream().close();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    private String extractFileName(HttpServletRequest request) {
        String path = request.getPathInfo();
        int index = path.lastIndexOf(47);
        if (index >= 0) {
            path = path.substring(index + 1);
        }
        return path;
    }

    public static final String generateExportPath(HttpServletRequest request, ExportDataSet dataSet) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'hh_mm_ss");
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
        return basePath + "/export/wf-export-" + format.format(new Date()) + ".xml";
    }
}

