/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.web.listener;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.impl.config.property.JAXBConfigImpl;
import org.kuali.rice.core.web.util.PropertySources;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.PropertySource;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class KualiInitializeListener
implements ServletContextListener {
    private static final Logger LOG = LogManager.getLogger(KualiInitializeListener.class);
    private static final String DEFAULT_SPRING_BEANS_REPLACEMENT_VALUE = "${bootstrap.spring.file}";
    private static final String WEB_BOOTSTRAP_SPRING_FILE = "web.bootstrap.spring.file";
    private XmlWebApplicationContext context;

    public void contextInitialized(ServletContextEvent sce) {
        String bootstrapSpringInitParam;
        long startInit = System.currentTimeMillis();
        LOG.info("Initializing Kuali Rice Application...");
        System.setProperty("org.terracotta.quartz.skipUpdateCheck", "true");
        ArrayList<String> configLocations = new ArrayList<String>();
        String additionalConfigLocations = System.getProperty("additional.config.locations");
        if (!StringUtils.isBlank((String)additionalConfigLocations)) {
            String[] additionalConfigLocationArray;
            for (String additionalConfigLocation : additionalConfigLocationArray = additionalConfigLocations.split(",")) {
                configLocations.add(additionalConfigLocation);
            }
        }
        String bootstrapSpringBeans = "";
        if (!StringUtils.isBlank((String)System.getProperty(WEB_BOOTSTRAP_SPRING_FILE))) {
            bootstrapSpringBeans = System.getProperty(WEB_BOOTSTRAP_SPRING_FILE);
        } else if (!StringUtils.isBlank((String)sce.getServletContext().getInitParameter(WEB_BOOTSTRAP_SPRING_FILE)) && !DEFAULT_SPRING_BEANS_REPLACEMENT_VALUE.equals(bootstrapSpringInitParam = sce.getServletContext().getInitParameter(WEB_BOOTSTRAP_SPRING_FILE))) {
            bootstrapSpringBeans = bootstrapSpringInitParam;
            LOG.info("Found bootstrap Spring Beans file defined in servlet context: " + bootstrapSpringBeans);
        }
        Properties baseProps = new Properties();
        baseProps.putAll((Map<?, ?>)this.getContextParameters(sce.getServletContext()));
        baseProps.putAll((Map<?, ?>)System.getProperties());
        JAXBConfigImpl config = new JAXBConfigImpl(baseProps);
        ConfigContext.init((Config)config);
        this.context = new XmlWebApplicationContext();
        if (!StringUtils.isEmpty((String)bootstrapSpringBeans)) {
            this.context.setConfigLocation(bootstrapSpringBeans);
        }
        this.context.setServletContext(sce.getServletContext());
        Optional<PropertySource<?>> ps = PropertySources.getPropertySource(sce, "web.bootstrap.spring.psc");
        if (ps.isPresent()) {
            PropertySources.addFirst((ConfigurableApplicationContext)this.context, (PropertySource)ps.get());
        }
        try {
            this.context.refresh();
        }
        catch (RuntimeException e) {
            LOG.error("problem during context.refresh()", (Throwable)e);
            throw e;
        }
        this.context.start();
        long endInit = System.currentTimeMillis();
        LOG.info("...Kuali Rice Application successfully initialized, startup took " + (endInit - startInit) + " ms.");
    }

    protected Properties getContextParameters(ServletContext context) {
        Properties properties = new Properties();
        Enumeration paramNames = context.getInitParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            properties.put(paramName, context.getInitParameter(paramName));
        }
        return properties;
    }

    public void contextDestroyed(ServletContextEvent sce) {
        LOG.info("Shutting down Kuali Rice...");
        if (this.context != null) {
            this.context.close();
        }
        LOG.info("...completed shutdown of Kuali Rice.");
        LogManager.shutdown();
    }

    public XmlWebApplicationContext getContext() {
        return this.context;
    }
}

