/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.api.bus.support;

import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.security.credentials.CredentialsType;
import org.kuali.rice.core.api.util.jaxb.EnumStringAdapter;
import org.kuali.rice.core.api.util.jaxb.QNameAsStringAdapter;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.api.bus.ServiceDefinition;
import org.w3c.dom.Element;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="ServiceConfigurationType", propOrder={"serviceName", "endpointUrl", "applicationId", "instanceId", "serviceVersion", "type", "queue", "priority", "retryAttempts", "millisToLive", "messageExceptionHandler", "busSecurity", "credentialsType", "basicAuthentication", "_futureElements"})
public abstract class AbstractServiceConfiguration
extends AbstractDataTransferObject
implements ServiceConfiguration {
    private static final long serialVersionUID = 2681595879406587302L;
    @XmlJavaTypeAdapter(value=QNameAsStringAdapter.class)
    @XmlElement(name="serviceName", required=true)
    private final QName serviceName;
    @XmlElement(name="endpointUrl", required=true)
    private final URL endpointUrl;
    @XmlElement(name="instanceId", required=true)
    private final String instanceId;
    @XmlElement(name="applicationId", required=true)
    private final String applicationId;
    @XmlElement(name="serviceVersion", required=true)
    private final String serviceVersion;
    @XmlElement(name="type", required=true)
    private final String type;
    @XmlElement(name="queue", required=false)
    private final boolean queue;
    @XmlElement(name="priority", required=false)
    private final Integer priority;
    @XmlElement(name="retryAttempts", required=false)
    private final Integer retryAttempts;
    @XmlElement(name="millisToLive", required=false)
    private final Long millisToLive;
    @XmlElement(name="messageExceptionHandler", required=false)
    private final String messageExceptionHandler;
    @XmlElement(name="busSecurity", required=false)
    private final Boolean busSecurity;
    @XmlJavaTypeAdapter(value=CredentialsTypeAdapter.class)
    @XmlElement(name="credentialsType", required=false)
    private final String credentialsType;
    @XmlElement(name="basicAuthentication", required=false)
    private final Boolean basicAuthentication;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    protected AbstractServiceConfiguration() {
        this.serviceName = null;
        this.endpointUrl = null;
        this.instanceId = null;
        this.applicationId = null;
        this.serviceVersion = null;
        this.type = null;
        this.queue = false;
        this.priority = null;
        this.retryAttempts = null;
        this.millisToLive = null;
        this.messageExceptionHandler = null;
        this.busSecurity = null;
        this.credentialsType = null;
        this.basicAuthentication = false;
    }

    protected AbstractServiceConfiguration(Builder<?> builder) {
        this.serviceName = builder.getServiceName();
        this.endpointUrl = builder.getEndpointUrl();
        this.instanceId = builder.getInstanceId();
        this.applicationId = builder.getApplicationId();
        this.serviceVersion = builder.getServiceVersion();
        this.type = builder.getType();
        this.queue = builder.isQueue();
        this.priority = builder.getPriority();
        this.retryAttempts = builder.getRetryAttempts();
        this.millisToLive = builder.getMillisToLive();
        this.messageExceptionHandler = builder.getMessageExceptionHandler();
        this.busSecurity = builder.getBusSecurity();
        CredentialsType cred = builder.getCredentialsType();
        this.credentialsType = cred == null ? null : cred.name();
        this.basicAuthentication = builder.isBasicAuthentication();
    }

    @Override
    public QName getServiceName() {
        return this.serviceName;
    }

    @Override
    public URL getEndpointUrl() {
        return this.endpointUrl;
    }

    @Override
    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    public String getServiceVersion() {
        return this.serviceVersion;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public boolean isQueue() {
        return this.queue;
    }

    @Override
    public Integer getPriority() {
        return this.priority;
    }

    @Override
    public Integer getRetryAttempts() {
        return this.retryAttempts;
    }

    @Override
    public Long getMillisToLive() {
        return this.millisToLive;
    }

    @Override
    public String getMessageExceptionHandler() {
        return this.messageExceptionHandler;
    }

    @Override
    public Boolean getBusSecurity() {
        return this.busSecurity;
    }

    @Override
    public CredentialsType getCredentialsType() {
        if (this.credentialsType == null) {
            return null;
        }
        return CredentialsType.valueOf((String)this.credentialsType);
    }

    @Override
    public Boolean isBasicAuthentication() {
        return this.basicAuthentication;
    }

    static final class CredentialsTypeAdapter
    extends EnumStringAdapter<CredentialsType> {
        CredentialsTypeAdapter() {
        }

        protected Class<CredentialsType> getEnumClass() {
            return CredentialsType.class;
        }
    }

    protected static class Elements {
        protected static final String SERVICE_NAME = "serviceName";
        protected static final String ENDPOINT_URL = "endpointUrl";
        protected static final String INSTANCE_ID = "instanceId";
        protected static final String APPLICATION_ID = "applicationId";
        protected static final String SERVICE_VERSION = "serviceVersion";
        protected static final String TYPE = "type";
        protected static final String QUEUE = "queue";
        protected static final String PRIORITY = "priority";
        protected static final String RETRY_ATTEMPTS = "retryAttempts";
        protected static final String MILLIS_TO_LIVE = "millisToLive";
        protected static final String MESSAGE_EXCEPTION_HANDLER = "messageExceptionHandler";
        protected static final String BUS_SECURITY = "busSecurity";
        protected static final String CREDENTIALS_TYPE = "credentialsType";
        protected static final String BASIC_AUTHENTICATION = "basicAuthentication";

        protected Elements() {
        }
    }

    protected static class Constants {
        protected static final String TYPE_NAME = "ServiceConfigurationType";

        protected Constants() {
        }
    }

    protected static abstract class Builder<T>
    implements Serializable {
        private static final long serialVersionUID = -3002495884401672488L;
        private QName serviceName;
        private URL endpointUrl;
        private String instanceId;
        private String applicationId;
        private String serviceVersion;
        private String type;
        private boolean queue;
        private Integer priority;
        private Integer retryAttempts;
        private Long millisToLive;
        private String messageExceptionHandler;
        private Boolean busSecurity;
        private CredentialsType credentialsType;
        private Boolean basicAuthentication = false;

        protected Builder() {
        }

        public abstract T build();

        protected void copyServiceDefinitionProperties(ServiceDefinition serviceDefinition) {
            this.setServiceName(serviceDefinition.getServiceName());
            this.setEndpointUrl(serviceDefinition.getEndpointUrl());
            this.setApplicationId(serviceDefinition.getApplicationId());
            this.setInstanceId(serviceDefinition.getInstanceId());
            this.setServiceVersion(serviceDefinition.getServiceVersion());
            this.setType(serviceDefinition.getType());
            this.setQueue(serviceDefinition.isQueue());
            this.setPriority(serviceDefinition.getPriority());
            this.setRetryAttempts(serviceDefinition.getRetryAttempts());
            this.setMillisToLive(serviceDefinition.getMillisToLive());
            this.setMessageExceptionHandler(serviceDefinition.getMessageExceptionHandler());
            this.setBusSecurity(serviceDefinition.getBusSecurity());
            this.setCredentialsType(serviceDefinition.getCredentialsType());
            this.setBasicAuthentication(serviceDefinition.isBasicAuthentication());
        }

        public QName getServiceName() {
            return this.serviceName;
        }

        public void setServiceName(QName serviceName) {
            this.serviceName = serviceName;
        }

        public URL getEndpointUrl() {
            return this.endpointUrl;
        }

        public void setEndpointUrl(URL endpointUrl) {
            this.endpointUrl = endpointUrl;
        }

        public String getInstanceId() {
            return this.instanceId;
        }

        public void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public String getApplicationId() {
            return this.applicationId;
        }

        public void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public String getServiceVersion() {
            return this.serviceVersion;
        }

        public void setServiceVersion(String serviceVersion) {
            this.serviceVersion = serviceVersion;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public boolean isQueue() {
            return this.queue;
        }

        public void setQueue(boolean queue) {
            this.queue = queue;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public void setPriority(Integer priority) {
            this.priority = priority;
        }

        public Integer getRetryAttempts() {
            return this.retryAttempts;
        }

        public void setRetryAttempts(Integer retryAttempts) {
            this.retryAttempts = retryAttempts;
        }

        public Long getMillisToLive() {
            return this.millisToLive;
        }

        public void setMillisToLive(Long millisToLive) {
            this.millisToLive = millisToLive;
        }

        public String getMessageExceptionHandler() {
            return this.messageExceptionHandler;
        }

        public void setMessageExceptionHandler(String messageExceptionHandler) {
            this.messageExceptionHandler = messageExceptionHandler;
        }

        public Boolean getBusSecurity() {
            return this.busSecurity;
        }

        public void setBusSecurity(Boolean busSecurity) {
            this.busSecurity = busSecurity;
        }

        public CredentialsType getCredentialsType() {
            return this.credentialsType;
        }

        public void setCredentialsType(CredentialsType credentialsType) {
            this.credentialsType = credentialsType;
        }

        public Boolean isBasicAuthentication() {
            return this.basicAuthentication;
        }

        public void setBasicAuthentication(Boolean basicAuthentication) {
            this.basicAuthentication = basicAuthentication;
        }
    }
}

