/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.api.bus.support;

import java.util.ArrayList;
import java.util.List;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.api.bus.support.AbstractServiceDefinition;
import org.kuali.rice.ksb.api.bus.support.JavaServiceConfiguration;

public class JavaServiceDefinition
extends AbstractServiceDefinition {
    private List<String> serviceInterfaces = new ArrayList<String>();

    @Override
    public String getType() {
        return "httpInvoker";
    }

    public List<String> getServiceInterfaces() {
        return this.serviceInterfaces;
    }

    public void setServiceInterfaces(List<String> serviceInterfaces) {
        this.serviceInterfaces = serviceInterfaces;
    }

    public void setServiceInterface(String serviceName) {
        this.serviceInterfaces.add(serviceName);
    }

    public String getServiceInterface() {
        return this.serviceInterfaces.get(0);
    }

    @Override
    public void validate() {
        super.validate();
        if (this.serviceInterfaces == null || this.serviceInterfaces.isEmpty()) {
            Class[] interfaces;
            for (Class serviceInterfaceClass : interfaces = ClassLoaderUtils.getInterfacesToProxy((Object)this.getService(), null, null)) {
                this.serviceInterfaces.add(serviceInterfaceClass.getName());
            }
        }
    }

    @Override
    protected ServiceConfiguration configure() {
        return JavaServiceConfiguration.fromServiceDefinition(this);
    }

    protected static class Elements {
        protected static final String SERVICE_INTERFACES = "serviceInterfaces";
        protected static final String SERVICE_INTERFACE = "serviceInterface";

        protected Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "javaServiceDefinition";
        static final String TYPE_NAME = "JavaServiceDefinitionType";

        Constants() {
        }
    }
}

