/*
 * Decompiled with CFR 0.152.
 */
package com.codiform.moo.translator;

import com.codiform.moo.MatcherInitializationException;
import com.codiform.moo.TranslationException;
import com.codiform.moo.UnsupportedTranslationException;
import com.codiform.moo.configuration.Configuration;
import com.codiform.moo.property.CollectionProperty;
import com.codiform.moo.property.source.NoOpSourceProperty;
import com.codiform.moo.property.source.SourceProperty;
import com.codiform.moo.property.source.SourcePropertyFactory;
import com.codiform.moo.session.TranslationSource;
import com.codiform.moo.translator.CollectionMatcher;
import com.codiform.moo.translator.DefaultCollectionTargetFactory;
import com.codiform.moo.translator.TranslationTargetFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionTranslator {
    private Configuration configuration;
    private Logger log;
    private SourcePropertyFactory sourcePropertyFactory;

    public CollectionTranslator(Configuration configuration, SourcePropertyFactory sourcePropertyFactory) {
        this.configuration = configuration;
        this.sourcePropertyFactory = sourcePropertyFactory;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    public Object translate(Object value, CollectionProperty property, TranslationSource cache) {
        if (property.shouldItemsBeTranslated()) {
            Object target = this.createTargetCollection(value, property, cache);
            this.translateToTargetCollection(value, target, property, cache);
            return target;
        }
        if (this.shouldCopy(value, property)) {
            Object target = this.createTargetCollection(value, property, cache);
            this.copyToTargetCollection(value, target, property);
            return target;
        }
        return value;
    }

    private boolean shouldCopy(Object value, CollectionProperty property) {
        if (!this.hasDefaultFactory(property)) {
            return true;
        }
        if (this.configuration.isPerformingDefensiveCopies()) {
            return true;
        }
        if (property.getItemSource() != null) {
            return true;
        }
        Class<?> targetClass = property.getType();
        return !targetClass.isInstance(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyToTargetCollection(Object value, Object target, CollectionProperty property) {
        if (!(value instanceof Collection)) throw new TranslationException("Cannot translate collection from type: " + value.getClass().getName());
        if (!(target instanceof Collection)) throw new TranslationException("Cannot translate collection to target of type: " + target.getClass().getName());
        Collection targetCollection = (Collection)target;
        Iterator sourceItems = ((Collection)value).iterator();
        SourceProperty itemSource = this.getItemSource(property.getItemSource());
        while (sourceItems.hasNext()) {
            Object item = itemSource.getValue(sourceItems.next());
            targetCollection.add(item);
        }
    }

    private boolean hasDefaultFactory(CollectionProperty property) {
        return property.getFactory() == DefaultCollectionTargetFactory.class;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void translateToTargetCollection(Object value, Object target, CollectionProperty property, TranslationSource cache) {
        if (!(value instanceof Collection)) throw new TranslationException("Cannot translate from collection of type: " + target.getClass().getName());
        if (!(target instanceof Collection)) throw new TranslationException("Cannot translate collection to target of type: " + target.getClass().getName());
        Collection targetCollection = (Collection)target;
        Iterator sourceItems = ((Collection)value).iterator();
        SourceProperty itemSource = this.getItemSource(property.getItemSource());
        while (sourceItems.hasNext()) {
            Object item = itemSource.getValue(sourceItems.next());
            Object translated = cache.getTranslation(item, property.getItemFactory(), property.getItemClass());
            targetCollection.add(translated);
        }
    }

    private SourceProperty getItemSource(String itemExpression) {
        if (itemExpression == null) {
            return new NoOpSourceProperty();
        }
        return this.sourcePropertyFactory.getSourceProperty(itemExpression);
    }

    private Object createTargetCollection(Object value, CollectionProperty property, TranslationSource cache) {
        Class<? extends TranslationTargetFactory> factoryType = property.getFactory();
        TranslationTargetFactory factory = cache.getTranslationTargetFactory(factoryType);
        Object targetCollection = factory.getTranslationTargetInstance(value, property.getType());
        this.log.trace("Target factory type {} created target collection of type {} for source {}", new Object[]{factoryType, targetCollection.getClass(), value});
        return targetCollection;
    }

    public void updateCollection(Object source, Collection<Object> destinationCollection, TranslationSource translationSource, CollectionProperty property) {
        if (source instanceof Collection) {
            Collection sourceCollection = (Collection)source;
            if (property.hasMatcher()) {
                this.updateCollectionWithMatcher(sourceCollection, destinationCollection, translationSource, property);
            } else {
                this.updateCollectionInOrder(sourceCollection, destinationCollection, translationSource, property);
            }
        } else {
            throw new UnsupportedTranslationException("Cannot update Collection from " + source.getClass().getName());
        }
    }

    private void updateCollectionWithMatcher(Collection<Object> sourceCollection, Collection<Object> destinationCollection, TranslationSource translationSource, CollectionProperty property) {
        Class<CollectionMatcher<Object, Object>> matcherClass = property.getMatcherType();
        try {
            ArrayList<Object> unmatched = new ArrayList<Object>(destinationCollection);
            CollectionMatcher<Object, Object> matcher = matcherClass.newInstance();
            matcher.setTargets(destinationCollection);
            for (Object source : sourceCollection) {
                Object destination = matcher.getTarget(source);
                if (destination == null) {
                    if (property.shouldItemsBeTranslated()) {
                        destinationCollection.add(translationSource.getTranslation(source, property.getItemClass()));
                        continue;
                    }
                    destinationCollection.add(source);
                    continue;
                }
                unmatched.remove(destination);
                translationSource.update(source, destination);
            }
            if (property.shouldRemoveOrphans()) {
                for (Object item : unmatched) {
                    destinationCollection.remove(item);
                }
            }
        }
        catch (InstantiationException exception) {
            throw new MatcherInitializationException(matcherClass, exception);
        }
        catch (IllegalAccessException exception) {
            throw new MatcherInitializationException(matcherClass, exception);
        }
    }

    private void updateCollectionInOrder(Collection<Object> sourceCollection, Collection<Object> destinationCollection, TranslationSource translationSource, CollectionProperty property) {
        block5: {
            Iterator<Object> destination;
            Iterator<Object> source;
            block4: {
                source = sourceCollection.iterator();
                destination = destinationCollection.iterator();
                while (source.hasNext() && destination.hasNext()) {
                    translationSource.update(source.next(), destination.next());
                }
                if (!source.hasNext() || destination.hasNext()) break block4;
                while (source.hasNext()) {
                    if (property.shouldItemsBeTranslated()) {
                        Object translation = translationSource.getTranslation(source.next(), property.getItemClass());
                        destinationCollection.add(translation);
                        continue;
                    }
                    destinationCollection.add(source.next());
                }
                break block5;
            }
            if (!destination.hasNext() || source.hasNext() || !property.shouldRemoveOrphans()) break block5;
            while (destination.hasNext()) {
                destination.next();
                destination.remove();
            }
        }
    }
}

