/*
 * Decompiled with CFR 0.152.
 */
package com.codiform.moo.translator;

import com.codiform.moo.TranslationException;
import com.codiform.moo.TranslationInitializationException;
import com.codiform.moo.translator.TranslationTargetFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class DefaultCollectionTargetFactory
implements TranslationTargetFactory {
    @Override
    public <T> T getTranslationTargetInstance(Object source, Class<T> targetType) {
        Class<T> type = this.getDefaultTypeForTarget(targetType);
        if (type == null) {
            throw new TranslationException("Cannot determine default collection type for type: " + targetType);
        }
        return this.construct(type);
    }

    private <T> Class<? extends T> getDefaultTypeForTarget(Class<T> target) {
        if (target.isInterface()) {
            if (SortedSet.class.equals(target)) {
                return TreeSet.class;
            }
            if (Set.class.equals(target)) {
                return HashSet.class;
            }
            if (List.class.equals(target)) {
                return ArrayList.class;
            }
            if (Collection.class.equals(target)) {
                return ArrayList.class;
            }
            return null;
        }
        if (Collection.class.isAssignableFrom(target)) {
            return target;
        }
        return null;
    }

    private <T> T construct(Class<T> type) {
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException exception) {
            throw new TranslationInitializationException("No no-argument constructor in class " + type.getName(), exception);
        }
        catch (InstantiationException exception) {
            throw new TranslationInitializationException(String.format("Error while instantiating %s", type), exception);
        }
        catch (IllegalAccessException exception) {
            throw new TranslationInitializationException(String.format("Not allowed to instantiate %s", type), exception);
        }
        catch (IllegalArgumentException exception) {
            throw new TranslationInitializationException(String.format("Error while instantiating %s", type), exception);
        }
        catch (InvocationTargetException exception) {
            throw new TranslationInitializationException(String.format("Error thrown by constructor of %s", type), exception);
        }
    }
}

