/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.coi.impl;

import java.util.Set;
import javax.validation.Validator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.coi.framework.Project;
import org.kuali.coeus.coi.framework.ProjectPublisher;
import org.kuali.coeus.sys.impl.mq.rest.RestDestinationRegistry;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="projectPublisher")
public class ProjectPublisherImpl
implements ProjectPublisher {
    private static final Logger LOG = LogManager.getLogger(ProjectPublisherImpl.class);
    @Autowired
    @Qualifier(value="beanValidator")
    private Validator validator;
    @Autowired
    @Qualifier(value="restDestinationRegistry")
    private RestDestinationRegistry restDestinationRegistry;
    @Autowired(required=false)
    @Qualifier(value="amqpProjectTemplate")
    private AmqpTemplate amqpProjectTemplate;

    @Override
    public void publishProject(Project project) {
        Set violations = this.validator.validate((Object)project, new Class[0]);
        if (!violations.isEmpty()) {
            throw new IllegalArgumentException(violations.toString());
        }
        if (this.shouldPublish(project)) {
            this.amqpProjectTemplate.convertAndSend((Object)project);
        }
    }

    private boolean shouldPublish(Project project) {
        if (this.restDestinationRegistry.isEnabled("coi.projects")) {
            if (this.amqpProjectTemplate == null) {
                LOG.error("Messaging infrastructure is not available. Please enable the messaging profile. Project push messages will not publish");
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Producing Message " + project);
            }
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Destination Disabled.  Ignoring Project " + project);
        }
        return false;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }
}

