/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.framework.personnel;

import java.util.ArrayList;
import java.util.List;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetAuditEvent;
import org.kuali.coeus.common.budget.framework.core.BudgetAuditRuleBase;
import org.kuali.coeus.common.budget.framework.core.BudgetAuditRuleEvent;
import org.kuali.coeus.common.budget.framework.core.BudgetConstants;
import org.kuali.coeus.common.budget.framework.core.BudgetParent;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPerson;
import org.kuali.coeus.common.framework.rolodex.PersonRolodex;
import org.kuali.coeus.common.framework.ruleengine.KcBusinessRule;
import org.kuali.coeus.common.framework.ruleengine.KcEventMethod;
import org.kuali.kra.award.home.ContactRole;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;

@KcBusinessRule(value="budgetPersonnelAuditRule")
public class BudgetPersonnelAuditRule
extends BudgetAuditRuleBase {
    @KcEventMethod
    @Deprecated
    public boolean processRunPersonnelAuditBusinessRules(BudgetAuditEvent event) {
        boolean valid = true;
        ArrayList<AuditError> auditErrors = new ArrayList<AuditError>();
        Budget budget = event.getBudget();
        BudgetParent budgetParent = budget.getBudgetParent().getDocument().getBudgetParent();
        for (BudgetPerson budgetPerson : budget.getBudgetPersons()) {
            PersonRolodex proposalPerson;
            if (budgetPerson.getRolodexId() != null) {
                ContactRole role = budgetParent.getProposalNonEmployeeRole(budgetPerson.getRolodexId());
                if (role == null) continue;
                budgetPerson.setRole(role.getRoleDescription());
                continue;
            }
            if (budgetPerson.getPersonId() != null) {
                proposalPerson = budgetParent.getProposalEmployee(budgetPerson.getPersonId());
                if (proposalPerson == null || !proposalPerson.isOtherSignificantContributorFlag()) continue;
                auditErrors.add(new AuditError("document.budget.budgetPersonnel.osc." + budgetPerson.getPersonId(), "warning.personnel.osc", "personnel", new String[]{budgetPerson.getPersonName()}));
                continue;
            }
            if (budgetPerson.getRolodexId() == null || (proposalPerson = budgetParent.getProposalNonEmployee(budgetPerson.getRolodexId())) == null || !proposalPerson.isOtherSignificantContributorFlag()) continue;
            auditErrors.add(new AuditError("document.budget.budgetPersonnel.osc." + budgetPerson.getRolodexId(), "warning.personnel.osc", "personnel", new String[]{budgetPerson.getPersonName()}));
        }
        if (auditErrors.size() > 0) {
            this.getGlobalVariableService().getAuditErrorMap().put("budgetPersonnelAuditWarnings", new AuditCluster("personnel", auditErrors, "Warnings"));
        }
        return valid;
    }

    @KcEventMethod
    public boolean processRunPersonnelAuditBusinessRules(BudgetAuditRuleEvent event) {
        Budget budget = event.getBudget();
        for (BudgetPerson budgetPerson : budget.getBudgetPersons()) {
            PersonRolodex proposalPerson = budgetPerson.getPersonRolodex();
            if (proposalPerson == null || !proposalPerson.isOtherSignificantContributorFlag()) continue;
            BudgetConstants.BudgetAuditRules budgetProjectPersonnelRule = BudgetConstants.BudgetAuditRules.PROJECT_PERSONNEL;
            List<AuditError> auditErrors = this.getAuditErrors(budgetProjectPersonnelRule, false);
            auditErrors.add(new AuditError(budgetProjectPersonnelRule.getPageId(), "warning.personnel.osc", budgetProjectPersonnelRule.getPageId(), new String[]{budgetPerson.getPersonName()}));
            return false;
        }
        return true;
    }
}

