/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.calculator;

import com.google.common.base.Predicates;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.api.rate.RateClassType;
import org.kuali.coeus.common.budget.framework.calculator.BudgetCalculationService;
import org.kuali.coeus.common.budget.framework.calculator.BudgetSubcontractorFACalculator;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.CostElement;
import org.kuali.coeus.common.budget.framework.nonpersonnel.AbstractBudgetCalculatedAmount;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetRateAndBase;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelCalculatedAmount;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelDetails;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelRateAndBase;
import org.kuali.coeus.common.budget.framework.query.QueryList;
import org.kuali.coeus.common.budget.framework.query.operator.And;
import org.kuali.coeus.common.budget.framework.query.operator.Equals;
import org.kuali.coeus.common.budget.framework.query.operator.GreaterThan;
import org.kuali.coeus.common.budget.framework.query.operator.LesserThan;
import org.kuali.coeus.common.budget.framework.query.operator.Or;
import org.kuali.coeus.common.budget.framework.rate.BudgetRate;
import org.kuali.coeus.common.budget.framework.rate.ValidCeRateType;
import org.kuali.coeus.common.budget.framework.summary.BudgetSummaryService;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.util.ObjectUtils;

public class BudgetPeriodCalculator
implements BudgetSubcontractorFACalculator {
    private DataObjectService dataObjectService;
    private BudgetCalculationService budgetCalculationService;
    private DateTimeService dateTimeService;
    private BudgetSummaryService budgetSummaryService;
    private ParameterService parameterService;
    private List<String> errorMessages = new ArrayList<String>();

    public void calculate(Budget budget, BudgetPeriod budgetPeriod) {
        budgetPeriod.setTotalDirectCost(ScaleTwoDecimal.ZERO);
        budgetPeriod.setTotalDirectCostLessSubcontractorFA(ScaleTwoDecimal.ZERO);
        budgetPeriod.setTotalIndirectCost(ScaleTwoDecimal.ZERO);
        budgetPeriod.setCostSharingAmount(ScaleTwoDecimal.ZERO);
        budgetPeriod.setTotalCost(ScaleTwoDecimal.ZERO);
        budgetPeriod.setUnderrecoveryAmount(ScaleTwoDecimal.ZERO);
        new ArrayList<BudgetLineItem>(budgetPeriod.getBudgetLineItems()).forEach(budgetLineItem -> {
            this.getBudgetCalculationService().calculateBudgetLineItem(budget, (BudgetLineItem)budgetLineItem);
            budgetPeriod.setTotalDirectCost((ScaleTwoDecimal)budgetPeriod.getTotalDirectCost().add((AbstractDecimal)budgetLineItem.getDirectCost()));
            budgetPeriod.setTotalIndirectCost((ScaleTwoDecimal)budgetPeriod.getTotalIndirectCost().add((AbstractDecimal)budgetLineItem.getIndirectCost()));
            budgetPeriod.setTotalCost((ScaleTwoDecimal)budgetPeriod.getTotalCost().add((AbstractDecimal)((ScaleTwoDecimal)budgetLineItem.getDirectCost().add((AbstractDecimal)budgetLineItem.getIndirectCost()))));
            budgetPeriod.setUnderrecoveryAmount((ScaleTwoDecimal)budgetPeriod.getUnderrecoveryAmount().add((AbstractDecimal)budgetLineItem.getUnderrecoveryAmount()));
            budgetPeriod.setCostSharingAmount((ScaleTwoDecimal)budgetPeriod.getCostSharingAmount().add((AbstractDecimal)budgetLineItem.getTotalCostSharingAmount()));
        });
        ScaleTwoDecimal subconFADirectCost = this.calculateSubcontractorFACost(budgetPeriod);
        budgetPeriod.setTotalDirectCostLessSubcontractorFA((ScaleTwoDecimal)budgetPeriod.getTotalDirectCost().subtract((AbstractDecimal)subconFADirectCost));
    }

    public void applyToLaterPeriods(Budget budget, BudgetPeriod currentBudgetPeriod, BudgetLineItem currentBudgetLineItem) {
        List<BudgetPeriod> budgetPeriods = budget.getBudgetPeriods();
        BudgetLineItem prevBudgetLineItem = currentBudgetLineItem;
        int periodDuration = this.getDateTimeService().dateDiff((java.util.Date)currentBudgetPeriod.getStartDate(), (java.util.Date)currentBudgetPeriod.getEndDate(), false);
        this.getBudgetCalculationService().calculateBudgetLineItem(budget, currentBudgetLineItem);
        if (currentBudgetLineItem.getBudgetCategory() == null) {
            this.getDataObjectService().wrap((Object)currentBudgetLineItem).fetchRelationship("budgetCategory");
        }
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            if (budgetPeriod.getBudgetPeriod() <= currentBudgetPeriod.getBudgetPeriod()) continue;
            QueryList<BudgetLineItem> currentBudgetPeriodLineItems = new QueryList<BudgetLineItem>(budgetPeriod.getBudgetLineItems());
            for (BudgetLineItem budgetLineItemToBeApplied : currentBudgetPeriodLineItems) {
                if (budgetLineItemToBeApplied.getBudgetCategory() == null) {
                    this.getDataObjectService().wrap((Object)budgetLineItemToBeApplied).fetchRelationship("budgetCategory");
                }
                if (prevBudgetLineItem.getLineItemNumber().equals(budgetLineItemToBeApplied.getBasedOnLineItem())) {
                    budgetLineItemToBeApplied.setApplyInRateFlag(prevBudgetLineItem.getApplyInRateFlag());
                    if (prevBudgetLineItem.getApplyInRateFlag().booleanValue()) {
                        ScaleTwoDecimal lineItemCost = this.calculateInflation(budget, prevBudgetLineItem, budgetLineItemToBeApplied.getStartDate());
                        if (!budgetLineItemToBeApplied.getCostElement().equals(prevBudgetLineItem.getCostElement())) {
                            budgetLineItemToBeApplied.setBudgetPeriod(budgetPeriod.getBudgetPeriod());
                            budgetLineItemToBeApplied.setBudgetCategory(prevBudgetLineItem.getBudgetCategory());
                            budgetLineItemToBeApplied.setStartDate(budgetPeriod.getStartDate());
                            budgetLineItemToBeApplied.setEndDate(budgetPeriod.getEndDate());
                            budgetLineItemToBeApplied.setCostElement(prevBudgetLineItem.getCostElement());
                            budgetLineItemToBeApplied.refreshReferenceObject("costElementBO");
                            budgetLineItemToBeApplied.setBudgetCategoryCode(budgetLineItemToBeApplied.getCostElementBO().getBudgetCategoryCode());
                        }
                        budgetLineItemToBeApplied.setLineItemCost(lineItemCost);
                    } else {
                        budgetLineItemToBeApplied.setLineItemCost(prevBudgetLineItem.getLineItemCost());
                    }
                    budgetLineItemToBeApplied.setCostSharingAmount(prevBudgetLineItem.getCostSharingAmount());
                    budgetLineItemToBeApplied.setLineItemDescription(prevBudgetLineItem.getLineItemDescription());
                    budgetLineItemToBeApplied.setQuantity(prevBudgetLineItem.getQuantity());
                    budgetLineItemToBeApplied.setUnderrecoveryAmount(prevBudgetLineItem.getUnderrecoveryAmount());
                    budgetLineItemToBeApplied.setOnOffCampusFlag(prevBudgetLineItem.getOnOffCampusFlag());
                    this.getBudgetCalculationService().populateCalculatedAmount(budget, budgetLineItemToBeApplied);
                    for (BudgetLineItemCalculatedAmount prevCalAmts : prevBudgetLineItem.getBudgetLineItemCalculatedAmounts()) {
                        for (BudgetLineItemCalculatedAmount CalAmts : budgetLineItemToBeApplied.getBudgetLineItemCalculatedAmounts()) {
                            if (!prevCalAmts.getRateClassCode().equals(CalAmts.getRateClassCode()) || !prevCalAmts.getRateTypeCode().equals(CalAmts.getRateTypeCode())) continue;
                            CalAmts.setApplyRateFlag(prevCalAmts.getApplyRateFlag());
                        }
                    }
                    this.getBudgetCalculationService().calculateBudgetLineItem(budget, budgetLineItemToBeApplied);
                    prevBudgetLineItem = budgetLineItemToBeApplied;
                    continue;
                }
                if (!StringUtils.equals((CharSequence)currentBudgetLineItem.getBudgetCategory().getBudgetCategoryTypeCode(), (CharSequence)"P") || !StringUtils.equals((CharSequence)currentBudgetLineItem.getCostElement(), (CharSequence)budgetLineItemToBeApplied.getCostElement()) || !StringUtils.equals((CharSequence)currentBudgetLineItem.getGroupName(), (CharSequence)budgetLineItemToBeApplied.getGroupName())) continue;
                this.errorMessages.add("This line item contains personnel budget details and there is already a line item on period " + budgetPeriod + " for this Object Code \\ Group combination. \nCannot apply the changes to later periods.");
                return;
            }
            if (prevBudgetLineItem.getBudgetPeriod() >= budgetPeriod.getBudgetPeriod()) continue;
            prevBudgetLineItem.getBudgetPeriodBO();
            BudgetLineItem budgetLineItem = (BudgetLineItem)((Object)ObjectUtils.deepCopy((Serializable)((Object)prevBudgetLineItem)));
            budgetLineItem.setBudgetLineItemId(null);
            budgetLineItem.getBudgetCalculatedAmounts().clear();
            budgetLineItem.setBudgetPeriod(budgetPeriod.getBudgetPeriod());
            budgetLineItem.setBudgetPeriodId(budgetPeriod.getBudgetPeriodId());
            budgetLineItem.setBudgetPeriodBO(budgetPeriod);
            boolean isLeapDateInPeriod = this.getBudgetSummaryService().isLeapDaysInPeriod(prevBudgetLineItem.getStartDate(), prevBudgetLineItem.getEndDate());
            int gap = this.getDateTimeService().dateDiff((java.util.Date)currentBudgetPeriod.getStartDate(), (java.util.Date)currentBudgetLineItem.getStartDate(), false);
            boolean isLeapDayInGap = this.getBudgetSummaryService().isLeapDaysInPeriod(currentBudgetPeriod.getStartDate(), currentBudgetLineItem.getStartDate());
            int lineDuration = this.getDateTimeService().dateDiff((java.util.Date)budgetLineItem.getStartDate(), (java.util.Date)budgetLineItem.getEndDate(), false);
            int currentPeriodDuration = this.getDateTimeService().dateDiff((java.util.Date)budgetPeriod.getStartDate(), (java.util.Date)budgetPeriod.getEndDate(), false);
            ArrayList<Date> startEndDates = new ArrayList<Date>();
            if (periodDuration == lineDuration || lineDuration > currentPeriodDuration) {
                budgetLineItem.setStartDate(budgetPeriod.getStartDate());
                budgetLineItem.setEndDate(budgetPeriod.getEndDate());
            } else {
                startEndDates.add(0, budgetPeriod.getStartDate());
                startEndDates.add(1, budgetPeriod.getEndDate());
                List<Date> dates = this.getBudgetSummaryService().getNewStartEndDates(startEndDates, gap, lineDuration, budgetLineItem.getStartDate(), isLeapDateInPeriod, isLeapDayInGap);
                budgetLineItem.setStartDate(dates.get(0));
                budgetLineItem.setEndDate(dates.get(1));
            }
            budgetLineItem.setBasedOnLineItem(prevBudgetLineItem.getLineItemNumber());
            budgetLineItem.setVersionNumber(null);
            if (prevBudgetLineItem.getApplyInRateFlag().booleanValue()) {
                ScaleTwoDecimal lineItemCost = this.calculateInflation(budget, prevBudgetLineItem, budgetLineItem.getStartDate());
                budgetLineItem.setLineItemCost(lineItemCost);
            }
            lineDuration = this.getDateTimeService().dateDiff((java.util.Date)budgetLineItem.getStartDate(), (java.util.Date)budgetLineItem.getEndDate(), false);
            List<BudgetPersonnelDetails> budgetPersonnelDetails = budgetLineItem.getBudgetPersonnelDetailsList();
            for (BudgetPersonnelDetails budgetPersonnelDetail : budgetPersonnelDetails) {
                isLeapDateInPeriod = this.getBudgetSummaryService().isLeapDaysInPeriod(budgetPersonnelDetail.getStartDate(), budgetPersonnelDetail.getEndDate());
                budgetPersonnelDetail.setBudgetPersonnelLineItemId(null);
                budgetPersonnelDetail.getBudgetCalculatedAmounts().clear();
                budgetPersonnelDetail.setBudgetPeriod(budgetPeriod.getBudgetPeriod());
                budgetPersonnelDetail.setBudgetPeriodId(budgetPeriod.getBudgetPeriodId());
                budgetPersonnelDetail.setLineItemSequence(budget.getNextValue("budget.budgetPersonnelDetails.sequenceNumber"));
                int personnelDuration = this.getDateTimeService().dateDiff((java.util.Date)budgetPersonnelDetail.getStartDate(), (java.util.Date)budgetPersonnelDetail.getEndDate(), false);
                gap = this.getDateTimeService().dateDiff((java.util.Date)prevBudgetLineItem.getStartDate(), (java.util.Date)budgetPersonnelDetail.getStartDate(), false);
                isLeapDayInGap = this.getBudgetSummaryService().isLeapDaysInPeriod(prevBudgetLineItem.getStartDate(), budgetPersonnelDetail.getStartDate());
                if (periodDuration == personnelDuration || personnelDuration >= lineDuration) {
                    budgetPersonnelDetail.setStartDate(budgetLineItem.getStartDate());
                    budgetPersonnelDetail.setEndDate(budgetLineItem.getEndDate());
                } else {
                    startEndDates.add(0, budgetLineItem.getStartDate());
                    startEndDates.add(1, budgetLineItem.getEndDate());
                    List<Date> dates = this.getBudgetSummaryService().getNewStartEndDates(startEndDates, gap, personnelDuration, budgetPersonnelDetail.getStartDate(), isLeapDateInPeriod, isLeapDayInGap);
                    budgetPersonnelDetail.setStartDate(dates.get(0));
                    budgetPersonnelDetail.setEndDate(dates.get(1));
                }
                budgetPersonnelDetail.setVersionNumber(null);
                this.getBudgetCalculationService().populateCalculatedAmount(budget, budgetPersonnelDetail);
                List<BudgetPersonnelCalculatedAmount> persCalAmounts = budgetPersonnelDetail.getBudgetPersonnelCalculatedAmounts();
                for (BudgetPersonnelCalculatedAmount budgetPersonnelCalculatedAmount : persCalAmounts) {
                    budgetPersonnelCalculatedAmount.setBudgetPersonnelCalculatedAmountId(null);
                    budgetPersonnelCalculatedAmount.setVersionNumber(null);
                }
                List<BudgetPersonnelRateAndBase> perBudgetRateAndBases = budgetPersonnelDetail.getBudgetPersonnelRateAndBaseList();
                for (BudgetPersonnelRateAndBase budgetPersonnelRateAndBase : perBudgetRateAndBases) {
                    budgetPersonnelRateAndBase.setBudgetPersonnelRateAndBaseId(null);
                    budgetPersonnelRateAndBase.setVersionNumber(null);
                }
            }
            List<BudgetRateAndBase> budgetRateAndBases = budgetLineItem.getBudgetRateAndBaseList();
            for (BudgetRateAndBase budgetRateAndBase : budgetRateAndBases) {
                budgetRateAndBase.setBudgetRateAndBaseId(null);
                budgetRateAndBase.setVersionNumber(null);
            }
            budgetPeriod.getBudgetLineItems().add(budgetLineItem);
            this.getBudgetCalculationService().populateCalculatedAmount(budget, budgetLineItem);
            for (BudgetLineItemCalculatedAmount prevCalAmts : prevBudgetLineItem.getBudgetLineItemCalculatedAmounts()) {
                for (BudgetLineItemCalculatedAmount budgetLineItemCalculatedAmount : budgetLineItem.getBudgetLineItemCalculatedAmounts()) {
                    if (!prevCalAmts.getRateClassCode().equals(budgetLineItemCalculatedAmount.getRateClassCode()) || !prevCalAmts.getRateTypeCode().equals(budgetLineItemCalculatedAmount.getRateTypeCode())) continue;
                    budgetLineItemCalculatedAmount.setBudgetLineItemCalculatedAmountId(null);
                    budgetLineItemCalculatedAmount.setApplyRateFlag(prevCalAmts.getApplyRateFlag());
                    budgetLineItemCalculatedAmount.setVersionNumber(null);
                }
            }
            this.getBudgetCalculationService().calculateBudgetLineItem(budget, budgetLineItem);
            prevBudgetLineItem = budgetLineItem;
        }
    }

    private ScaleTwoDecimal calculateInflation(Budget budget, BudgetLineItem budgetLineItem, java.util.Date endDate) {
        QueryList<ValidCeRateType> vecValidCERateTypes;
        QueryList<ValidCeRateType> vecCE;
        CostElement costElement = budgetLineItem.getCostElementBO();
        ScaleTwoDecimal lineItemCost = budgetLineItem.getLineItemCost();
        Date startDate = budgetLineItem.getStartDate();
        Equals eqInflation = new Equals("rateClassType", (Comparable)((Object)RateClassType.INFLATION.getRateClassType()));
        if (costElement.getValidCeRateTypes().isEmpty()) {
            costElement.refreshReferenceObject("validCeRateTypes");
        }
        if ((vecCE = (vecValidCERateTypes = new QueryList<ValidCeRateType>(costElement.getValidCeRateTypes())).filter(eqInflation)) != null && vecCE.size() > 0) {
            ValidCeRateType validCERateTypesBean = vecCE.get(0);
            Equals eqRC = new Equals("rateClassCode", (Comparable)((Object)validCERateTypesBean.getRateClassCode()));
            Equals eqRT = new Equals("rateTypeCode", (Comparable)((Object)validCERateTypesBean.getRateTypeCode()));
            GreaterThan gtSD = new GreaterThan("startDate", startDate);
            LesserThan ltED = new LesserThan("startDate", endDate);
            Equals eqED = new Equals("startDate", endDate);
            Or ltEDOrEqED = new Or(ltED, eqED);
            And ltOrEqEDAndGtSD = new And(ltEDOrEqED, gtSD);
            And rcAndRt = new And(eqRC, eqRT);
            And rcAndRtAndLtOrEqEDAndGtSD = new And(rcAndRt, ltOrEqEDAndGtSD);
            QueryList<BudgetRate> vecPropInflationRates = new QueryList<BudgetRate>(budget.getBudgetRates()).filter(rcAndRtAndLtOrEqEDAndGtSD);
            if (!vecPropInflationRates.isEmpty()) {
                vecPropInflationRates.sort("startDate", false);
                BudgetRate proposalRatesBean = this.getCampusMatchedRateBean(budgetLineItem.getOnOffCampusFlag(), vecPropInflationRates);
                if (proposalRatesBean != null) {
                    ScaleTwoDecimal applicableRate = proposalRatesBean.getApplicableRate();
                    lineItemCost = (ScaleTwoDecimal)lineItemCost.add((AbstractDecimal)((ScaleTwoDecimal)lineItemCost.percentage((AbstractDecimal)applicableRate)));
                }
            }
        }
        return lineItemCost;
    }

    private BudgetRate getCampusMatchedRateBean(boolean onOffCampus, QueryList<BudgetRate> vecPropInflationRates) {
        BudgetRate proposalRatesBean = null;
        for (BudgetRate budgetRate : vecPropInflationRates) {
            if (!budgetRate.getOnOffCampusFlag().equals(onOffCampus)) continue;
            proposalRatesBean = budgetRate;
            break;
        }
        return proposalRatesBean;
    }

    public boolean syncToPeriodDirectCostLimit(Budget budget, BudgetPeriod budgetPeriod, BudgetLineItem budgetLineItem) {
        ScaleTwoDecimal originalLineItemCost = budgetLineItem.getLineItemCost();
        budgetLineItem.setLineItemCost(ScaleTwoDecimal.ZERO);
        this.calculate(budget, budgetPeriod);
        ScaleTwoDecimal periodTotal = budget.getExcludeSubconFAFromDirectCostSync() != false ? budgetPeriod.getTotalDirectCostLessSubcontractorFA() : budgetPeriod.getTotalDirectCost();
        ScaleTwoDecimal costLimit = budgetPeriod.getDirectCostLimit();
        return this.syncToFilteredPeriodCostLimit(budget, budgetPeriod, budgetLineItem, originalLineItemCost, periodTotal, costLimit, budgetLineItemCalculatedAmount -> !budgetLineItemCalculatedAmount.getRateClass().getRateClassTypeCode().equals(RateClassType.OVERHEAD.getRateClassType()));
    }

    public boolean syncToPeriodCostLimit(Budget budget, BudgetPeriod budgetPeriod, BudgetLineItem budgetLineItem) {
        ScaleTwoDecimal originalLineItemCost = budgetLineItem.getLineItemCost();
        budgetLineItem.setLineItemCost(ScaleTwoDecimal.ZERO);
        this.calculate(budget, budgetPeriod);
        ScaleTwoDecimal costLimit = budgetPeriod.getTotalCostLimit();
        ScaleTwoDecimal periodTotal = budgetPeriod.getTotalCost();
        return this.syncToFilteredPeriodCostLimit(budget, budgetPeriod, budgetLineItem, originalLineItemCost, periodTotal, costLimit, (Predicate<? super BudgetLineItemCalculatedAmount>)Predicates.alwaysTrue());
    }

    private boolean syncToFilteredPeriodCostLimit(Budget budget, BudgetPeriod budgetPeriod, BudgetLineItem budgetLineItem, ScaleTwoDecimal originalLineItemCost, ScaleTwoDecimal periodTotal, ScaleTwoDecimal costLimit, Predicate<? super BudgetLineItemCalculatedAmount> filter) {
        MathContext calculationContext = new MathContext(12, RoundingMode.HALF_UP);
        BigDecimal difference = ((ScaleTwoDecimal)costLimit.subtract((AbstractDecimal)periodTotal)).bigDecimalValue();
        ScaleTwoDecimal lineItemCost = new ScaleTwoDecimal(10000);
        budgetLineItem.setLineItemCost(lineItemCost);
        if (this.isProposalBudget(budget) && new ScaleTwoDecimal(difference).isLessEqual((AbstractDecimal)ScaleTwoDecimal.ZERO)) {
            budgetLineItem.setLineItemCost(originalLineItemCost);
            this.calculate(budget, budgetPeriod);
            return false;
        }
        this.calculate(budget, budgetPeriod);
        BigDecimal totalLineItemCost = budgetLineItem.getBudgetLineItemCalculatedAmounts().stream().filter(filter).map(AbstractBudgetCalculatedAmount::getCalculatedCost).map(AbstractDecimal::bigDecimalValue).reduce(BigDecimal.ZERO, BigDecimal::add).add(budgetLineItem.getLineItemCost().bigDecimalValue());
        BigDecimal directCostFraction = budgetLineItem.getLineItemCost().bigDecimalValue().divide(totalLineItemCost, calculationContext);
        ScaleTwoDecimal newCost = new ScaleTwoDecimal(difference.multiply(directCostFraction, calculationContext));
        budgetLineItem.setLineItemCost(newCost);
        this.calculate(budget, budgetPeriod);
        return true;
    }

    private boolean isProposalBudget(Budget budget) {
        return budget.isProposalBudget();
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public void setErrorMessages(List<String> errorMessages) {
        this.errorMessages = errorMessages;
    }

    public DataObjectService getDataObjectService() {
        if (this.dataObjectService == null) {
            this.dataObjectService = KcServiceLocator.getService(DataObjectService.class);
        }
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public BudgetCalculationService getBudgetCalculationService() {
        if (this.budgetCalculationService == null) {
            this.budgetCalculationService = KcServiceLocator.getService(BudgetCalculationService.class);
        }
        return this.budgetCalculationService;
    }

    public void setBudgetCalculationService(BudgetCalculationService budgetCalculationService) {
        this.budgetCalculationService = budgetCalculationService;
    }

    public DateTimeService getDateTimeService() {
        if (this.dateTimeService == null) {
            this.dateTimeService = KcServiceLocator.getService(DateTimeService.class);
        }
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public BudgetSummaryService getBudgetSummaryService() {
        if (this.budgetSummaryService == null) {
            this.budgetSummaryService = KcServiceLocator.getService(BudgetSummaryService.class);
        }
        return this.budgetSummaryService;
    }

    public void setBudgetSummaryService(BudgetSummaryService budgetSummaryService) {
        this.budgetSummaryService = budgetSummaryService;
    }

    @Override
    public ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

