/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.calculator;

import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.nonpersonnel.AbstractBudgetCalculatedAmount;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItemBase;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelCalculatedAmount;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelDetails;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelRateAndBase;
import org.kuali.coeus.common.budget.framework.query.QueryList;
import org.kuali.coeus.common.budget.framework.rate.BudgetLaRate;
import org.kuali.coeus.common.budget.framework.rate.BudgetRate;
import org.kuali.coeus.common.budget.impl.calculator.AbstractBudgetCalculator;
import org.kuali.coeus.common.budget.impl.calculator.Boundary;
import org.kuali.coeus.common.budget.impl.calculator.BreakUpInterval;
import org.kuali.coeus.common.budget.impl.calculator.RateAndCost;
import org.kuali.coeus.common.budget.impl.calculator.SalaryCalculator;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;

public class PersonnelLineItemCalculator
extends AbstractBudgetCalculator {
    private BudgetPersonnelDetails budgetPersonnelLineItem;
    private Budget budget;
    private SalaryCalculator salaryCalculator;

    public PersonnelLineItemCalculator(Budget budget, BudgetLineItemBase bli) {
        super(budget, bli);
        this.budgetPersonnelLineItem = (BudgetPersonnelDetails)bli;
        this.budget = budget;
        this.salaryCalculator = new SalaryCalculator(budget, this.budgetPersonnelLineItem);
    }

    @Override
    public void populateApplicableCosts(Boundary boundary) {
        this.salaryCalculator.setInflationRates(this.getInflationRates());
        this.salaryCalculator.calculate(boundary);
    }

    private Map<String, Boolean> saveApplyRateFlagsForReset() {
        HashMap<String, Boolean> applyRateFlags = new HashMap<String, Boolean>();
        if (this.budgetPersonnelLineItem != null && CollectionUtils.isNotEmpty(this.budgetPersonnelLineItem.getBudgetPersonnelCalculatedAmounts())) {
            for (BudgetPersonnelCalculatedAmount budgetPersonnelCalculatedAmount : this.budgetPersonnelLineItem.getBudgetPersonnelCalculatedAmounts()) {
                applyRateFlags.put(budgetPersonnelCalculatedAmount.getRateClassCode() + budgetPersonnelCalculatedAmount.getRateTypeCode(), budgetPersonnelCalculatedAmount.getApplyRateFlag());
            }
        }
        return applyRateFlags;
    }

    @Override
    public void populateCalculatedAmountLineItems() {
        Long versionNumber = -1L;
        Map<String, Boolean> applyRateFlags = null;
        if (this.isPerformSync()) {
            if (this.budgetPersonnelLineItem.getBudgetPersonnelCalculatedAmounts().size() > 0) {
                versionNumber = this.budgetPersonnelLineItem.getBudgetPersonnelCalculatedAmounts().get(0).getVersionNumber();
            }
            applyRateFlags = this.saveApplyRateFlagsForReset();
            this.setCalculatedAmounts(this.budgetPersonnelLineItem);
            for (BudgetPersonnelCalculatedAmount budgetPersonnelCalculatedAmount : this.budgetPersonnelLineItem.getBudgetPersonnelCalculatedAmounts()) {
                if (versionNumber == null || versionNumber <= -1L) continue;
                budgetPersonnelCalculatedAmount.setVersionNumber(versionNumber);
            }
        }
        if (this.budgetPersonnelLineItem.getBudgetPersonnelCalculatedAmounts().size() <= 0) {
            this.setCalculatedAmounts(this.budgetPersonnelLineItem);
        }
        for (BudgetPersonnelCalculatedAmount budgetPersonnelCalculatedAmount : this.budgetPersonnelLineItem.getBudgetPersonnelCalculatedAmounts()) {
            if (applyRateFlags == null || applyRateFlags.get(budgetPersonnelCalculatedAmount.getRateClassCode() + budgetPersonnelCalculatedAmount.getRateTypeCode()) == null) continue;
            budgetPersonnelCalculatedAmount.setApplyRateFlag(applyRateFlags.get(budgetPersonnelCalculatedAmount.getRateClassCode() + budgetPersonnelCalculatedAmount.getRateTypeCode()));
        }
    }

    protected boolean isPerformSync() {
        return this.getBudgetRateService().performSyncFlag(this.budget);
    }

    @Override
    protected void updateBudgetLineItemCalculatedAmounts() {
        this.salaryCalculator.calculate();
        this.budgetPersonnelLineItem.setLineItemCost(this.budgetPersonnelLineItem.getSalaryRequested());
        super.updateBudgetLineItemCalculatedAmounts();
    }

    @Override
    protected void addCalculatedAmount(AbstractBudgetCalculatedAmount budgetCalculatedAmount) {
        BudgetPersonnelCalculatedAmount budgetPersonnelCalculatedAmt = (BudgetPersonnelCalculatedAmount)budgetCalculatedAmount;
        budgetPersonnelCalculatedAmt.setPersonNumber(this.budgetPersonnelLineItem.getPersonNumber());
        budgetPersonnelCalculatedAmt.setBudgetPersonnelLineItem(this.budgetPersonnelLineItem);
        this.budgetPersonnelLineItem.getBudgetPersonnelCalculatedAmounts().add(budgetPersonnelCalculatedAmt);
    }

    @Override
    protected AbstractBudgetCalculatedAmount getNewCalculatedAmountInstance() {
        return this.budgetPersonnelLineItem.getNewBudgetPersonnelCalculatedAmount();
    }

    @Override
    protected void populateBudgetRateBaseList() {
        List<BudgetPersonnelRateAndBase> budgetRateAndBaseList = this.budgetPersonnelLineItem.getBudgetPersonnelRateAndBaseList();
        List<BreakUpInterval> breakupIntervals = this.getBreakupIntervals();
        if (!budgetRateAndBaseList.isEmpty()) {
            budgetRateAndBaseList.clear();
        }
        Integer rateNumber = 0;
        for (BreakUpInterval breakUpInterval : breakupIntervals) {
            QueryList<RateAndCost> vecAmountBean = breakUpInterval.getRateAndCosts();
            for (RateAndCost rateAndCost : vecAmountBean) {
                BudgetPersonnelRateAndBase budgetRateBase = new BudgetPersonnelRateAndBase();
                ScaleTwoDecimal appliedRate = rateAndCost.getAppliedRate();
                budgetRateBase.setAppliedRate(ScaleTwoDecimal.returnZeroIfNull((ScaleTwoDecimal)appliedRate));
                ScaleTwoDecimal calculatedCost = rateAndCost.getCalculatedCost();
                ScaleTwoDecimal calculatedCostSharing = rateAndCost.getCalculatedCostSharing();
                budgetRateBase.setSalaryRequested(rateAndCost.getBaseAmount());
                budgetRateBase.setBaseCostSharing(rateAndCost.getBaseCostSharingAmount());
                budgetRateBase.setBudgetPeriod(this.budgetPersonnelLineItem.getBudgetPeriod());
                budgetRateBase.setCalculatedCost(calculatedCost);
                budgetRateBase.setCalculatedCostSharing(calculatedCostSharing);
                java.util.Date endDate = breakUpInterval.getBoundary().getEndDate();
                budgetRateBase.setEndDate(new Date(endDate.getTime()));
                budgetRateBase.setLineItemNumber(this.budgetPersonnelLineItem.getLineItemNumber());
                budgetRateBase.setOnOffCampusFlag(this.budgetPersonnelLineItem.getOnOffCampusFlag());
                budgetRateBase.setBudgetId(this.budgetPersonnelLineItem.getBudgetId());
                budgetRateBase.setPersonNumber(this.budgetPersonnelLineItem.getPersonNumber());
                budgetRateBase.setPersonId(this.budgetPersonnelLineItem.getPersonId());
                budgetRateBase.setRateClassCode(rateAndCost.getRateClassCode());
                rateNumber = rateNumber + 1;
                budgetRateBase.setRateNumber(rateNumber);
                budgetRateBase.setRateTypeCode(rateAndCost.getRateTypeCode());
                java.util.Date startDate = breakUpInterval.getBoundary().getStartDate();
                budgetRateBase.setStartDate(new Date(startDate.getTime()));
                budgetRateBase.setBudgetPersonnelLineItem(this.budgetPersonnelLineItem);
                budgetRateBase.setBudgetPeriodId(this.budgetPersonnelLineItem.getBudgetPeriodId());
                budgetRateAndBaseList.add(budgetRateBase);
            }
        }
    }

    @Override
    protected List<BudgetRate> getBudgetRates() {
        if (StringUtils.isNotEmpty((CharSequence)this.budgetPersonnelLineItem.getBudgetLineItem().getHierarchyProposalNumber())) {
            return this.budgetPersonnelLineItem.getBudgetLineItem().getHierarchyProposal().getHierarchySummaryBudget().getBudgetRates();
        }
        return this.budget.getBudgetRates();
    }

    @Override
    protected List<BudgetLaRate> getBudgetLaRates() {
        if (StringUtils.isNotEmpty((CharSequence)this.budgetPersonnelLineItem.getBudgetLineItem().getHierarchyProposalNumber())) {
            return this.budgetPersonnelLineItem.getBudgetLineItem().getHierarchyProposal().getHierarchySummaryBudget().getBudgetLaRates();
        }
        return this.budget.getBudgetLaRates();
    }
}

