/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.print;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.print.BudgetPrintService;
import org.kuali.coeus.common.budget.framework.print.BudgetPrintType;
import org.kuali.coeus.common.budget.impl.print.BudgetCostShareSummaryPrint;
import org.kuali.coeus.common.budget.impl.print.BudgetCumulativePrint;
import org.kuali.coeus.common.budget.impl.print.BudgetPrintForm;
import org.kuali.coeus.common.budget.impl.print.BudgetSalaryPrint;
import org.kuali.coeus.common.budget.impl.print.BudgetSummaryPrint;
import org.kuali.coeus.common.budget.impl.print.BudgetSummaryTotalPrint;
import org.kuali.coeus.common.budget.impl.print.BudgetTotalPrint;
import org.kuali.coeus.common.budget.impl.print.IndustrialBudgetPrint;
import org.kuali.coeus.common.budget.impl.print.IndustrialCumulativeBudgetPrint;
import org.kuali.coeus.common.framework.print.AbstractPrint;
import org.kuali.coeus.common.framework.print.AttachmentDataSource;
import org.kuali.coeus.common.framework.print.Printable;
import org.kuali.coeus.common.framework.print.PrintingException;
import org.kuali.coeus.common.framework.print.PrintingService;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="budgetPrintService")
public class BudgetPrintingServiceImpl
implements BudgetPrintService {
    private static final Logger LOG = LogManager.getLogger(BudgetPrintingServiceImpl.class);
    @Autowired
    @Qualifier(value="budgetSummaryPrint")
    private BudgetSummaryPrint budgetSummaryPrint;
    @Autowired
    @Qualifier(value="budgetCostShareSummaryPrint")
    private BudgetCostShareSummaryPrint budgetCostShareSummaryPrint;
    @Autowired
    @Qualifier(value="budgetSalaryPrint")
    private BudgetSalaryPrint budgetSalaryPrint;
    @Autowired
    @Qualifier(value="printingService")
    private PrintingService printingService;
    @Autowired
    @Qualifier(value="budgetTotalPrint")
    private BudgetTotalPrint budgetTotalPrint;
    @Autowired
    @Qualifier(value="budgetSummaryTotalPrint")
    private BudgetSummaryTotalPrint budgetSummaryTotalPrint;
    @Autowired
    @Qualifier(value="industrialCumulativeBudgetPrint")
    private IndustrialCumulativeBudgetPrint industrialCumulativeBudgetPrint;
    @Autowired
    @Qualifier(value="industrialBudgetPrint")
    private IndustrialBudgetPrint industrialBudgetPrint;
    @Autowired
    @Qualifier(value="budgetCumulativePrint")
    private BudgetCumulativePrint budgetCumulativePrint;

    public AttachmentDataSource printBudgetReport(KcPersistableBusinessObjectBase budget, String reportName) throws PrintingException {
        AttachmentDataSource attachmentDataSource = null;
        AbstractPrint printable = null;
        String fileName = reportName + "-" + ((Budget)budget).getParentDocumentKey() + ".pdf";
        if (reportName.equals(BudgetPrintType.BUDGET_SUMMARY_REPORT.getBudgetPrintType())) {
            printable = this.getBudgetSummaryPrint();
        } else if (reportName.equals(BudgetPrintType.BUDGET_COST_SHARE_SUMMARY_REPORT.getBudgetPrintType())) {
            printable = this.getBudgetCostShareSummaryPrint();
        } else if (reportName.equals(BudgetPrintType.INDUSTRIAL_CUMULATIVE_BUDGET_REPORT.getBudgetPrintType())) {
            printable = this.getIndustrialCumulativeBudgetPrint();
        } else if (reportName.equals(BudgetPrintType.BUDGET_SALARY_REPORT.getBudgetPrintType())) {
            printable = this.getBudgetSalaryPrint();
        } else if (reportName.equals(BudgetPrintType.BUDGET_TOTAL_REPORT.getBudgetPrintType())) {
            printable = this.getBudgetTotalPrint();
        } else if (reportName.equals(BudgetPrintType.BUDGET_SUMMARY_TOTAL_REPORT.getBudgetPrintType())) {
            printable = this.getBudgetSummaryTotalPrint();
        } else if (reportName.equals(BudgetPrintType.BUDGET_CUMULATIVE_REPORT.getBudgetPrintType())) {
            printable = this.getBudgetCumulativePrint();
        } else if (reportName.equals(BudgetPrintType.INDUSTRIAL_BUDGET_REPORT.getBudgetPrintType())) {
            printable = this.getIndustrialBudgetPrint();
        }
        printable.setPrintableBusinessObject(budget);
        attachmentDataSource = this.getPrintingService().print(printable);
        try {
            attachmentDataSource.setName(URLEncoder.encode(fileName, StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            attachmentDataSource.setName(fileName);
        }
        attachmentDataSource.setType("application/pdf");
        return attachmentDataSource;
    }

    @Override
    public void populateBudgetPrintForms(Budget budget) {
        BudgetPrintForm budgetCostShareForm = new BudgetPrintForm();
        budgetCostShareForm.setBudgetReportId(BudgetPrintType.BUDGET_COST_SHARE_SUMMARY_REPORT.getBudgetPrintType());
        budgetCostShareForm.setBudgetReportName(BudgetPrintType.BUDGET_COST_SHARE_SUMMARY_REPORT.getBudgetPrintType());
        BudgetPrintForm budgetCumulativeForm = new BudgetPrintForm();
        budgetCumulativeForm.setBudgetReportId(BudgetPrintType.BUDGET_CUMULATIVE_REPORT.getBudgetPrintType());
        budgetCumulativeForm.setBudgetReportName(BudgetPrintType.BUDGET_CUMULATIVE_REPORT.getBudgetPrintType());
        BudgetPrintForm budgetSalaryForm = new BudgetPrintForm();
        budgetSalaryForm.setBudgetReportId(BudgetPrintType.BUDGET_SALARY_REPORT.getBudgetPrintType());
        budgetSalaryForm.setBudgetReportName(BudgetPrintType.BUDGET_SALARY_REPORT.getBudgetPrintType());
        BudgetPrintForm budgetSummaryForm = new BudgetPrintForm();
        budgetSummaryForm.setBudgetReportId(BudgetPrintType.BUDGET_SUMMARY_REPORT.getBudgetPrintType());
        budgetSummaryForm.setBudgetReportName(BudgetPrintType.BUDGET_SUMMARY_REPORT.getBudgetPrintType());
        BudgetPrintForm budgetSummaryTotalForm = new BudgetPrintForm();
        budgetSummaryTotalForm.setBudgetReportId(BudgetPrintType.BUDGET_SUMMARY_TOTAL_REPORT.getBudgetPrintType());
        budgetSummaryTotalForm.setBudgetReportName(BudgetPrintType.BUDGET_SUMMARY_TOTAL_REPORT.getBudgetPrintType());
        BudgetPrintForm budgetTotalForm = new BudgetPrintForm();
        budgetTotalForm.setBudgetReportId(BudgetPrintType.BUDGET_TOTAL_REPORT.getBudgetPrintType());
        budgetTotalForm.setBudgetReportName(BudgetPrintType.BUDGET_TOTAL_REPORT.getBudgetPrintType());
        BudgetPrintForm industrialBudgetForm = new BudgetPrintForm();
        industrialBudgetForm.setBudgetReportId(BudgetPrintType.INDUSTRIAL_BUDGET_REPORT.getBudgetPrintType());
        industrialBudgetForm.setBudgetReportName(BudgetPrintType.INDUSTRIAL_BUDGET_REPORT.getBudgetPrintType());
        BudgetPrintForm industrialBudgetCumulativeForm = new BudgetPrintForm();
        industrialBudgetCumulativeForm.setBudgetReportId(BudgetPrintType.INDUSTRIAL_CUMULATIVE_BUDGET_REPORT.getBudgetPrintType());
        industrialBudgetCumulativeForm.setBudgetReportName(BudgetPrintType.INDUSTRIAL_CUMULATIVE_BUDGET_REPORT.getBudgetPrintType());
        ArrayList<BudgetPrintForm> printForms = new ArrayList<BudgetPrintForm>();
        printForms.add(budgetCostShareForm);
        printForms.add(budgetCumulativeForm);
        printForms.add(budgetSalaryForm);
        printForms.add(budgetSummaryForm);
        printForms.add(budgetSummaryTotalForm);
        printForms.add(budgetTotalForm);
        printForms.add(industrialBudgetForm);
        printForms.add(industrialBudgetCumulativeForm);
        budget.setBudgetPrintForms(printForms);
    }

    @Override
    public AttachmentDataSource readBudgetPrintStream(Budget budget, String selectedBudgetPrintFormId) {
        try {
            return this.printBudgetReport(budget, selectedBudgetPrintFormId);
        }
        catch (PrintingException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public AttachmentDataSource readBudgetSelectedPrintStreams(Budget budget, List<BudgetPrintForm> budgetPrintForms, String reportName) {
        try {
            return this.printBudgetSelectedReports(budget, budgetPrintForms, reportName);
        }
        catch (PrintingException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public AttachmentDataSource printBudgetSelectedReports(KcPersistableBusinessObjectBase budget, List<BudgetPrintForm> budgetPrintForms, String formName) throws PrintingException {
        AttachmentDataSource attachmentDataSource = null;
        ArrayList<Printable> printableArtifactList = new ArrayList<Printable>();
        String fileName = formName + "-" + ((Budget)budget).getParentDocumentKey() + ".pdf";
        for (BudgetPrintForm budgetPrintForm : budgetPrintForms) {
            AbstractPrint printable = null;
            String reportName = budgetPrintForm.getBudgetReportId();
            if (reportName.equals(BudgetPrintType.BUDGET_SUMMARY_REPORT.getBudgetPrintType())) {
                printable = this.getBudgetSummaryPrint();
            } else if (reportName.equals(BudgetPrintType.BUDGET_COST_SHARE_SUMMARY_REPORT.getBudgetPrintType())) {
                printable = this.getBudgetCostShareSummaryPrint();
            } else if (reportName.equals(BudgetPrintType.INDUSTRIAL_CUMULATIVE_BUDGET_REPORT.getBudgetPrintType())) {
                printable = this.getIndustrialCumulativeBudgetPrint();
            } else if (reportName.equals(BudgetPrintType.BUDGET_SALARY_REPORT.getBudgetPrintType())) {
                printable = this.getBudgetSalaryPrint();
            } else if (reportName.equals(BudgetPrintType.BUDGET_TOTAL_REPORT.getBudgetPrintType())) {
                printable = this.getBudgetTotalPrint();
            } else if (reportName.equals(BudgetPrintType.BUDGET_SUMMARY_TOTAL_REPORT.getBudgetPrintType())) {
                printable = this.getBudgetSummaryTotalPrint();
            } else if (reportName.equals(BudgetPrintType.BUDGET_CUMULATIVE_REPORT.getBudgetPrintType())) {
                printable = this.getBudgetCumulativePrint();
            } else if (reportName.equals(BudgetPrintType.INDUSTRIAL_BUDGET_REPORT.getBudgetPrintType())) {
                printable = this.getIndustrialBudgetPrint();
            }
            Budget copiedBudget = null;
            if (Boolean.TRUE.equals(budgetPrintForm.getSelectToComment())) {
                copiedBudget = (Budget)budget;
                copiedBudget.setPrintBudgetCommentFlag("true");
            } else {
                copiedBudget = (Budget)budget;
                copiedBudget.setPrintBudgetCommentFlag("false");
            }
            ((AbstractPrint)printable).setPrintableBusinessObject(copiedBudget);
            printableArtifactList.add(printable);
        }
        attachmentDataSource = this.getPrintingService().print(printableArtifactList);
        try {
            attachmentDataSource.setName(URLEncoder.encode(fileName, StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            attachmentDataSource.setName(fileName);
        }
        attachmentDataSource.setType("application/pdf");
        return attachmentDataSource;
    }

    public BudgetSummaryPrint getBudgetSummaryPrint() {
        return this.budgetSummaryPrint;
    }

    public void setBudgetSummaryPrint(BudgetSummaryPrint budgetSummaryPrint) {
        this.budgetSummaryPrint = budgetSummaryPrint;
    }

    public BudgetCostShareSummaryPrint getBudgetCostShareSummaryPrint() {
        return this.budgetCostShareSummaryPrint;
    }

    public void setBudgetCostShareSummaryPrint(BudgetCostShareSummaryPrint budgetCostShareSummaryPrint) {
        this.budgetCostShareSummaryPrint = budgetCostShareSummaryPrint;
    }

    public BudgetSalaryPrint getBudgetSalaryPrint() {
        return this.budgetSalaryPrint;
    }

    public void setBudgetSalaryPrint(BudgetSalaryPrint budgetSalaryPrint) {
        this.budgetSalaryPrint = budgetSalaryPrint;
    }

    public PrintingService getPrintingService() {
        return this.printingService;
    }

    public void setPrintingService(PrintingService printingService) {
        this.printingService = printingService;
    }

    public BudgetTotalPrint getBudgetTotalPrint() {
        return this.budgetTotalPrint;
    }

    public void setBudgetTotalPrint(BudgetTotalPrint budgetTotalPrint) {
        this.budgetTotalPrint = budgetTotalPrint;
    }

    public BudgetSummaryTotalPrint getBudgetSummaryTotalPrint() {
        return this.budgetSummaryTotalPrint;
    }

    public void setBudgetSummaryTotalPrint(BudgetSummaryTotalPrint budgetSummaryTotalPrint) {
        this.budgetSummaryTotalPrint = budgetSummaryTotalPrint;
    }

    public IndustrialCumulativeBudgetPrint getIndustrialCumulativeBudgetPrint() {
        return this.industrialCumulativeBudgetPrint;
    }

    public void setIndustrialCumulativeBudgetPrint(IndustrialCumulativeBudgetPrint industrialCumulativeBudgetPrint) {
        this.industrialCumulativeBudgetPrint = industrialCumulativeBudgetPrint;
    }

    public IndustrialBudgetPrint getIndustrialBudgetPrint() {
        return this.industrialBudgetPrint;
    }

    public void setIndustrialBudgetPrint(IndustrialBudgetPrint industrialBudgetPrint) {
        this.industrialBudgetPrint = industrialBudgetPrint;
    }

    public BudgetCumulativePrint getBudgetCumulativePrint() {
        return this.budgetCumulativePrint;
    }

    public void setBudgetCumulativePrint(BudgetCumulativePrint budgetCumulativePrint) {
        this.budgetCumulativePrint = budgetCumulativePrint;
    }
}

