/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.custom.attr;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.kuali.coeus.common.framework.custom.DocumentCustomData;
import org.kuali.coeus.common.framework.custom.attr.CustomAttribute;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeDataType;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeDocument;
import org.kuali.kra.bo.KraSortablePersistableBusinessObjectBase;

public interface CustomAttributeService {
    public Map<String, CustomAttributeDocument> getDefaultCustomAttributeDocuments(String var1, List<? extends DocumentCustomData> var2);

    public void setCustomAttributeKeyValue(String var1, Map<String, CustomAttributeDocument> var2, String var3, String var4);

    public CustomAttributeDataType getCustomAttributeDataType(String var1);

    public List getLookupReturns(String var1) throws Exception;

    public String getLookupReturnsForAjaxCall(String var1) throws Exception;

    public boolean isRequired(String var1, CustomAttribute var2, List<? extends DocumentCustomData> var3);

    public Map<String, String> getDocumentTypeMap();

    public Map<String, String> getReverseDocumentTypeMap();

    public static Comparator<CustomAttributeDocument> customAttributeSortIdComparator() {
        return Comparator.comparing(KraSortablePersistableBusinessObjectBase::getSortId, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(cad -> Optional.ofNullable(cad.getCustomAttribute()).map(CustomAttribute::getLabel).orElse(""));
    }

    public static SortedMap<String, List<CustomAttributeDocument>> getSortedAttributeGroups(Collection<CustomAttributeDocument> customAttributeDocuments) {
        SortedMap sortedGroups = customAttributeDocuments.stream().collect(Collectors.groupingBy(cad -> Optional.ofNullable(cad.getCustomAttribute()).map(CustomAttribute::getGroupName).orElse(""), TreeMap::new, Collectors.toList()));
        sortedGroups.forEach((groupName, groupList) -> groupList.sort(CustomAttributeService.customAttributeSortIdComparator()));
        return sortedGroups;
    }
}

