/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.print;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.print.CurrentReportBean;
import org.kuali.coeus.common.framework.print.PendingReportBean;
import org.kuali.coeus.common.proposal.framework.report.CurrentAndPendingReportService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class ReportHelper
implements Serializable {
    @Autowired
    @Qualifier(value="currentAndPendingReportService")
    private CurrentAndPendingReportService currentAndPendingReportService;
    private String reportType;
    private String personId;
    private KcPerson targetPerson;
    private List<CurrentReportBean> currentReportBeans = new ArrayList<CurrentReportBean>();
    private List<PendingReportBean> pendingReportBeans = new ArrayList<PendingReportBean>();

    public ReportHelper() {
        this.setTargetPerson(new KcPerson());
    }

    public List<CurrentReportBean> getCurrentReportBeans() {
        return this.currentReportBeans;
    }

    public void setCurrentReportBeans(List<CurrentReportBean> currentReportBeans) {
        this.currentReportBeans = currentReportBeans;
    }

    public List<PendingReportBean> getPendingReportBeans() {
        return this.pendingReportBeans;
    }

    public void setPendingReportBeans(List<PendingReportBean> pendingReportBeans) {
        this.pendingReportBeans = pendingReportBeans;
    }

    public void prepareCurrentReport() {
        this.setCurrentReportBeans(this.getCurrentAndPendingReportService().loadCurrentReportData(this.personId));
    }

    public void preparePendingReport() {
        this.setPendingReportBeans(this.getCurrentAndPendingReportService().loadPendingReportData(this.personId));
    }

    public String getReportType() {
        return this.reportType;
    }

    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    public String getPersonId() {
        return this.personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public KcPerson getTargetPerson() {
        return this.targetPerson;
    }

    public void setTargetPerson(KcPerson targetPerson) {
        this.targetPerson = targetPerson;
    }

    public CurrentAndPendingReportService getCurrentAndPendingReportService() {
        if (this.currentAndPendingReportService == null) {
            this.currentAndPendingReportService = KcServiceLocator.getService(CurrentAndPendingReportService.class);
        }
        return this.currentAndPendingReportService;
    }

    public void setCurrentAndPendingReportService(CurrentAndPendingReportService currentAndPendingReportService) {
        this.currentAndPendingReportService = currentAndPendingReportService;
    }
}

