/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.attachment;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.sql.DataSource;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.attachment.KcAttachmentDataDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="kcAttachmentDataDao")
public class KcAttachmentDataDaoImpl
implements KcAttachmentDataDao {
    protected static final String SELECT_RECORD_DATA_ONLY = "select data from file_data where id = ?";
    protected static final String INSERT_RECORD = "insert into file_data (id, data) values (?, ?)";
    protected static final String DELETE_SINGLE_RECORD = "delete from file_data where id = ?";
    private static Logger LOG = LogManager.getLogger(KcAttachmentDataDaoImpl.class);
    @Autowired
    @Qualifier(value="dataSource")
    private DataSource dataSource;
    private Set<TableReference> tableReferences;

    /*
     * Exception decompiling
     */
    @Override
    public byte[] getData(String id) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public String saveData(byte[] attachmentData, String id) {
        if (ArrayUtils.isEmpty((byte[])attachmentData)) {
            throw new IllegalArgumentException("attachmentData is null or empty");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Saving attachment data to database, existing id: " + id);
        }
        try (Connection connection = this.getDataSource().getConnection();){
            String string;
            block26: {
                PreparedStatement stmt = connection.prepareStatement(INSERT_RECORD);
                try {
                    String newId = UUID.randomUUID().toString();
                    stmt.setString(1, newId);
                    try (ByteArrayInputStream is = new ByteArrayInputStream(attachmentData);){
                        stmt.setBinaryStream(2, (InputStream)is, attachmentData.length);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    stmt.executeUpdate();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Created attachment data, new id: " + newId);
                    }
                    if (StringUtils.isNotBlank((CharSequence)id)) {
                        this.deleteAttachment(connection, id);
                    }
                    string = newId;
                    if (stmt == null) break block26;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return string;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void removeData(String id) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing attachment data from database, existing id: " + id);
        }
        if (StringUtils.isNotBlank((CharSequence)id)) {
            try (Connection conn = this.getDataSource().getConnection();){
                this.deleteAttachment(conn, id);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected boolean deleteAttachment(Connection conn, String id) throws SQLException {
        if (this.countReferences(conn, id) == 0) {
            try (PreparedStatement stmt = conn.prepareStatement(DELETE_SINGLE_RECORD);){
                stmt.setString(1, id);
                stmt.executeUpdate();
            }
            return true;
        }
        return false;
    }

    protected int countReferences(Connection conn, String id) throws SQLException {
        if (this.tableReferences == null) {
            this.populateReferences(conn);
        }
        int count = 0;
        for (TableReference ref : this.tableReferences) {
            PreparedStatement stmt = conn.prepareStatement("select count(*) from " + ref.tableName + " where " + ref.columnName + " = ?");
            try {
                stmt.setString(1, id);
                ResultSet rs = stmt.executeQuery();
                try {
                    if (!rs.next()) continue;
                    count += rs.getInt(1);
                }
                finally {
                    if (rs == null) continue;
                    rs.close();
                }
            }
            finally {
                if (stmt == null) continue;
                stmt.close();
            }
        }
        return count;
    }

    protected void populateReferences(Connection conn) throws SQLException {
        String catalog;
        this.tableReferences = new HashSet<TableReference>();
        String schema = catalog = conn.getCatalog();
        if (catalog == null) {
            schema = conn.getSchema();
        }
        try {
            if (conn.getMetaData().getSchemas().next()) {
                schema = conn.getSchema();
            }
        }
        catch (AbstractMethodError e) {
            LOG.info("Unable to retrieve schema, using catalog " + e.getMessage(), (Throwable)e);
        }
        try (ResultSet rs = conn.getMetaData().getExportedKeys(catalog, schema, "FILE_DATA");){
            while (rs.next()) {
                this.tableReferences.add(new TableReference(rs.getString("FKTABLE_NAME"), rs.getString("FKCOLUMN_NAME")));
            }
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Set<TableReference> getTableReferences() {
        return this.tableReferences;
    }

    public void setTableReferences(Set<TableReference> tableReferences) {
        this.tableReferences = tableReferences;
    }

    class TableReference {
        public String tableName;
        public String columnName;

        public TableReference(String tableName, String columnName) {
            this.tableName = tableName;
            this.columnName = columnName;
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.tableName).append((Object)this.columnName).toHashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TableReference other = (TableReference)obj;
            return new EqualsBuilder().append((Object)this.tableName, (Object)other.tableName).append((Object)this.columnName, (Object)other.columnName).isEquals();
        }
    }
}

